/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.UlimitName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ulimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ulimit> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Ulimit.getter(Ulimit::nameAsString)).setter(Ulimit.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> SOFT_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("softLimit").getter(Ulimit.getter(Ulimit::softLimit)).setter(Ulimit.setter(Builder::softLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softLimit").build()}).build();
    private static final SdkField<Integer> HARD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("hardLimit").getter(Ulimit.getter(Ulimit::hardLimit)).setter(Ulimit.setter(Builder::hardLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOFT_LIMIT_FIELD, HARD_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer softLimit;
    private final Integer hardLimit;

    private Ulimit(BuilderImpl builder) {
        this.name = builder.name;
        this.softLimit = builder.softLimit;
        this.hardLimit = builder.hardLimit;
    }

    public final UlimitName name() {
        return UlimitName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Integer softLimit() {
        return this.softLimit;
    }

    public final Integer hardLimit() {
        return this.hardLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hardLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ulimit)) {
            return false;
        }
        Ulimit other = (Ulimit)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.softLimit(), other.softLimit()) && Objects.equals(this.hardLimit(), other.hardLimit());
    }

    public final String toString() {
        return ToString.builder((String)"Ulimit").add("Name", (Object)this.nameAsString()).add("SoftLimit", (Object)this.softLimit()).add("HardLimit", (Object)this.hardLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "softLimit": {
                return Optional.ofNullable(clazz.cast(this.softLimit()));
            }
            case "hardLimit": {
                return Optional.ofNullable(clazz.cast(this.hardLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ulimit, T> g) {
        return obj -> g.apply((Ulimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer softLimit;
        private Integer hardLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Ulimit model) {
            this.name(model.name);
            this.softLimit(model.softLimit);
            this.hardLimit(model.hardLimit);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(UlimitName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getSoftLimit() {
            return this.softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        public final Integer getHardLimit() {
            return this.hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        public Ulimit build() {
            return new Ulimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ulimit> {
        public Builder name(String var1);

        public Builder name(UlimitName var1);

        public Builder softLimit(Integer var1);

        public Builder hardLimit(Integer var1);
    }
}

