/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerAuthorizationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FSxWindowsFileServerVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FSxWindowsFileServerVolumeConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileSystemId").getter(FSxWindowsFileServerVolumeConfiguration.getter(FSxWindowsFileServerVolumeConfiguration::fileSystemId)).setter(FSxWindowsFileServerVolumeConfiguration.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemId").build()}).build();
    private static final SdkField<String> ROOT_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootDirectory").getter(FSxWindowsFileServerVolumeConfiguration.getter(FSxWindowsFileServerVolumeConfiguration::rootDirectory)).setter(FSxWindowsFileServerVolumeConfiguration.setter(Builder::rootDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDirectory").build()}).build();
    private static final SdkField<FSxWindowsFileServerAuthorizationConfig> AUTHORIZATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizationConfig").getter(FSxWindowsFileServerVolumeConfiguration.getter(FSxWindowsFileServerVolumeConfiguration::authorizationConfig)).setter(FSxWindowsFileServerVolumeConfiguration.setter(Builder::authorizationConfig)).constructor(FSxWindowsFileServerAuthorizationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_ID_FIELD, ROOT_DIRECTORY_FIELD, AUTHORIZATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileSystemId;
    private final String rootDirectory;
    private final FSxWindowsFileServerAuthorizationConfig authorizationConfig;

    private FSxWindowsFileServerVolumeConfiguration(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.rootDirectory = builder.rootDirectory;
        this.authorizationConfig = builder.authorizationConfig;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final String rootDirectory() {
        return this.rootDirectory;
    }

    public final FSxWindowsFileServerAuthorizationConfig authorizationConfig() {
        return this.authorizationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FSxWindowsFileServerVolumeConfiguration)) {
            return false;
        }
        FSxWindowsFileServerVolumeConfiguration other = (FSxWindowsFileServerVolumeConfiguration)obj;
        return Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.rootDirectory(), other.rootDirectory()) && Objects.equals(this.authorizationConfig(), other.authorizationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"FSxWindowsFileServerVolumeConfiguration").add("FileSystemId", (Object)this.fileSystemId()).add("RootDirectory", (Object)this.rootDirectory()).add("AuthorizationConfig", (Object)this.authorizationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "rootDirectory": {
                return Optional.ofNullable(clazz.cast(this.rootDirectory()));
            }
            case "authorizationConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FSxWindowsFileServerVolumeConfiguration, T> g) {
        return obj -> g.apply((FSxWindowsFileServerVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileSystemId;
        private String rootDirectory;
        private FSxWindowsFileServerAuthorizationConfig authorizationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FSxWindowsFileServerVolumeConfiguration model) {
            this.fileSystemId(model.fileSystemId);
            this.rootDirectory(model.rootDirectory);
            this.authorizationConfig(model.authorizationConfig);
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        @Transient
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getRootDirectory() {
            return this.rootDirectory;
        }

        public final void setRootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
        }

        @Override
        @Transient
        public final Builder rootDirectory(String rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public final FSxWindowsFileServerAuthorizationConfig.Builder getAuthorizationConfig() {
            return this.authorizationConfig != null ? this.authorizationConfig.toBuilder() : null;
        }

        public final void setAuthorizationConfig(FSxWindowsFileServerAuthorizationConfig.BuilderImpl authorizationConfig) {
            this.authorizationConfig = authorizationConfig != null ? authorizationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder authorizationConfig(FSxWindowsFileServerAuthorizationConfig authorizationConfig) {
            this.authorizationConfig = authorizationConfig;
            return this;
        }

        public FSxWindowsFileServerVolumeConfiguration build() {
            return new FSxWindowsFileServerVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FSxWindowsFileServerVolumeConfiguration> {
        public Builder fileSystemId(String var1);

        public Builder rootDirectory(String var1);

        public Builder authorizationConfig(FSxWindowsFileServerAuthorizationConfig var1);

        default public Builder authorizationConfig(Consumer<FSxWindowsFileServerAuthorizationConfig.Builder> authorizationConfig) {
            return this.authorizationConfig((FSxWindowsFileServerAuthorizationConfig)((FSxWindowsFileServerAuthorizationConfig.Builder)FSxWindowsFileServerAuthorizationConfig.builder().applyMutation(authorizationConfig)).build());
        }
    }
}

