/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The execute command configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterConfiguration.Builder, ClusterConfiguration> {
    private static final SdkField<ExecuteCommandConfiguration> EXECUTE_COMMAND_CONFIGURATION_FIELD = SdkField
            .<ExecuteCommandConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("executeCommandConfiguration")
            .getter(getter(ClusterConfiguration::executeCommandConfiguration))
            .setter(setter(Builder::executeCommandConfiguration))
            .constructor(ExecuteCommandConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executeCommandConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXECUTE_COMMAND_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExecuteCommandConfiguration executeCommandConfiguration;

    private ClusterConfiguration(BuilderImpl builder) {
        this.executeCommandConfiguration = builder.executeCommandConfiguration;
    }

    /**
     * <p>
     * The details of the execute command configuration.
     * </p>
     * 
     * @return The details of the execute command configuration.
     */
    public final ExecuteCommandConfiguration executeCommandConfiguration() {
        return executeCommandConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executeCommandConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterConfiguration)) {
            return false;
        }
        ClusterConfiguration other = (ClusterConfiguration) obj;
        return Objects.equals(executeCommandConfiguration(), other.executeCommandConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterConfiguration").add("ExecuteCommandConfiguration", executeCommandConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executeCommandConfiguration":
            return Optional.ofNullable(clazz.cast(executeCommandConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterConfiguration, T> g) {
        return obj -> g.apply((ClusterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterConfiguration> {
        /**
         * <p>
         * The details of the execute command configuration.
         * </p>
         * 
         * @param executeCommandConfiguration
         *        The details of the execute command configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executeCommandConfiguration(ExecuteCommandConfiguration executeCommandConfiguration);

        /**
         * <p>
         * The details of the execute command configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecuteCommandConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExecuteCommandConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecuteCommandConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #executeCommandConfiguration(ExecuteCommandConfiguration)}.
         * 
         * @param executeCommandConfiguration
         *        a consumer that will call methods on {@link ExecuteCommandConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executeCommandConfiguration(ExecuteCommandConfiguration)
         */
        default Builder executeCommandConfiguration(Consumer<ExecuteCommandConfiguration.Builder> executeCommandConfiguration) {
            return executeCommandConfiguration(ExecuteCommandConfiguration.builder().applyMutation(executeCommandConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExecuteCommandConfiguration executeCommandConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterConfiguration model) {
            executeCommandConfiguration(model.executeCommandConfiguration);
        }

        public final ExecuteCommandConfiguration.Builder getExecuteCommandConfiguration() {
            return executeCommandConfiguration != null ? executeCommandConfiguration.toBuilder() : null;
        }

        public final void setExecuteCommandConfiguration(ExecuteCommandConfiguration.BuilderImpl executeCommandConfiguration) {
            this.executeCommandConfiguration = executeCommandConfiguration != null ? executeCommandConfiguration.build() : null;
        }

        @Override
        public final Builder executeCommandConfiguration(ExecuteCommandConfiguration executeCommandConfiguration) {
            this.executeCommandConfiguration = executeCommandConfiguration;
            return this;
        }

        @Override
        public ClusterConfiguration build() {
            return new ClusterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
