/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the secret to expose to your container. Secrets can be exposed to a container in the following
 * ways:
 * </p>
 * <ul>
 * <li>
 * <p>
 * To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container
 * definition parameter.
 * </p>
 * </li>
 * <li>
 * <p>
 * To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code>
 * container definition parameter.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying
 * Sensitive Data</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Secret implements SdkPojo, Serializable, ToCopyableBuilder<Secret.Builder, Secret> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Secret::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueFrom").getter(getter(Secret::valueFrom)).setter(setter(Builder::valueFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueFrom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FROM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String valueFrom;

    private Secret(BuilderImpl builder) {
        this.name = builder.name;
        this.valueFrom = builder.valueFrom;
    }

    /**
     * <p>
     * The name of the secret.
     * </p>
     * 
     * @return The name of the secret.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The secret to expose to the container. The supported values are either the full ARN of the Secrets Manager secret
     * or the full ARN of the parameter in the SSM Parameter Store.
     * </p>
     * <p>
     * For information about the require Identity and Access Management permissions, see <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam"
     * >Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html"
     * >Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <i>Amazon
     * Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use
     * either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN
     * must be specified.
     * </p>
     * </note>
     * 
     * @return The secret to expose to the container. The supported values are either the full ARN of the Secrets
     *         Manager secret or the full ARN of the parameter in the SSM Parameter Store.</p>
     *         <p>
     *         For information about the require Identity and Access Management permissions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam"
     *         >Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html"
     *         >Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the
     *         <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         <note>
     *         <p>
     *         If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can
     *         use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the
     *         full ARN must be specified.
     *         </p>
     */
    public final String valueFrom() {
        return valueFrom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueFrom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Secret)) {
            return false;
        }
        Secret other = (Secret) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(valueFrom(), other.valueFrom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Secret").add("Name", name()).add("ValueFrom", valueFrom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "valueFrom":
            return Optional.ofNullable(clazz.cast(valueFrom()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Secret, T> g) {
        return obj -> g.apply((Secret) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Secret> {
        /**
         * <p>
         * The name of the secret.
         * </p>
         * 
         * @param name
         *        The name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The secret to expose to the container. The supported values are either the full ARN of the Secrets Manager
         * secret or the full ARN of the parameter in the SSM Parameter Store.
         * </p>
         * <p>
         * For information about the require Identity and Access Management permissions, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam"
         * >Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html"
         * >Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <i>Amazon
         * Elastic Container Service Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use
         * either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full
         * ARN must be specified.
         * </p>
         * </note>
         * 
         * @param valueFrom
         *        The secret to expose to the container. The supported values are either the full ARN of the Secrets
         *        Manager secret or the full ARN of the parameter in the SSM Parameter Store.</p>
         *        <p>
         *        For information about the require Identity and Access Management permissions, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam"
         *        >Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html"
         *        >Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the
         *        <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        <note>
         *        <p>
         *        If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you
         *        can use either the full ARN or name of the parameter. If the parameter exists in a different Region,
         *        then the full ARN must be specified.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueFrom(String valueFrom);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String valueFrom;

        private BuilderImpl() {
        }

        private BuilderImpl(Secret model) {
            name(model.name);
            valueFrom(model.valueFrom);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueFrom() {
            return valueFrom;
        }

        public final void setValueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
        }

        @Override
        public final Builder valueFrom(String valueFrom) {
            this.valueFrom = valueFrom;
            return this;
        }

        @Override
        public Secret build() {
            return new Secret(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
