/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTaskDefinitionsRequest extends EcsRequest implements
        ToCopyableBuilder<ListTaskDefinitionsRequest.Builder, ListTaskDefinitionsRequest> {
    private static final SdkField<String> FAMILY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("familyPrefix").getter(getter(ListTaskDefinitionsRequest::familyPrefix))
            .setter(setter(Builder::familyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("familyPrefix").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListTaskDefinitionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sort")
            .getter(getter(ListTaskDefinitionsRequest::sortAsString)).setter(setter(Builder::sort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTaskDefinitionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTaskDefinitionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_PREFIX_FIELD,
            STATUS_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String familyPrefix;

    private final String status;

    private final String sort;

    private final String nextToken;

    private final Integer maxResults;

    private ListTaskDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.familyPrefix = builder.familyPrefix;
        this.status = builder.status;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a
     * <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to that
     * family.
     * </p>
     * 
     * @return The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a
     *         <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to
     *         that family.
     */
    public final String familyPrefix() {
        return familyPrefix;
    }

    /**
     * <p>
     * The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
     * <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can view
     * task definitions that are <code>INACTIVE</code> as long as an active task or service still references them. If
     * you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
     *         <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you
     *         can view task definitions that are <code>INACTIVE</code> as long as an active task or service still
     *         references them. If you paginate the resulting output, be sure to keep the <code>status</code> value
     *         constant in each subsequent request.
     * @see TaskDefinitionStatus
     */
    public final TaskDefinitionStatus status() {
        return TaskDefinitionStatus.fromValue(status);
    }

    /**
     * <p>
     * The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
     * <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can view
     * task definitions that are <code>INACTIVE</code> as long as an active task or service still references them. If
     * you paginate the resulting output, be sure to keep the <code>status</code> value constant in each subsequent
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
     *         <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you
     *         can view task definitions that are <code>INACTIVE</code> as long as an active task or service still
     *         references them. If you paginate the resulting output, be sure to keep the <code>status</code> value
     *         constant in each subsequent request.
     * @see TaskDefinitionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
     * <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical order
     * by revision so that the newest task definitions in a family are listed last. Setting this parameter to
     * <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
     * definitions in a family are listed first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
     *         <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical
     *         order by revision so that the newest task definitions in a family are listed last. Setting this parameter
     *         to <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
     *         definitions in a family are listed first.
     * @see SortOrder
     */
    public final SortOrder sort() {
        return SortOrder.fromValue(sort);
    }

    /**
     * <p>
     * The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
     * <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical order
     * by revision so that the newest task definitions in a family are listed last. Setting this parameter to
     * <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
     * definitions in a family are listed first.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
     *         <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical
     *         order by revision so that the newest task definitions in a family are listed last. Setting this parameter
     *         to <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
     *         definitions in a family are listed first.
     * @see SortOrder
     */
    public final String sortAsString() {
        return sort;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that more
     * results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was
     * provided, it is possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that
     *         more results are available to fulfill the request and further calls will be needed. If
     *         <code>maxResults</code> was provided, it is possible the number of results to be fewer than
     *         <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated output.
     * When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code> results in a
     * single page along with a <code>nextToken</code> response element. The remaining results of the initial request
     * can be seen by sending another <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code>
     * returns up to 100 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated
     *         output. When this parameter is used, <code>ListTaskDefinitions</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code> value. This value can
     *         be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code> returns up to
     *         100 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(familyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionsRequest)) {
            return false;
        }
        ListTaskDefinitionsRequest other = (ListTaskDefinitionsRequest) obj;
        return Objects.equals(familyPrefix(), other.familyPrefix()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sortAsString(), other.sortAsString()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTaskDefinitionsRequest").add("FamilyPrefix", familyPrefix()).add("Status", statusAsString())
                .add("Sort", sortAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "familyPrefix":
            return Optional.ofNullable(clazz.cast(familyPrefix()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sortAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionsRequest, T> g) {
        return obj -> g.apply((ListTaskDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTaskDefinitionsRequest> {
        /**
         * <p>
         * The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a
         * <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong to that
         * family.
         * </p>
         * 
         * @param familyPrefix
         *        The full family name to filter the <code>ListTaskDefinitions</code> results with. Specifying a
         *        <code>familyPrefix</code> limits the listed task definitions to task definition revisions that belong
         *        to that family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder familyPrefix(String familyPrefix);

        /**
         * <p>
         * The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
         * <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can
         * view task definitions that are <code>INACTIVE</code> as long as an active task or service still references
         * them. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each
         * subsequent request.
         * </p>
         * 
         * @param status
         *        The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default,
         *        only <code>ACTIVE</code> task definitions are listed. By setting this parameter to
         *        <code>INACTIVE</code>, you can view task definitions that are <code>INACTIVE</code> as long as an
         *        active task or service still references them. If you paginate the resulting output, be sure to keep
         *        the <code>status</code> value constant in each subsequent request.
         * @see TaskDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskDefinitionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default, only
         * <code>ACTIVE</code> task definitions are listed. By setting this parameter to <code>INACTIVE</code>, you can
         * view task definitions that are <code>INACTIVE</code> as long as an active task or service still references
         * them. If you paginate the resulting output, be sure to keep the <code>status</code> value constant in each
         * subsequent request.
         * </p>
         * 
         * @param status
         *        The task definition status to filter the <code>ListTaskDefinitions</code> results with. By default,
         *        only <code>ACTIVE</code> task definitions are listed. By setting this parameter to
         *        <code>INACTIVE</code>, you can view task definitions that are <code>INACTIVE</code> as long as an
         *        active task or service still references them. If you paginate the resulting output, be sure to keep
         *        the <code>status</code> value constant in each subsequent request.
         * @see TaskDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskDefinitionStatus
         */
        Builder status(TaskDefinitionStatus status);

        /**
         * <p>
         * The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
         * <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical
         * order by revision so that the newest task definitions in a family are listed last. Setting this parameter to
         * <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
         * definitions in a family are listed first.
         * </p>
         * 
         * @param sort
         *        The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default,
         *        (<code>ASC</code>) task definitions are listed lexicographically by family name and in ascending
         *        numerical order by revision so that the newest task definitions in a family are listed last. Setting
         *        this parameter to <code>DESC</code> reverses the sort order on family name and revision. This is so
         *        that the newest task definitions in a family are listed first.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sort(String sort);

        /**
         * <p>
         * The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default, (
         * <code>ASC</code>) task definitions are listed lexicographically by family name and in ascending numerical
         * order by revision so that the newest task definitions in a family are listed last. Setting this parameter to
         * <code>DESC</code> reverses the sort order on family name and revision. This is so that the newest task
         * definitions in a family are listed first.
         * </p>
         * 
         * @param sort
         *        The order to sort the results in. Valid values are <code>ASC</code> and <code>DESC</code>. By default,
         *        (<code>ASC</code>) task definitions are listed lexicographically by family name and in ascending
         *        numerical order by revision so that the newest task definitions in a family are listed last. Setting
         *        this parameter to <code>DESC</code> reverses the sort order on family name and revision. This is so
         *        that the newest task definitions in a family are listed first.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sort(SortOrder sort);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating that
         * more results are available to fulfill the request and further calls will be needed. If
         * <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         * <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListTaskDefinitions</code> request indicating
         *        that more results are available to fulfill the request and further calls will be needed. If
         *        <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in paginated
         * output. When this parameter is used, <code>ListTaskDefinitions</code> only returns <code>maxResults</code>
         * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
         * initial request can be seen by sending another <code>ListTaskDefinitions</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         * <code>ListTaskDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of task definition results that <code>ListTaskDefinitions</code> returned in
         *        paginated output. When this parameter is used, <code>ListTaskDefinitions</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListTaskDefinitions</code> request with the returned <code>nextToken</code> value. This value
         *        can be between 1 and 100. If this parameter isn't used, then <code>ListTaskDefinitions</code> returns
         *        up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String familyPrefix;

        private String status;

        private String sort;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionsRequest model) {
            super(model);
            familyPrefix(model.familyPrefix);
            status(model.status);
            sort(model.sort);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getFamilyPrefix() {
            return familyPrefix;
        }

        public final void setFamilyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
        }

        @Override
        public final Builder familyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskDefinitionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSort() {
            return sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(SortOrder sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTaskDefinitionsRequest build() {
            return new ListTaskDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
