/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskSetsResponse extends EcsResponse implements
        ToCopyableBuilder<DescribeTaskSetsResponse.Builder, DescribeTaskSetsResponse> {
    private static final SdkField<List<TaskSet>> TASK_SETS_FIELD = SdkField
            .<List<TaskSet>> builder(MarshallingType.LIST)
            .memberName("taskSets")
            .getter(getter(DescribeTaskSetsResponse::taskSets))
            .setter(setter(Builder::taskSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(DescribeTaskSetsResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_SETS_FIELD,
            FAILURES_FIELD));

    private final List<TaskSet> taskSets;

    private final List<Failure> failures;

    private DescribeTaskSetsResponse(BuilderImpl builder) {
        super(builder);
        this.taskSets = builder.taskSets;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskSets() {
        return taskSets != null && !(taskSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of task sets described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskSets} method.
     * </p>
     * 
     * @return The list of task sets described.
     */
    public final List<TaskSet> taskSets() {
        return taskSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskSets() ? taskSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskSetsResponse)) {
            return false;
        }
        DescribeTaskSetsResponse other = (DescribeTaskSetsResponse) obj;
        return hasTaskSets() == other.hasTaskSets() && Objects.equals(taskSets(), other.taskSets())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTaskSetsResponse").add("TaskSets", hasTaskSets() ? taskSets() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskSets":
            return Optional.ofNullable(clazz.cast(taskSets()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskSetsResponse, T> g) {
        return obj -> g.apply((DescribeTaskSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskSetsResponse> {
        /**
         * <p>
         * The list of task sets described.
         * </p>
         * 
         * @param taskSets
         *        The list of task sets described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(Collection<TaskSet> taskSets);

        /**
         * <p>
         * The list of task sets described.
         * </p>
         * 
         * @param taskSets
         *        The list of task sets described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(TaskSet... taskSets);

        /**
         * <p>
         * The list of task sets described.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TaskSet>.Builder} avoiding the need
         * to create one manually via {@link List<TaskSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskSet>.Builder#build()} is called immediately and its
         * result is passed to {@link #taskSets(List<TaskSet>)}.
         * 
         * @param taskSets
         *        a consumer that will call methods on {@link List<TaskSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSets(List<TaskSet>)
         */
        Builder taskSets(Consumer<TaskSet.Builder>... taskSets);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Failure>.Builder} avoiding the need
         * to create one manually via {@link List<Failure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Failure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<Failure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<TaskSet> taskSets = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskSetsResponse model) {
            super(model);
            taskSets(model.taskSets);
            failures(model.failures);
        }

        public final List<TaskSet.Builder> getTaskSets() {
            List<TaskSet.Builder> result = TaskSetsCopier.copyToBuilder(this.taskSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskSets(Collection<TaskSet.BuilderImpl> taskSets) {
            this.taskSets = TaskSetsCopier.copyFromBuilder(taskSets);
        }

        @Override
        public final Builder taskSets(Collection<TaskSet> taskSets) {
            this.taskSets = TaskSetsCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(TaskSet... taskSets) {
            taskSets(Arrays.asList(taskSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(Consumer<TaskSet.Builder>... taskSets) {
            taskSets(Stream.of(taskSets).map(c -> TaskSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTaskSetsResponse build() {
            return new DescribeTaskSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
