/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteCommandResponse extends EcsResponse implements
        ToCopyableBuilder<ExecuteCommandResponse.Builder, ExecuteCommandResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ExecuteCommandResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CONTAINER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerArn").getter(getter(ExecuteCommandResponse::containerArn))
            .setter(setter(Builder::containerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerArn").build()).build();

    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerName").getter(getter(ExecuteCommandResponse::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()).build();

    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("interactive").getter(getter(ExecuteCommandResponse::interactive)).setter(setter(Builder::interactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactive").build()).build();

    private static final SdkField<Session> SESSION_FIELD = SdkField.<Session> builder(MarshallingType.SDK_POJO)
            .memberName("session").getter(getter(ExecuteCommandResponse::session)).setter(setter(Builder::session))
            .constructor(Session::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("session").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(ExecuteCommandResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CONTAINER_ARN_FIELD, CONTAINER_NAME_FIELD, INTERACTIVE_FIELD, SESSION_FIELD, TASK_ARN_FIELD));

    private final String clusterArn;

    private final String containerArn;

    private final String containerName;

    private final Boolean interactive;

    private final Session session;

    private final String taskArn;

    private ExecuteCommandResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.containerArn = builder.containerArn;
        this.containerName = builder.containerName;
        this.interactive = builder.interactive;
        this.session = builder.session;
        this.taskArn = builder.taskArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container.
     */
    public final String containerArn() {
        return containerArn;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * Determines whether the execute command session is running in interactive mode. Amazon ECS only supports
     * initiating interactive sessions, so you must specify <code>true</code> for this value.
     * </p>
     * 
     * @return Determines whether the execute command session is running in interactive mode. Amazon ECS only supports
     *         initiating interactive sessions, so you must specify <code>true</code> for this value.
     */
    public final Boolean interactive() {
        return interactive;
    }

    /**
     * <p>
     * The details of the SSM session that was created for this instance of execute-command.
     * </p>
     * 
     * @return The details of the SSM session that was created for this instance of execute-command.
     */
    public final Session session() {
        return session;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task.
     */
    public final String taskArn() {
        return taskArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(containerArn());
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(interactive());
        hashCode = 31 * hashCode + Objects.hashCode(session());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandResponse)) {
            return false;
        }
        ExecuteCommandResponse other = (ExecuteCommandResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(containerArn(), other.containerArn())
                && Objects.equals(containerName(), other.containerName()) && Objects.equals(interactive(), other.interactive())
                && Objects.equals(session(), other.session()) && Objects.equals(taskArn(), other.taskArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteCommandResponse").add("ClusterArn", clusterArn()).add("ContainerArn", containerArn())
                .add("ContainerName", containerName()).add("Interactive", interactive()).add("Session", session())
                .add("TaskArn", taskArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "containerArn":
            return Optional.ofNullable(clazz.cast(containerArn()));
        case "containerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "interactive":
            return Optional.ofNullable(clazz.cast(interactive()));
        case "session":
            return Optional.ofNullable(clazz.cast(session()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandResponse, T> g) {
        return obj -> g.apply((ExecuteCommandResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteCommandResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container.
         * </p>
         * 
         * @param containerArn
         *        The Amazon Resource Name (ARN) of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerArn(String containerArn);

        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param containerName
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * Determines whether the execute command session is running in interactive mode. Amazon ECS only supports
         * initiating interactive sessions, so you must specify <code>true</code> for this value.
         * </p>
         * 
         * @param interactive
         *        Determines whether the execute command session is running in interactive mode. Amazon ECS only
         *        supports initiating interactive sessions, so you must specify <code>true</code> for this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactive(Boolean interactive);

        /**
         * <p>
         * The details of the SSM session that was created for this instance of execute-command.
         * </p>
         * 
         * @param session
         *        The details of the SSM session that was created for this instance of execute-command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder session(Session session);

        /**
         * <p>
         * The details of the SSM session that was created for this instance of execute-command.
         * </p>
         * This is a convenience method that creates an instance of the {@link Session.Builder} avoiding the need to
         * create one manually via {@link Session#builder()}.
         *
         * When the {@link Consumer} completes, {@link Session.Builder#build()} is called immediately and its result is
         * passed to {@link #session(Session)}.
         * 
         * @param session
         *        a consumer that will call methods on {@link Session.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #session(Session)
         */
        default Builder session(Consumer<Session.Builder> session) {
            return session(Session.builder().applyMutation(session).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private String containerArn;

        private String containerName;

        private Boolean interactive;

        private Session session;

        private String taskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            containerArn(model.containerArn);
            containerName(model.containerName);
            interactive(model.interactive);
            session(model.session);
            taskArn(model.taskArn);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getContainerArn() {
            return containerArn;
        }

        public final void setContainerArn(String containerArn) {
            this.containerArn = containerArn;
        }

        @Override
        public final Builder containerArn(String containerArn) {
            this.containerArn = containerArn;
            return this;
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Boolean getInteractive() {
            return interactive;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        @Override
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final Session.Builder getSession() {
            return session != null ? session.toBuilder() : null;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        @Override
        public ExecuteCommandResponse build() {
            return new ExecuteCommandResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
