/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the platform for the Amazon ECS service or task.
 * </p>
 * <p>
 * For more informataion about <code>RuntimePlatform</code>, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform"
 * >RuntimePlatform</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuntimePlatform implements SdkPojo, Serializable, ToCopyableBuilder<RuntimePlatform.Builder, RuntimePlatform> {
    private static final SdkField<String> CPU_ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpuArchitecture").getter(getter(RuntimePlatform::cpuArchitectureAsString))
            .setter(setter(Builder::cpuArchitecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitecture").build()).build();

    private static final SdkField<String> OPERATING_SYSTEM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operatingSystemFamily").getter(getter(RuntimePlatform::operatingSystemFamilyAsString))
            .setter(setter(Builder::operatingSystemFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystemFamily").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_ARCHITECTURE_FIELD,
            OPERATING_SYSTEM_FAMILY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cpuArchitecture;

    private final String operatingSystemFamily;

    private RuntimePlatform(BuilderImpl builder) {
        this.cpuArchitecture = builder.cpuArchitecture;
        this.operatingSystemFamily = builder.operatingSystemFamily;
    }

    /**
     * <p>
     * The CPU architecture.
     * </p>
     * <p>
     * You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This option is
     * avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cpuArchitecture}
     * will return {@link CPUArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cpuArchitectureAsString}.
     * </p>
     * 
     * @return The CPU architecture.</p>
     *         <p>
     *         You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This
     *         option is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
     * @see CPUArchitecture
     */
    public final CPUArchitecture cpuArchitecture() {
        return CPUArchitecture.fromValue(cpuArchitecture);
    }

    /**
     * <p>
     * The CPU architecture.
     * </p>
     * <p>
     * You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This option is
     * avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cpuArchitecture}
     * will return {@link CPUArchitecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cpuArchitectureAsString}.
     * </p>
     * 
     * @return The CPU architecture.</p>
     *         <p>
     *         You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This
     *         option is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
     * @see CPUArchitecture
     */
    public final String cpuArchitectureAsString() {
        return cpuArchitecture;
    }

    /**
     * <p>
     * The operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #operatingSystemFamily} will return {@link OSFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #operatingSystemFamilyAsString}.
     * </p>
     * 
     * @return The operating system.
     * @see OSFamily
     */
    public final OSFamily operatingSystemFamily() {
        return OSFamily.fromValue(operatingSystemFamily);
    }

    /**
     * <p>
     * The operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #operatingSystemFamily} will return {@link OSFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #operatingSystemFamilyAsString}.
     * </p>
     * 
     * @return The operating system.
     * @see OSFamily
     */
    public final String operatingSystemFamilyAsString() {
        return operatingSystemFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpuArchitectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemFamilyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimePlatform)) {
            return false;
        }
        RuntimePlatform other = (RuntimePlatform) obj;
        return Objects.equals(cpuArchitectureAsString(), other.cpuArchitectureAsString())
                && Objects.equals(operatingSystemFamilyAsString(), other.operatingSystemFamilyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuntimePlatform").add("CpuArchitecture", cpuArchitectureAsString())
                .add("OperatingSystemFamily", operatingSystemFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cpuArchitecture":
            return Optional.ofNullable(clazz.cast(cpuArchitectureAsString()));
        case "operatingSystemFamily":
            return Optional.ofNullable(clazz.cast(operatingSystemFamilyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimePlatform, T> g) {
        return obj -> g.apply((RuntimePlatform) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuntimePlatform> {
        /**
         * <p>
         * The CPU architecture.
         * </p>
         * <p>
         * You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This option
         * is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
         * </p>
         * 
         * @param cpuArchitecture
         *        The CPU architecture.</p>
         *        <p>
         *        You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This
         *        option is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
         * @see CPUArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CPUArchitecture
         */
        Builder cpuArchitecture(String cpuArchitecture);

        /**
         * <p>
         * The CPU architecture.
         * </p>
         * <p>
         * You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This option
         * is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
         * </p>
         * 
         * @param cpuArchitecture
         *        The CPU architecture.</p>
         *        <p>
         *        You can run your Linux tasks on an ARM-based platform by setting the value to <code>ARM64</code>. This
         *        option is avaiable for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
         * @see CPUArchitecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CPUArchitecture
         */
        Builder cpuArchitecture(CPUArchitecture cpuArchitecture);

        /**
         * <p>
         * The operating system.
         * </p>
         * 
         * @param operatingSystemFamily
         *        The operating system.
         * @see OSFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSFamily
         */
        Builder operatingSystemFamily(String operatingSystemFamily);

        /**
         * <p>
         * The operating system.
         * </p>
         * 
         * @param operatingSystemFamily
         *        The operating system.
         * @see OSFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OSFamily
         */
        Builder operatingSystemFamily(OSFamily operatingSystemFamily);
    }

    static final class BuilderImpl implements Builder {
        private String cpuArchitecture;

        private String operatingSystemFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimePlatform model) {
            cpuArchitecture(model.cpuArchitecture);
            operatingSystemFamily(model.operatingSystemFamily);
        }

        public final String getCpuArchitecture() {
            return cpuArchitecture;
        }

        public final void setCpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
        }

        @Override
        public final Builder cpuArchitecture(String cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        @Override
        public final Builder cpuArchitecture(CPUArchitecture cpuArchitecture) {
            this.cpuArchitecture(cpuArchitecture == null ? null : cpuArchitecture.toString());
            return this;
        }

        public final String getOperatingSystemFamily() {
            return operatingSystemFamily;
        }

        public final void setOperatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
        }

        @Override
        public final Builder operatingSystemFamily(String operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
            return this;
        }

        @Override
        public final Builder operatingSystemFamily(OSFamily operatingSystemFamily) {
            this.operatingSystemFamily(operatingSystemFamily == null ? null : operatingSystemFamily.toString());
            return this;
        }

        @Override
        public RuntimePlatform build() {
            return new RuntimePlatform(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
