/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateClusterRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField
            .<List<ClusterSetting>> builder(MarshallingType.LIST)
            .memberName("settings")
            .getter(getter(UpdateClusterRequest::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClusterConfiguration> CONFIGURATION_FIELD = SdkField
            .<ClusterConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateClusterRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ClusterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SETTINGS_FIELD,
            CONFIGURATION_FIELD));

    private final String cluster;

    private final List<ClusterSetting> settings;

    private final ClusterConfiguration configuration;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.settings = builder.settings;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The name of the cluster to modify the settings for.
     * </p>
     * 
     * @return The name of the cluster to modify the settings for.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cluster settings for your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return The cluster settings for your cluster.
     */
    public final List<ClusterSetting> settings() {
        return settings;
    }

    /**
     * <p>
     * The execute command configuration for the cluster.
     * </p>
     * 
     * @return The execute command configuration for the cluster.
     */
    public final ClusterConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasSettings() == other.hasSettings()
                && Objects.equals(settings(), other.settings()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("Cluster", cluster())
                .add("Settings", hasSettings() ? settings() : null).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The name of the cluster to modify the settings for.
         * </p>
         * 
         * @param cluster
         *        The name of the cluster to modify the settings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The cluster settings for your cluster.
         * </p>
         * 
         * @param settings
         *        The cluster settings for your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Collection<ClusterSetting> settings);

        /**
         * <p>
         * The cluster settings for your cluster.
         * </p>
         * 
         * @param settings
         *        The cluster settings for your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(ClusterSetting... settings);

        /**
         * <p>
         * The cluster settings for your cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ClusterSetting>.Builder} avoiding
         * the need to create one manually via {@link List<ClusterSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(List<ClusterSetting>)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link List<ClusterSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(List<ClusterSetting>)
         */
        Builder settings(Consumer<ClusterSetting.Builder>... settings);

        /**
         * <p>
         * The execute command configuration for the cluster.
         * </p>
         * 
         * @param configuration
         *        The execute command configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ClusterConfiguration configuration);

        /**
         * <p>
         * The execute command configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterConfiguration.Builder} avoiding
         * the need to create one manually via {@link ClusterConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(ClusterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ClusterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ClusterConfiguration)
         */
        default Builder configuration(Consumer<ClusterConfiguration.Builder> configuration) {
            return configuration(ClusterConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();

        private ClusterConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            cluster(model.cluster);
            settings(model.settings);
            configuration(model.configuration);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final List<ClusterSetting.Builder> getSettings() {
            List<ClusterSetting.Builder> result = ClusterSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(ClusterSetting... settings) {
            settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder>... settings) {
            settings(Stream.of(settings).map(c -> ClusterSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ClusterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ClusterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
