/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The overrides that are associated with a task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskOverride implements SdkPojo, Serializable, ToCopyableBuilder<TaskOverride.Builder, TaskOverride> {
    private static final SdkField<List<ContainerOverride>> CONTAINER_OVERRIDES_FIELD = SdkField
            .<List<ContainerOverride>> builder(MarshallingType.LIST)
            .memberName("containerOverrides")
            .getter(getter(TaskOverride::containerOverrides))
            .setter(setter(Builder::containerOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(TaskOverride::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<List<InferenceAcceleratorOverride>> INFERENCE_ACCELERATOR_OVERRIDES_FIELD = SdkField
            .<List<InferenceAcceleratorOverride>> builder(MarshallingType.LIST)
            .memberName("inferenceAcceleratorOverrides")
            .getter(getter(TaskOverride::inferenceAcceleratorOverrides))
            .setter(setter(Builder::inferenceAcceleratorOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAcceleratorOverrides")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceAcceleratorOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceAcceleratorOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(TaskOverride::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(TaskOverride::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(TaskOverride::taskRoleArn)).setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField
            .<EphemeralStorage> builder(MarshallingType.SDK_POJO).memberName("ephemeralStorage")
            .getter(getter(TaskOverride::ephemeralStorage)).setter(setter(Builder::ephemeralStorage))
            .constructor(EphemeralStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_OVERRIDES_FIELD,
            CPU_FIELD, INFERENCE_ACCELERATOR_OVERRIDES_FIELD, EXECUTION_ROLE_ARN_FIELD, MEMORY_FIELD, TASK_ROLE_ARN_FIELD,
            EPHEMERAL_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ContainerOverride> containerOverrides;

    private final String cpu;

    private final List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides;

    private final String executionRoleArn;

    private final String memory;

    private final String taskRoleArn;

    private final EphemeralStorage ephemeralStorage;

    private TaskOverride(BuilderImpl builder) {
        this.containerOverrides = builder.containerOverrides;
        this.cpu = builder.cpu;
        this.inferenceAcceleratorOverrides = builder.inferenceAcceleratorOverrides;
        this.executionRoleArn = builder.executionRoleArn;
        this.memory = builder.memory;
        this.taskRoleArn = builder.taskRoleArn;
        this.ephemeralStorage = builder.ephemeralStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerOverrides property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerOverrides() {
        return containerOverrides != null && !(containerOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more container overrides that are sent to a task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerOverrides} method.
     * </p>
     * 
     * @return One or more container overrides that are sent to a task.
     */
    public final List<ContainerOverride> containerOverrides() {
        return containerOverrides;
    }

    /**
     * <p>
     * The cpu override for the task.
     * </p>
     * 
     * @return The cpu override for the task.
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceAcceleratorOverrides property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceAcceleratorOverrides() {
        return inferenceAcceleratorOverrides != null && !(inferenceAcceleratorOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Inference accelerator override for the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceAcceleratorOverrides} method.
     * </p>
     * 
     * @return The Elastic Inference accelerator override for the task.
     */
    public final List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides() {
        return inferenceAcceleratorOverrides;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task
     * execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon
     *         ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The memory override for the task.
     * </p>
     * 
     * @return The memory override for the task.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this
     * task are granted the permissions that are specified in this role. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
     *         this task are granted the permissions that are specified in this role. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for
     *         Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The ephemeral storage setting override for the task.
     * </p>
     * <note>
     * <p>
     * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Linux platform version <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Windows platform version <code>1.0.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The ephemeral storage setting override for the task.</p> <note>
     *         <p>
     *         This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Linux platform version <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Windows platform version <code>1.0.0</code> or later.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final EphemeralStorage ephemeralStorage() {
        return ephemeralStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerOverrides() ? containerOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceAcceleratorOverrides() ? inferenceAcceleratorOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskOverride)) {
            return false;
        }
        TaskOverride other = (TaskOverride) obj;
        return hasContainerOverrides() == other.hasContainerOverrides()
                && Objects.equals(containerOverrides(), other.containerOverrides()) && Objects.equals(cpu(), other.cpu())
                && hasInferenceAcceleratorOverrides() == other.hasInferenceAcceleratorOverrides()
                && Objects.equals(inferenceAcceleratorOverrides(), other.inferenceAcceleratorOverrides())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(memory(), other.memory())
                && Objects.equals(taskRoleArn(), other.taskRoleArn())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("TaskOverride")
                .add("ContainerOverrides", hasContainerOverrides() ? containerOverrides() : null)
                .add("Cpu", cpu())
                .add("InferenceAcceleratorOverrides", hasInferenceAcceleratorOverrides() ? inferenceAcceleratorOverrides() : null)
                .add("ExecutionRoleArn", executionRoleArn()).add("Memory", memory()).add("TaskRoleArn", taskRoleArn())
                .add("EphemeralStorage", ephemeralStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerOverrides":
            return Optional.ofNullable(clazz.cast(containerOverrides()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "inferenceAcceleratorOverrides":
            return Optional.ofNullable(clazz.cast(inferenceAcceleratorOverrides()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "ephemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskOverride, T> g) {
        return obj -> g.apply((TaskOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskOverride> {
        /**
         * <p>
         * One or more container overrides that are sent to a task.
         * </p>
         * 
         * @param containerOverrides
         *        One or more container overrides that are sent to a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(Collection<ContainerOverride> containerOverrides);

        /**
         * <p>
         * One or more container overrides that are sent to a task.
         * </p>
         * 
         * @param containerOverrides
         *        One or more container overrides that are sent to a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerOverrides(ContainerOverride... containerOverrides);

        /**
         * <p>
         * One or more container overrides that are sent to a task.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ContainerOverride>.Builder} avoiding
         * the need to create one manually via {@link List<ContainerOverride>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerOverride>.Builder#build()} is called immediately
         * and its result is passed to {@link #containerOverrides(List<ContainerOverride>)}.
         * 
         * @param containerOverrides
         *        a consumer that will call methods on {@link List<ContainerOverride>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerOverrides(List<ContainerOverride>)
         */
        Builder containerOverrides(Consumer<ContainerOverride.Builder>... containerOverrides);

        /**
         * <p>
         * The cpu override for the task.
         * </p>
         * 
         * @param cpu
         *        The cpu override for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The Elastic Inference accelerator override for the task.
         * </p>
         * 
         * @param inferenceAcceleratorOverrides
         *        The Elastic Inference accelerator override for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> inferenceAcceleratorOverrides);

        /**
         * <p>
         * The Elastic Inference accelerator override for the task.
         * </p>
         * 
         * @param inferenceAcceleratorOverrides
         *        The Elastic Inference accelerator override for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride... inferenceAcceleratorOverrides);

        /**
         * <p>
         * The Elastic Inference accelerator override for the task.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <InferenceAcceleratorOverride>.Builder} avoiding the need to create one manually via {@link List
         * <InferenceAcceleratorOverride>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InferenceAcceleratorOverride>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #inferenceAcceleratorOverrides(List<InferenceAcceleratorOverride>)}.
         * 
         * @param inferenceAcceleratorOverrides
         *        a consumer that will call methods on {@link List<InferenceAcceleratorOverride>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceAcceleratorOverrides(List<InferenceAcceleratorOverride>)
         */
        Builder inferenceAcceleratorOverrides(Consumer<InferenceAcceleratorOverride.Builder>... inferenceAcceleratorOverrides);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon
         * ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon
         *        ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The memory override for the task.
         * </p>
         * 
         * @param memory
         *        The memory override for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in
         * this task are granted the permissions that are specified in this role. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param taskRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers
         *        in this task are granted the permissions that are specified in this role. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for
         *        Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The ephemeral storage setting override for the task.
         * </p>
         * <note>
         * <p>
         * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Linux platform version <code>1.4.0</code> or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * Windows platform version <code>1.0.0</code> or later.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param ephemeralStorage
         *        The ephemeral storage setting override for the task.</p> <note>
         *        <p>
         *        This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Linux platform version <code>1.4.0</code> or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Windows platform version <code>1.0.0</code> or later.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(EphemeralStorage ephemeralStorage);

        /**
         * <p>
         * The ephemeral storage setting override for the task.
         * </p>
         * <note>
         * <p>
         * This parameter is only supported for tasks hosted on Fargate that use the following platform versions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Linux platform version <code>1.4.0</code> or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * Windows platform version <code>1.0.0</code> or later.
         * </p>
         * </li>
         * </ul>
         * </note> This is a convenience method that creates an instance of the {@link EphemeralStorage.Builder}
         * avoiding the need to create one manually via {@link EphemeralStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link EphemeralStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #ephemeralStorage(EphemeralStorage)}.
         * 
         * @param ephemeralStorage
         *        a consumer that will call methods on {@link EphemeralStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemeralStorage(EphemeralStorage)
         */
        default Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return ephemeralStorage(EphemeralStorage.builder().applyMutation(ephemeralStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ContainerOverride> containerOverrides = DefaultSdkAutoConstructList.getInstance();

        private String cpu;

        private List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides = DefaultSdkAutoConstructList.getInstance();

        private String executionRoleArn;

        private String memory;

        private String taskRoleArn;

        private EphemeralStorage ephemeralStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskOverride model) {
            containerOverrides(model.containerOverrides);
            cpu(model.cpu);
            inferenceAcceleratorOverrides(model.inferenceAcceleratorOverrides);
            executionRoleArn(model.executionRoleArn);
            memory(model.memory);
            taskRoleArn(model.taskRoleArn);
            ephemeralStorage(model.ephemeralStorage);
        }

        public final List<ContainerOverride.Builder> getContainerOverrides() {
            List<ContainerOverride.Builder> result = ContainerOverridesCopier.copyToBuilder(this.containerOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerOverrides(Collection<ContainerOverride.BuilderImpl> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copyFromBuilder(containerOverrides);
        }

        @Override
        public final Builder containerOverrides(Collection<ContainerOverride> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copy(containerOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(ContainerOverride... containerOverrides) {
            containerOverrides(Arrays.asList(containerOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(Consumer<ContainerOverride.Builder>... containerOverrides) {
            containerOverrides(Stream.of(containerOverrides).map(c -> ContainerOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final List<InferenceAcceleratorOverride.Builder> getInferenceAcceleratorOverrides() {
            List<InferenceAcceleratorOverride.Builder> result = InferenceAcceleratorOverridesCopier
                    .copyToBuilder(this.inferenceAcceleratorOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAcceleratorOverrides(
                Collection<InferenceAcceleratorOverride.BuilderImpl> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier
                    .copyFromBuilder(inferenceAcceleratorOverrides);
        }

        @Override
        public final Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier.copy(inferenceAcceleratorOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride... inferenceAcceleratorOverrides) {
            inferenceAcceleratorOverrides(Arrays.asList(inferenceAcceleratorOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(
                Consumer<InferenceAcceleratorOverride.Builder>... inferenceAcceleratorOverrides) {
            inferenceAcceleratorOverrides(Stream.of(inferenceAcceleratorOverrides)
                    .map(c -> InferenceAcceleratorOverride.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return ephemeralStorage != null ? ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        @Override
        public TaskOverride build() {
            return new TaskOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
