/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ClusterField {
    ATTACHMENTS("ATTACHMENTS"),
    CONFIGURATIONS("CONFIGURATIONS"),
    SETTINGS("SETTINGS"),
    STATISTICS("STATISTICS"),
    TAGS("TAGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ClusterField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ClusterField.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterField> knownValues() {
        return Stream.of(ClusterField.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

