/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ManagedScaling;
import software.amazon.awssdk.services.ecs.model.ManagedTerminationProtection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupProviderUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupProviderUpdate> {
    private static final SdkField<ManagedScaling> MANAGED_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedScaling").getter(AutoScalingGroupProviderUpdate.getter(AutoScalingGroupProviderUpdate::managedScaling)).setter(AutoScalingGroupProviderUpdate.setter(Builder::managedScaling)).constructor(ManagedScaling::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedScaling").build()}).build();
    private static final SdkField<String> MANAGED_TERMINATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedTerminationProtection").getter(AutoScalingGroupProviderUpdate.getter(AutoScalingGroupProviderUpdate::managedTerminationProtectionAsString)).setter(AutoScalingGroupProviderUpdate.setter(Builder::managedTerminationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedTerminationProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_SCALING_FIELD, MANAGED_TERMINATION_PROTECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ManagedScaling managedScaling;
    private final String managedTerminationProtection;

    private AutoScalingGroupProviderUpdate(BuilderImpl builder) {
        this.managedScaling = builder.managedScaling;
        this.managedTerminationProtection = builder.managedTerminationProtection;
    }

    public final ManagedScaling managedScaling() {
        return this.managedScaling;
    }

    public final ManagedTerminationProtection managedTerminationProtection() {
        return ManagedTerminationProtection.fromValue(this.managedTerminationProtection);
    }

    public final String managedTerminationProtectionAsString() {
        return this.managedTerminationProtection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.managedScaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedTerminationProtectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupProviderUpdate)) {
            return false;
        }
        AutoScalingGroupProviderUpdate other = (AutoScalingGroupProviderUpdate)obj;
        return Objects.equals(this.managedScaling(), other.managedScaling()) && Objects.equals(this.managedTerminationProtectionAsString(), other.managedTerminationProtectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupProviderUpdate").add("ManagedScaling", (Object)this.managedScaling()).add("ManagedTerminationProtection", (Object)this.managedTerminationProtectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "managedScaling": {
                return Optional.ofNullable(clazz.cast(this.managedScaling()));
            }
            case "managedTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.managedTerminationProtectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupProviderUpdate, T> g) {
        return obj -> g.apply((AutoScalingGroupProviderUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ManagedScaling managedScaling;
        private String managedTerminationProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupProviderUpdate model) {
            this.managedScaling(model.managedScaling);
            this.managedTerminationProtection(model.managedTerminationProtection);
        }

        public final ManagedScaling.Builder getManagedScaling() {
            return this.managedScaling != null ? this.managedScaling.toBuilder() : null;
        }

        public final void setManagedScaling(ManagedScaling.BuilderImpl managedScaling) {
            this.managedScaling = managedScaling != null ? managedScaling.build() : null;
        }

        @Override
        @Transient
        public final Builder managedScaling(ManagedScaling managedScaling) {
            this.managedScaling = managedScaling;
            return this;
        }

        public final String getManagedTerminationProtection() {
            return this.managedTerminationProtection;
        }

        public final void setManagedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
        }

        @Override
        @Transient
        public final Builder managedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
            return this;
        }

        @Override
        @Transient
        public final Builder managedTerminationProtection(ManagedTerminationProtection managedTerminationProtection) {
            this.managedTerminationProtection(managedTerminationProtection == null ? null : managedTerminationProtection.toString());
            return this;
        }

        public AutoScalingGroupProviderUpdate build() {
            return new AutoScalingGroupProviderUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupProviderUpdate> {
        public Builder managedScaling(ManagedScaling var1);

        default public Builder managedScaling(Consumer<ManagedScaling.Builder> managedScaling) {
            return this.managedScaling((ManagedScaling)((ManagedScaling.Builder)ManagedScaling.builder().applyMutation(managedScaling)).build());
        }

        public Builder managedTerminationProtection(String var1);

        public Builder managedTerminationProtection(ManagedTerminationProtection var1);
    }
}

