/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an
 * Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteCommandLogConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecuteCommandLogConfiguration.Builder, ExecuteCommandLogConfiguration> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudWatchLogGroupName").getter(getter(ExecuteCommandLogConfiguration::cloudWatchLogGroupName))
            .setter(setter(Builder::cloudWatchLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build())
            .build();

    private static final SdkField<Boolean> CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cloudWatchEncryptionEnabled")
            .getter(getter(ExecuteCommandLogConfiguration::cloudWatchEncryptionEnabled))
            .setter(setter(Builder::cloudWatchEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchEncryptionEnabled")
                    .build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketName").getter(getter(ExecuteCommandLogConfiguration::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<Boolean> S3_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("s3EncryptionEnabled").getter(getter(ExecuteCommandLogConfiguration::s3EncryptionEnabled))
            .setter(setter(Builder::s3EncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3EncryptionEnabled").build())
            .build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3KeyPrefix").getter(getter(ExecuteCommandLogConfiguration::s3KeyPrefix))
            .setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD, S3_BUCKET_NAME_FIELD,
            S3_ENCRYPTION_ENABLED_FIELD, S3_KEY_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupName;

    private final Boolean cloudWatchEncryptionEnabled;

    private final String s3BucketName;

    private final Boolean s3EncryptionEnabled;

    private final String s3KeyPrefix;

    private ExecuteCommandLogConfiguration(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
        this.s3BucketName = builder.s3BucketName;
        this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    /**
     * <p>
     * The name of the CloudWatch log group to send logs to.
     * </p>
     * <note>
     * <p>
     * The CloudWatch log group must already be created.
     * </p>
     * </note>
     * 
     * @return The name of the CloudWatch log group to send logs to.</p> <note>
     *         <p>
     *         The CloudWatch log group must already be created.
     *         </p>
     */
    public final String cloudWatchLogGroupName() {
        return cloudWatchLogGroupName;
    }

    /**
     * <p>
     * Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
     * </p>
     * 
     * @return Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be
     *         disabled.
     */
    public final Boolean cloudWatchEncryptionEnabled() {
        return cloudWatchEncryptionEnabled;
    }

    /**
     * <p>
     * The name of the S3 bucket to send logs to.
     * </p>
     * <note>
     * <p>
     * The S3 bucket must already be created.
     * </p>
     * </note>
     * 
     * @return The name of the S3 bucket to send logs to.</p> <note>
     *         <p>
     *         The S3 bucket must already be created.
     *         </p>
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
     * </p>
     * 
     * @return Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be
     *         disabled.
     */
    public final Boolean s3EncryptionEnabled() {
        return s3EncryptionEnabled;
    }

    /**
     * <p>
     * An optional folder in the S3 bucket to place logs in.
     * </p>
     * 
     * @return An optional folder in the S3 bucket to place logs in.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3EncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandLogConfiguration)) {
            return false;
        }
        ExecuteCommandLogConfiguration other = (ExecuteCommandLogConfiguration) obj;
        return Objects.equals(cloudWatchLogGroupName(), other.cloudWatchLogGroupName())
                && Objects.equals(cloudWatchEncryptionEnabled(), other.cloudWatchEncryptionEnabled())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3EncryptionEnabled(), other.s3EncryptionEnabled())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteCommandLogConfiguration").add("CloudWatchLogGroupName", cloudWatchLogGroupName())
                .add("CloudWatchEncryptionEnabled", cloudWatchEncryptionEnabled()).add("S3BucketName", s3BucketName())
                .add("S3EncryptionEnabled", s3EncryptionEnabled()).add("S3KeyPrefix", s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchLogGroupName":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupName()));
        case "cloudWatchEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchEncryptionEnabled()));
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "s3EncryptionEnabled":
            return Optional.ofNullable(clazz.cast(s3EncryptionEnabled()));
        case "s3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandLogConfiguration, T> g) {
        return obj -> g.apply((ExecuteCommandLogConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecuteCommandLogConfiguration> {
        /**
         * <p>
         * The name of the CloudWatch log group to send logs to.
         * </p>
         * <note>
         * <p>
         * The CloudWatch log group must already be created.
         * </p>
         * </note>
         * 
         * @param cloudWatchLogGroupName
         *        The name of the CloudWatch log group to send logs to.</p> <note>
         *        <p>
         *        The CloudWatch log group must already be created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupName(String cloudWatchLogGroupName);

        /**
         * <p>
         * Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
         * </p>
         * 
         * @param cloudWatchEncryptionEnabled
         *        Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be
         *        disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled);

        /**
         * <p>
         * The name of the S3 bucket to send logs to.
         * </p>
         * <note>
         * <p>
         * The S3 bucket must already be created.
         * </p>
         * </note>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket to send logs to.</p> <note>
         *        <p>
         *        The S3 bucket must already be created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be disabled.
         * </p>
         * 
         * @param s3EncryptionEnabled
         *        Whether or not to enable encryption on the CloudWatch logs. If not specified, encryption will be
         *        disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled);

        /**
         * <p>
         * An optional folder in the S3 bucket to place logs in.
         * </p>
         * 
         * @param s3KeyPrefix
         *        An optional folder in the S3 bucket to place logs in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupName;

        private Boolean cloudWatchEncryptionEnabled;

        private String s3BucketName;

        private Boolean s3EncryptionEnabled;

        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandLogConfiguration model) {
            cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            cloudWatchEncryptionEnabled(model.cloudWatchEncryptionEnabled);
            s3BucketName(model.s3BucketName);
            s3EncryptionEnabled(model.s3EncryptionEnabled);
            s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getCloudWatchLogGroupName() {
            return cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        @Transient
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final Boolean getCloudWatchEncryptionEnabled() {
            return cloudWatchEncryptionEnabled;
        }

        public final void setCloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
        }

        @Override
        @Transient
        public final Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        @Transient
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Boolean getS3EncryptionEnabled() {
            return s3EncryptionEnabled;
        }

        public final void setS3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
        }

        @Override
        @Transient
        public final Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        @Transient
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Override
        public ExecuteCommandLogConfiguration build() {
            return new ExecuteCommandLogConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
