/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitAttachmentStateChangesRequest extends EcsRequest implements
        ToCopyableBuilder<SubmitAttachmentStateChangesRequest.Builder, SubmitAttachmentStateChangesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(SubmitAttachmentStateChangesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<AttachmentStateChange>> ATTACHMENTS_FIELD = SdkField
            .<List<AttachmentStateChange>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(SubmitAttachmentStateChangesRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentStateChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentStateChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            ATTACHMENTS_FIELD));

    private final String cluster;

    private final List<AttachmentStateChange> attachments;

    private SubmitAttachmentStateChangesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.attachments = builder.attachments;
    }

    /**
     * <p>
     * The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.
     * </p>
     * 
     * @return The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any attachments associated with the state change request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return Any attachments associated with the state change request.
     */
    public final List<AttachmentStateChange> attachments() {
        return attachments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitAttachmentStateChangesRequest)) {
            return false;
        }
        SubmitAttachmentStateChangesRequest other = (SubmitAttachmentStateChangesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasAttachments() == other.hasAttachments()
                && Objects.equals(attachments(), other.attachments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitAttachmentStateChangesRequest").add("Cluster", cluster())
                .add("Attachments", hasAttachments() ? attachments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitAttachmentStateChangesRequest, T> g) {
        return obj -> g.apply((SubmitAttachmentStateChangesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitAttachmentStateChangesRequest> {
        /**
         * <p>
         * The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.
         * </p>
         * 
         * @param cluster
         *        The short name or full ARN of the cluster that hosts the container instance the attachment belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * 
         * @param attachments
         *        Any attachments associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<AttachmentStateChange> attachments);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * 
         * @param attachments
         *        Any attachments associated with the state change request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(AttachmentStateChange... attachments);

        /**
         * <p>
         * Any attachments associated with the state change request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentStateChange>.Builder} avoiding
         * the need to create one manually via {@link List<AttachmentStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentStateChange>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachments(List<AttachmentStateChange>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on {@link List<AttachmentStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(List<AttachmentStateChange>)
         */
        Builder attachments(Consumer<AttachmentStateChange.Builder>... attachments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<AttachmentStateChange> attachments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitAttachmentStateChangesRequest model) {
            super(model);
            cluster(model.cluster);
            attachments(model.attachments);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        @Transient
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final List<AttachmentStateChange.Builder> getAttachments() {
            List<AttachmentStateChange.Builder> result = AttachmentStateChangesCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentStateChange.BuilderImpl> attachments) {
            this.attachments = AttachmentStateChangesCopier.copyFromBuilder(attachments);
        }

        @Override
        @Transient
        public final Builder attachments(Collection<AttachmentStateChange> attachments) {
            this.attachments = AttachmentStateChangesCopier.copy(attachments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(AttachmentStateChange... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentStateChange.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> AttachmentStateChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitAttachmentStateChangesRequest build() {
            return new SubmitAttachmentStateChangesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
