/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContainerInstancesRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeContainerInstancesRequest.Builder, DescribeContainerInstancesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(DescribeContainerInstancesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<String>> CONTAINER_INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("containerInstances")
            .getter(getter(DescribeContainerInstancesRequest::containerInstances))
            .setter(setter(Builder::containerInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(DescribeContainerInstancesRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CONTAINER_INSTANCES_FIELD, INCLUDE_FIELD));

    private final String cluster;

    private final List<String> containerInstances;

    private final List<String> include;

    private DescribeContainerInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.containerInstances = builder.containerInstances;
        this.include = builder.include;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to describe.
     * If you do not specify a cluster, the default cluster is assumed. This parameter is required if the container
     * instance or container instances you are describing were launched in any cluster other than the default cluster.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
     *         describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if
     *         the container instance or container instances you are describing were launched in any cluster other than
     *         the default cluster.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerInstances() {
        return containerInstances != null && !(containerInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerInstances} method.
     * </p>
     * 
     * @return A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
     */
    public final List<String> containerInstances() {
        return containerInstances;
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags are not included in the
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     *         specified, the tags are included in the response. If this field is omitted, tags are not included in the
     *         response.
     */
    public final List<ContainerInstanceField> include() {
        return ContainerInstanceFieldListCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags are not included in the
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
     *         specified, the tags are included in the response. If this field is omitted, tags are not included in the
     *         response.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerInstances() ? containerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasContainerInstances() == other.hasContainerInstances()
                && Objects.equals(containerInstances(), other.containerInstances()) && hasInclude() == other.hasInclude()
                && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContainerInstancesRequest").add("Cluster", cluster())
                .add("ContainerInstances", hasContainerInstances() ? containerInstances() : null)
                .add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "containerInstances":
            return Optional.ofNullable(clazz.cast(containerInstances()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContainerInstancesRequest, T> g) {
        return obj -> g.apply((DescribeContainerInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeContainerInstancesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
         * describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required if the
         * container instance or container instances you are describing were launched in any cluster other than the
         * default cluster.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to
         *        describe. If you do not specify a cluster, the default cluster is assumed. This parameter is required
         *        if the container instance or container instances you are describing were launched in any cluster other
         *        than the default cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param containerInstances
         *        A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(Collection<String> containerInstances);

        /**
         * <p>
         * A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * </p>
         * 
         * @param containerInstances
         *        A list of up to 100 container instance IDs or full Amazon Resource Name (ARN) entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstances(String... containerInstances);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ContainerInstanceField> include);

        /**
         * <p>
         * Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags are not included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether you want to see the resource tags for the container instance. If <code>TAGS</code>
         *        is specified, the tags are included in the response. If this field is omitted, tags are not included
         *        in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ContainerInstanceField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<String> containerInstances = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContainerInstancesRequest model) {
            super(model);
            cluster(model.cluster);
            containerInstances(model.containerInstances);
            includeWithStrings(model.include);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        @Transient
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final Collection<String> getContainerInstances() {
            if (containerInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return containerInstances;
        }

        public final void setContainerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
        }

        @Override
        @Transient
        public final Builder containerInstances(Collection<String> containerInstances) {
            this.containerInstances = StringListCopier.copy(containerInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder containerInstances(String... containerInstances) {
            containerInstances(Arrays.asList(containerInstances));
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
        }

        @Override
        @Transient
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ContainerInstanceFieldListCopier.copy(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        @Transient
        public final Builder include(Collection<ContainerInstanceField> include) {
            this.include = ContainerInstanceFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder include(ContainerInstanceField... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeContainerInstancesRequest build() {
            return new DescribeContainerInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
