/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTaskDefinitionRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeTaskDefinitionRequest.Builder, DescribeTaskDefinitionRequest> {
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(DescribeTaskDefinitionRequest::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(DescribeTaskDefinitionRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_FIELD,
            INCLUDE_FIELD));

    private final String taskDefinition;

    private final List<String> include;

    private DescribeTaskDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.taskDefinition = builder.taskDefinition;
        this.include = builder.include;
    }

    /**
     * <p>
     * The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and
     * <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full Amazon
     * Resource Name (ARN) of the task definition to describe.
     * </p>
     * 
     * @return The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and
     *         <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full
     *         Amazon Resource Name (ARN) of the task definition to describe.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * <p>
     * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the tags
     * are included in the response. If this field is omitted, tags are not included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
     *         the tags are included in the response. If this field is omitted, tags are not included in the response.
     */
    public final List<TaskDefinitionField> include() {
        return TaskDefinitionFieldListCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the tags
     * are included in the response. If this field is omitted, tags are not included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
     *         the tags are included in the response. If this field is omitted, tags are not included in the response.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskDefinitionRequest)) {
            return false;
        }
        DescribeTaskDefinitionRequest other = (DescribeTaskDefinitionRequest) obj;
        return Objects.equals(taskDefinition(), other.taskDefinition()) && hasInclude() == other.hasInclude()
                && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTaskDefinitionRequest").add("TaskDefinition", taskDefinition())
                .add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskDefinitionRequest, T> g) {
        return obj -> g.apply((DescribeTaskDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTaskDefinitionRequest> {
        /**
         * <p>
         * The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and
         * <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full Amazon
         * Resource Name (ARN) of the task definition to describe.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> for the latest <code>ACTIVE</code> revision, <code>family</code> and
         *        <code>revision</code> (<code>family:revision</code>) for a specific revision in the family, or full
         *        Amazon Resource Name (ARN) of the task definition to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the
         * tags are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the
         * tags are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the
         * tags are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<TaskDefinitionField> include);

        /**
         * <p>
         * Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified, the
         * tags are included in the response. If this field is omitted, tags are not included in the response.
         * </p>
         * 
         * @param include
         *        Specifies whether to see the resource tags for the task definition. If <code>TAGS</code> is specified,
         *        the tags are included in the response. If this field is omitted, tags are not included in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(TaskDefinitionField... include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String taskDefinition;

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskDefinitionRequest model) {
            super(model);
            taskDefinition(model.taskDefinition);
            includeWithStrings(model.include);
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        @Transient
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = TaskDefinitionFieldListCopier.copy(include);
        }

        @Override
        @Transient
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = TaskDefinitionFieldListCopier.copy(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        @Transient
        public final Builder include(Collection<TaskDefinitionField> include) {
            this.include = TaskDefinitionFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder include(TaskDefinitionField... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTaskDefinitionRequest build() {
            return new DescribeTaskDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
