/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TaskStopCode {
    TASK_FAILED_TO_START("TaskFailedToStart"),
    ESSENTIAL_CONTAINER_EXITED("EssentialContainerExited"),
    USER_INITIATED("UserInitiated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TaskStopCode> VALUE_MAP;
    private final String value;

    private TaskStopCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskStopCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskStopCode> knownValues() {
        EnumSet<TaskStopCode> knownValues = EnumSet.allOf(TaskStopCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TaskStopCode.class, TaskStopCode::toString);
    }
}

