/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the health status of the container instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerInstanceHealthStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerInstanceHealthStatus.Builder, ContainerInstanceHealthStatus> {
    private static final SdkField<String> OVERALL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overallStatus").getter(getter(ContainerInstanceHealthStatus::overallStatusAsString))
            .setter(setter(Builder::overallStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overallStatus").build()).build();

    private static final SdkField<List<InstanceHealthCheckResult>> DETAILS_FIELD = SdkField
            .<List<InstanceHealthCheckResult>> builder(MarshallingType.LIST)
            .memberName("details")
            .getter(getter(ContainerInstanceHealthStatus::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceHealthCheckResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceHealthCheckResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERALL_STATUS_FIELD,
            DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String overallStatus;

    private final List<InstanceHealthCheckResult> details;

    private ContainerInstanceHealthStatus(BuilderImpl builder) {
        this.overallStatus = builder.overallStatus;
        this.details = builder.details;
    }

    /**
     * <p>
     * The overall health status of the container instance. This is an aggregate status of all container instance health
     * checks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overallStatus}
     * will return {@link InstanceHealthCheckState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #overallStatusAsString}.
     * </p>
     * 
     * @return The overall health status of the container instance. This is an aggregate status of all container
     *         instance health checks.
     * @see InstanceHealthCheckState
     */
    public final InstanceHealthCheckState overallStatus() {
        return InstanceHealthCheckState.fromValue(overallStatus);
    }

    /**
     * <p>
     * The overall health status of the container instance. This is an aggregate status of all container instance health
     * checks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #overallStatus}
     * will return {@link InstanceHealthCheckState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #overallStatusAsString}.
     * </p>
     * 
     * @return The overall health status of the container instance. This is an aggregate status of all container
     *         instance health checks.
     * @see InstanceHealthCheckState
     */
    public final String overallStatusAsString() {
        return overallStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the details of the container instance health status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return An array of objects representing the details of the container instance health status.
     */
    public final List<InstanceHealthCheckResult> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(overallStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstanceHealthStatus)) {
            return false;
        }
        ContainerInstanceHealthStatus other = (ContainerInstanceHealthStatus) obj;
        return Objects.equals(overallStatusAsString(), other.overallStatusAsString()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerInstanceHealthStatus").add("OverallStatus", overallStatusAsString())
                .add("Details", hasDetails() ? details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overallStatus":
            return Optional.ofNullable(clazz.cast(overallStatusAsString()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerInstanceHealthStatus, T> g) {
        return obj -> g.apply((ContainerInstanceHealthStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerInstanceHealthStatus> {
        /**
         * <p>
         * The overall health status of the container instance. This is an aggregate status of all container instance
         * health checks.
         * </p>
         * 
         * @param overallStatus
         *        The overall health status of the container instance. This is an aggregate status of all container
         *        instance health checks.
         * @see InstanceHealthCheckState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckState
         */
        Builder overallStatus(String overallStatus);

        /**
         * <p>
         * The overall health status of the container instance. This is an aggregate status of all container instance
         * health checks.
         * </p>
         * 
         * @param overallStatus
         *        The overall health status of the container instance. This is an aggregate status of all container
         *        instance health checks.
         * @see InstanceHealthCheckState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceHealthCheckState
         */
        Builder overallStatus(InstanceHealthCheckState overallStatus);

        /**
         * <p>
         * An array of objects representing the details of the container instance health status.
         * </p>
         * 
         * @param details
         *        An array of objects representing the details of the container instance health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Collection<InstanceHealthCheckResult> details);

        /**
         * <p>
         * An array of objects representing the details of the container instance health status.
         * </p>
         * 
         * @param details
         *        An array of objects representing the details of the container instance health status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(InstanceHealthCheckResult... details);

        /**
         * <p>
         * An array of objects representing the details of the container instance health status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceHealthCheckResult>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceHealthCheckResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceHealthCheckResult>.Builder#build()} is called
         * immediately and its result is passed to {@link #details(List<InstanceHealthCheckResult>)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link List<InstanceHealthCheckResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(List<InstanceHealthCheckResult>)
         */
        Builder details(Consumer<InstanceHealthCheckResult.Builder>... details);
    }

    static final class BuilderImpl implements Builder {
        private String overallStatus;

        private List<InstanceHealthCheckResult> details = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerInstanceHealthStatus model) {
            overallStatus(model.overallStatus);
            details(model.details);
        }

        public final String getOverallStatus() {
            return overallStatus;
        }

        public final void setOverallStatus(String overallStatus) {
            this.overallStatus = overallStatus;
        }

        @Override
        @Transient
        public final Builder overallStatus(String overallStatus) {
            this.overallStatus = overallStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder overallStatus(InstanceHealthCheckState overallStatus) {
            this.overallStatus(overallStatus == null ? null : overallStatus.toString());
            return this;
        }

        public final List<InstanceHealthCheckResult.Builder> getDetails() {
            List<InstanceHealthCheckResult.Builder> result = InstanceHealthCheckResultListCopier.copyToBuilder(this.details);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetails(Collection<InstanceHealthCheckResult.BuilderImpl> details) {
            this.details = InstanceHealthCheckResultListCopier.copyFromBuilder(details);
        }

        @Override
        @Transient
        public final Builder details(Collection<InstanceHealthCheckResult> details) {
            this.details = InstanceHealthCheckResultListCopier.copy(details);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder details(InstanceHealthCheckResult... details) {
            details(Arrays.asList(details));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder details(Consumer<InstanceHealthCheckResult.Builder>... details) {
            details(Stream.of(details).map(c -> InstanceHealthCheckResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContainerInstanceHealthStatus build() {
            return new ContainerInstanceHealthStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
