/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityProvidersRequest extends EcsRequest implements
        ToCopyableBuilder<DescribeCapacityProvidersRequest.Builder, DescribeCapacityProvidersRequest> {
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capacityProviders")
            .getter(getter(DescribeCapacityProvidersRequest::capacityProviders))
            .setter(setter(Builder::capacityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(DescribeCapacityProvidersRequest::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeCapacityProvidersRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeCapacityProvidersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD,
            INCLUDE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> capacityProviders;

    private final List<String> include;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeCapacityProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviders = builder.capacityProviders;
        this.include = builder.include;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityProviders() {
        return capacityProviders != null && !(capacityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code>
     * capacity providers can be described in an action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviders} method.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
     *         <code>100</code> capacity providers can be described in an action.
     */
    public final List<String> capacityProviders() {
        return capacityProviders;
    }

    /**
     * <p>
     * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether or not you want to see the resource tags for the capacity provider. If
     *         <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
     *         aren't included in the response.
     */
    public final List<CapacityProviderField> include() {
        return CapacityProviderFieldListCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
     * specified, the tags are included in the response. If this field is omitted, tags aren't included in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return Specifies whether or not you want to see the resource tags for the capacity provider. If
     *         <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
     *         aren't included in the response.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    /**
     * <p>
     * The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in paginated
     * output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns <code>maxResults</code>
     * results in a single page along with a <code>nextToken</code> response element. The remaining results of the
     * initial request can be seen by sending another <code>DescribeCapacityProviders</code> request with the returned
     * <code>nextToken</code> value. This value can be between 1 and 10. If this parameter is not used, then
     * <code>DescribeCapacityProviders</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in
     *         paginated output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns
     *         <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
     *         The remaining results of the initial request can be seen by sending another
     *         <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This value
     *         can be between 1 and 10. If this parameter is not used, then <code>DescribeCapacityProviders</code>
     *         returns up to 10 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>DescribeCapacityProviders</code>
     * request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     * continues from the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated
     *         <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was used and the results
     *         exceeded the value of that parameter. Pagination continues from the end of the previous results that
     *         returned the <code>nextToken</code> value.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviders() ? capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityProvidersRequest)) {
            return false;
        }
        DescribeCapacityProvidersRequest other = (DescribeCapacityProvidersRequest) obj;
        return hasCapacityProviders() == other.hasCapacityProviders()
                && Objects.equals(capacityProviders(), other.capacityProviders()) && hasInclude() == other.hasInclude()
                && Objects.equals(includeAsStrings(), other.includeAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityProvidersRequest")
                .add("CapacityProviders", hasCapacityProviders() ? capacityProviders() : null)
                .add("Include", hasInclude() ? includeAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityProviders":
            return Optional.ofNullable(clazz.cast(capacityProviders()));
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityProvidersRequest, T> g) {
        return obj -> g.apply((DescribeCapacityProvidersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCapacityProvidersRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code>
         * capacity providers can be described in an action.
         * </p>
         * 
         * @param capacityProviders
         *        The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
         *        <code>100</code> capacity providers can be described in an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(Collection<String> capacityProviders);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to <code>100</code>
         * capacity providers can be described in an action.
         * </p>
         * 
         * @param capacityProviders
         *        The short name or full Amazon Resource Name (ARN) of one or more capacity providers. Up to
         *        <code>100</code> capacity providers can be described in an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(String... capacityProviders);

        /**
         * <p>
         * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags aren't included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether or not you want to see the resource tags for the capacity provider. If
         *        <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
         *        aren't included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags aren't included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether or not you want to see the resource tags for the capacity provider. If
         *        <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
         *        aren't included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags aren't included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether or not you want to see the resource tags for the capacity provider. If
         *        <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
         *        aren't included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<CapacityProviderField> include);

        /**
         * <p>
         * Specifies whether or not you want to see the resource tags for the capacity provider. If <code>TAGS</code> is
         * specified, the tags are included in the response. If this field is omitted, tags aren't included in the
         * response.
         * </p>
         * 
         * @param include
         *        Specifies whether or not you want to see the resource tags for the capacity provider. If
         *        <code>TAGS</code> is specified, the tags are included in the response. If this field is omitted, tags
         *        aren't included in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(CapacityProviderField... include);

        /**
         * <p>
         * The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in paginated
         * output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns
         * <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The
         * remaining results of the initial request can be seen by sending another
         * <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This value can
         * be between 1 and 10. If this parameter is not used, then <code>DescribeCapacityProviders</code> returns up to
         * 10 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of account setting results returned by <code>DescribeCapacityProviders</code> in
         *        paginated output. When this parameter is used, <code>DescribeCapacityProviders</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>DescribeCapacityProviders</code> request with the returned <code>nextToken</code> value. This
         *        value can be between 1 and 10. If this parameter is not used, then
         *        <code>DescribeCapacityProviders</code> returns up to 10 results and a <code>nextToken</code> value if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>DescribeCapacityProviders</code>
         * request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated
         *        <code>DescribeCapacityProviders</code> request where <code>maxResults</code> was used and the results
         *        exceeded the value of that parameter. Pagination continues from the end of the previous results that
         *        returned the <code>nextToken</code> value.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityProvidersRequest model) {
            super(model);
            capacityProviders(model.capacityProviders);
            includeWithStrings(model.include);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getCapacityProviders() {
            if (capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        @Override
        @Transient
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder capacityProviders(String... capacityProviders) {
            capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = CapacityProviderFieldListCopier.copy(include);
        }

        @Override
        @Transient
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = CapacityProviderFieldListCopier.copy(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        @Transient
        public final Builder include(Collection<CapacityProviderField> include) {
            this.include = CapacityProviderFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder include(CapacityProviderField... include) {
            include(Arrays.asList(include));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityProvidersRequest build() {
            return new DescribeCapacityProvidersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
