/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorization configuration details for the Amazon EFS file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EFSAuthorizationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EFSAuthorizationConfig.Builder, EFSAuthorizationConfig> {
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPointId").getter(getter(EFSAuthorizationConfig::accessPointId))
            .setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointId").build()).build();

    private static final SdkField<String> IAM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("iam")
            .getter(getter(EFSAuthorizationConfig::iamAsString)).setter(setter(Builder::iam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ID_FIELD,
            IAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessPointId;

    private final String iam;

    private EFSAuthorizationConfig(BuilderImpl builder) {
        this.accessPointId = builder.accessPointId;
        this.iam = builder.iam;
    }

    /**
     * <p>
     * The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the
     * <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which will enforce the path
     * set on the EFS access point. If an access point is used, transit encryption must be enabled in the
     * <code>EFSVolumeConfiguration</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS Access Points</a>
     * in the <i>Amazon Elastic File System User Guide</i>.
     * </p>
     * 
     * @return The Amazon EFS access point ID to use. If an access point is specified, the root directory value
     *         specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code>
     *         which will enforce the path set on the EFS access point. If an access point is used, transit encryption
     *         must be enabled in the <code>EFSVolumeConfiguration</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS Access
     *         Points</a> in the <i>Amazon Elastic File System User Guide</i>.
     */
    public final String accessPointId() {
        return accessPointId;
    }

    /**
     * <p>
     * Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS
     * file system. If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>. If this
     * parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using
     * Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iam} will return
     * {@link EFSAuthorizationConfigIAM#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iamAsString}.
     * </p>
     * 
     * @return Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the
     *         Amazon EFS file system. If enabled, transit encryption must be enabled in the
     *         <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value of
     *         <code>DISABLED</code> is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
     *         >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see EFSAuthorizationConfigIAM
     */
    public final EFSAuthorizationConfigIAM iam() {
        return EFSAuthorizationConfigIAM.fromValue(iam);
    }

    /**
     * <p>
     * Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS
     * file system. If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>. If this
     * parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints">Using
     * Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #iam} will return
     * {@link EFSAuthorizationConfigIAM#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #iamAsString}.
     * </p>
     * 
     * @return Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the
     *         Amazon EFS file system. If enabled, transit encryption must be enabled in the
     *         <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value of
     *         <code>DISABLED</code> is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
     *         >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see EFSAuthorizationConfigIAM
     */
    public final String iamAsString() {
        return iam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(iamAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSAuthorizationConfig)) {
            return false;
        }
        EFSAuthorizationConfig other = (EFSAuthorizationConfig) obj;
        return Objects.equals(accessPointId(), other.accessPointId()) && Objects.equals(iamAsString(), other.iamAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EFSAuthorizationConfig").add("AccessPointId", accessPointId()).add("Iam", iamAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPointId":
            return Optional.ofNullable(clazz.cast(accessPointId()));
        case "iam":
            return Optional.ofNullable(clazz.cast(iamAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EFSAuthorizationConfig, T> g) {
        return obj -> g.apply((EFSAuthorizationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EFSAuthorizationConfig> {
        /**
         * <p>
         * The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in
         * the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which will enforce
         * the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the
         * <code>EFSVolumeConfiguration</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS Access
         * Points</a> in the <i>Amazon Elastic File System User Guide</i>.
         * </p>
         * 
         * @param accessPointId
         *        The Amazon EFS access point ID to use. If an access point is specified, the root directory value
         *        specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code>
         *        which will enforce the path set on the EFS access point. If an access point is used, transit
         *        encryption must be enabled in the <code>EFSVolumeConfiguration</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS Access
         *        Points</a> in the <i>Amazon Elastic File System User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        /**
         * <p>
         * Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon
         * EFS file system. If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>.
         * If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see
         * <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
         * >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param iam
         *        Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the
         *        Amazon EFS file system. If enabled, transit encryption must be enabled in the
         *        <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value of
         *        <code>DISABLED</code> is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
         *        >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see EFSAuthorizationConfigIAM
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EFSAuthorizationConfigIAM
         */
        Builder iam(String iam);

        /**
         * <p>
         * Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon
         * EFS file system. If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>.
         * If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see
         * <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
         * >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param iam
         *        Determines whether to use the Amazon ECS task IAM role defined in a task definition when mounting the
         *        Amazon EFS file system. If enabled, transit encryption must be enabled in the
         *        <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value of
         *        <code>DISABLED</code> is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints"
         *        >Using Amazon EFS Access Points</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see EFSAuthorizationConfigIAM
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EFSAuthorizationConfigIAM
         */
        Builder iam(EFSAuthorizationConfigIAM iam);
    }

    static final class BuilderImpl implements Builder {
        private String accessPointId;

        private String iam;

        private BuilderImpl() {
        }

        private BuilderImpl(EFSAuthorizationConfig model) {
            accessPointId(model.accessPointId);
            iam(model.iam);
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        @Transient
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getIam() {
            return iam;
        }

        public final void setIam(String iam) {
            this.iam = iam;
        }

        @Override
        @Transient
        public final Builder iam(String iam) {
            this.iam = iam;
            return this;
        }

        @Override
        @Transient
        public final Builder iam(EFSAuthorizationConfigIAM iam) {
            this.iam(iam == null ? null : iam.toString());
            return this;
        }

        @Override
        public EFSAuthorizationConfig build() {
            return new EFSAuthorizationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
