/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteCommandRequest extends EcsRequest implements
        ToCopyableBuilder<ExecuteCommandRequest.Builder, ExecuteCommandRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(ExecuteCommandRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("container").getter(getter(ExecuteCommandRequest::container)).setter(setter(Builder::container))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(ExecuteCommandRequest::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("interactive").getter(getter(ExecuteCommandRequest::interactive)).setter(setter(Builder::interactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactive").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("task")
            .getter(getter(ExecuteCommandRequest::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            CONTAINER_FIELD, COMMAND_FIELD, INTERACTIVE_FIELD, TASK_FIELD));

    private final String cluster;

    private final String container;

    private final String command;

    private final Boolean interactive;

    private final String task;

    private ExecuteCommandRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.container = builder.container;
        this.command = builder.command;
        this.interactive = builder.interactive;
        this.task = builder.task;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a
     * cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify
     *         a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of the container to execute the command on. A container name only needs to be specified for tasks
     * containing multiple containers.
     * </p>
     * 
     * @return The name of the container to execute the command on. A container name only needs to be specified for
     *         tasks containing multiple containers.
     */
    public final String container() {
        return container;
    }

    /**
     * <p>
     * The command to run on the container.
     * </p>
     * 
     * @return The command to run on the container.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * Use this flag to run your command in interactive mode.
     * </p>
     * 
     * @return Use this flag to run your command in interactive mode.
     */
    public final Boolean interactive() {
        return interactive;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or ID of the task the container is part of.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or ID of the task the container is part of.
     */
    public final String task() {
        return task;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(interactive());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteCommandRequest)) {
            return false;
        }
        ExecuteCommandRequest other = (ExecuteCommandRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(container(), other.container())
                && Objects.equals(command(), other.command()) && Objects.equals(interactive(), other.interactive())
                && Objects.equals(task(), other.task());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteCommandRequest").add("Cluster", cluster()).add("Container", container())
                .add("Command", command()).add("Interactive", interactive()).add("Task", task()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "container":
            return Optional.ofNullable(clazz.cast(container()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "interactive":
            return Optional.ofNullable(clazz.cast(interactive()));
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteCommandRequest, T> g) {
        return obj -> g.apply((ExecuteCommandRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteCommandRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not specify a
         * cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The Amazon Resource Name (ARN) or short name of the cluster the task is running in. If you do not
         *        specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of the container to execute the command on. A container name only needs to be specified for tasks
         * containing multiple containers.
         * </p>
         * 
         * @param container
         *        The name of the container to execute the command on. A container name only needs to be specified for
         *        tasks containing multiple containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(String container);

        /**
         * <p>
         * The command to run on the container.
         * </p>
         * 
         * @param command
         *        The command to run on the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * Use this flag to run your command in interactive mode.
         * </p>
         * 
         * @param interactive
         *        Use this flag to run your command in interactive mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactive(Boolean interactive);

        /**
         * <p>
         * The Amazon Resource Name (ARN) or ID of the task the container is part of.
         * </p>
         * 
         * @param task
         *        The Amazon Resource Name (ARN) or ID of the task the container is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String container;

        private String command;

        private Boolean interactive;

        private String task;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteCommandRequest model) {
            super(model);
            cluster(model.cluster);
            container(model.container);
            command(model.command);
            interactive(model.interactive);
            task(model.task);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        @Transient
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getContainer() {
            return container;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        @Override
        @Transient
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        @Transient
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Boolean getInteractive() {
            return interactive;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        @Override
        @Transient
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        @Transient
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteCommandRequest build() {
            return new ExecuteCommandRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
