/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the protection status details for a task. You can set the protection status with the
 * <a>UpdateTaskProtection</a> API and get the status of tasks with the <a>GetTaskProtection</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedTask implements SdkPojo, Serializable, ToCopyableBuilder<ProtectedTask.Builder, ProtectedTask> {
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(ProtectedTask::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<Boolean> PROTECTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("protectionEnabled").getter(getter(ProtectedTask::protectionEnabled))
            .setter(setter(Builder::protectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectionEnabled").build()).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationDate").getter(getter(ProtectedTask::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARN_FIELD,
            PROTECTION_ENABLED_FIELD, EXPIRATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String taskArn;

    private final Boolean protectionEnabled;

    private final Instant expirationDate;

    private ProtectedTask(BuilderImpl builder) {
        this.taskArn = builder.taskArn;
        this.protectionEnabled = builder.protectionEnabled;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The task ARN.
     * </p>
     * 
     * @return The task ARN.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The protection status of the task. If scale-in protection is enabled for a task, the value is <code>true</code>.
     * Otherwise, it is <code>false</code>.
     * </p>
     * 
     * @return The protection status of the task. If scale-in protection is enabled for a task, the value is
     *         <code>true</code>. Otherwise, it is <code>false</code>.
     */
    public final Boolean protectionEnabled() {
        return protectionEnabled;
    }

    /**
     * <p>
     * The epoch time when protection for the task will expire.
     * </p>
     * 
     * @return The epoch time when protection for the task will expire.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedTask)) {
            return false;
        }
        ProtectedTask other = (ProtectedTask) obj;
        return Objects.equals(taskArn(), other.taskArn()) && Objects.equals(protectionEnabled(), other.protectionEnabled())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedTask").add("TaskArn", taskArn()).add("ProtectionEnabled", protectionEnabled())
                .add("ExpirationDate", expirationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "protectionEnabled":
            return Optional.ofNullable(clazz.cast(protectionEnabled()));
        case "expirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedTask, T> g) {
        return obj -> g.apply((ProtectedTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedTask> {
        /**
         * <p>
         * The task ARN.
         * </p>
         * 
         * @param taskArn
         *        The task ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The protection status of the task. If scale-in protection is enabled for a task, the value is
         * <code>true</code>. Otherwise, it is <code>false</code>.
         * </p>
         * 
         * @param protectionEnabled
         *        The protection status of the task. If scale-in protection is enabled for a task, the value is
         *        <code>true</code>. Otherwise, it is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionEnabled(Boolean protectionEnabled);

        /**
         * <p>
         * The epoch time when protection for the task will expire.
         * </p>
         * 
         * @param expirationDate
         *        The epoch time when protection for the task will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);
    }

    static final class BuilderImpl implements Builder {
        private String taskArn;

        private Boolean protectionEnabled;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedTask model) {
            taskArn(model.taskArn);
            protectionEnabled(model.protectionEnabled);
            expirationDate(model.expirationDate);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final Boolean getProtectionEnabled() {
            return protectionEnabled;
        }

        public final void setProtectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
        }

        @Override
        public final Builder protectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public ProtectedTask build() {
            return new ProtectedTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
