/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ServiceConnectClientAlias;
import software.amazon.awssdk.services.ecs.model.ServiceConnectClientAliasListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConnectService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConnectService> {
    private static final SdkField<String> PORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portName").getter(ServiceConnectService.getter(ServiceConnectService::portName)).setter(ServiceConnectService.setter(Builder::portName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()}).build();
    private static final SdkField<String> DISCOVERY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("discoveryName").getter(ServiceConnectService.getter(ServiceConnectService::discoveryName)).setter(ServiceConnectService.setter(Builder::discoveryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryName").build()}).build();
    private static final SdkField<List<ServiceConnectClientAlias>> CLIENT_ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientAliases").getter(ServiceConnectService.getter(ServiceConnectService::clientAliases)).setter(ServiceConnectService.setter(Builder::clientAliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceConnectClientAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> INGRESS_PORT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ingressPortOverride").getter(ServiceConnectService.getter(ServiceConnectService::ingressPortOverride)).setter(ServiceConnectService.setter(Builder::ingressPortOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingressPortOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_NAME_FIELD, DISCOVERY_NAME_FIELD, CLIENT_ALIASES_FIELD, INGRESS_PORT_OVERRIDE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String portName;
    private final String discoveryName;
    private final List<ServiceConnectClientAlias> clientAliases;
    private final Integer ingressPortOverride;

    private ServiceConnectService(BuilderImpl builder) {
        this.portName = builder.portName;
        this.discoveryName = builder.discoveryName;
        this.clientAliases = builder.clientAliases;
        this.ingressPortOverride = builder.ingressPortOverride;
    }

    public final String portName() {
        return this.portName;
    }

    public final String discoveryName() {
        return this.discoveryName;
    }

    public final boolean hasClientAliases() {
        return this.clientAliases != null && !(this.clientAliases instanceof SdkAutoConstructList);
    }

    public final List<ServiceConnectClientAlias> clientAliases() {
        return this.clientAliases;
    }

    public final Integer ingressPortOverride() {
        return this.ingressPortOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.portName());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientAliases() ? this.clientAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressPortOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectService)) {
            return false;
        }
        ServiceConnectService other = (ServiceConnectService)obj;
        return Objects.equals(this.portName(), other.portName()) && Objects.equals(this.discoveryName(), other.discoveryName()) && this.hasClientAliases() == other.hasClientAliases() && Objects.equals(this.clientAliases(), other.clientAliases()) && Objects.equals(this.ingressPortOverride(), other.ingressPortOverride());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConnectService").add("PortName", (Object)this.portName()).add("DiscoveryName", (Object)this.discoveryName()).add("ClientAliases", this.hasClientAliases() ? this.clientAliases() : null).add("IngressPortOverride", (Object)this.ingressPortOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portName": {
                return Optional.ofNullable(clazz.cast(this.portName()));
            }
            case "discoveryName": {
                return Optional.ofNullable(clazz.cast(this.discoveryName()));
            }
            case "clientAliases": {
                return Optional.ofNullable(clazz.cast(this.clientAliases()));
            }
            case "ingressPortOverride": {
                return Optional.ofNullable(clazz.cast(this.ingressPortOverride()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectService, T> g) {
        return obj -> g.apply((ServiceConnectService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String portName;
        private String discoveryName;
        private List<ServiceConnectClientAlias> clientAliases = DefaultSdkAutoConstructList.getInstance();
        private Integer ingressPortOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectService model) {
            this.portName(model.portName);
            this.discoveryName(model.discoveryName);
            this.clientAliases(model.clientAliases);
            this.ingressPortOverride(model.ingressPortOverride);
        }

        public final String getPortName() {
            return this.portName;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public final String getDiscoveryName() {
            return this.discoveryName;
        }

        public final void setDiscoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
        }

        @Override
        public final Builder discoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
            return this;
        }

        public final List<ServiceConnectClientAlias.Builder> getClientAliases() {
            List<ServiceConnectClientAlias.Builder> result = ServiceConnectClientAliasListCopier.copyToBuilder(this.clientAliases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientAliases(Collection<ServiceConnectClientAlias.BuilderImpl> clientAliases) {
            this.clientAliases = ServiceConnectClientAliasListCopier.copyFromBuilder(clientAliases);
        }

        @Override
        public final Builder clientAliases(Collection<ServiceConnectClientAlias> clientAliases) {
            this.clientAliases = ServiceConnectClientAliasListCopier.copy(clientAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAliases(ServiceConnectClientAlias ... clientAliases) {
            this.clientAliases(Arrays.asList(clientAliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAliases(Consumer<ServiceConnectClientAlias.Builder> ... clientAliases) {
            this.clientAliases(Stream.of(clientAliases).map(c -> (ServiceConnectClientAlias)((ServiceConnectClientAlias.Builder)ServiceConnectClientAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getIngressPortOverride() {
            return this.ingressPortOverride;
        }

        public final void setIngressPortOverride(Integer ingressPortOverride) {
            this.ingressPortOverride = ingressPortOverride;
        }

        @Override
        public final Builder ingressPortOverride(Integer ingressPortOverride) {
            this.ingressPortOverride = ingressPortOverride;
            return this;
        }

        public ServiceConnectService build() {
            return new ServiceConnectService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConnectService> {
        public Builder portName(String var1);

        public Builder discoveryName(String var1);

        public Builder clientAliases(Collection<ServiceConnectClientAlias> var1);

        public Builder clientAliases(ServiceConnectClientAlias ... var1);

        public Builder clientAliases(Consumer<ServiceConnectClientAlias.Builder> ... var1);

        public Builder ingressPortOverride(Integer var1);
    }
}

