/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecs.DefaultEcsAsyncClient;
import software.amazon.awssdk.services.ecs.DefaultEcsBaseClientBuilder;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.EcsAsyncClientBuilder;
import software.amazon.awssdk.services.ecs.EcsServiceClientConfiguration;
import software.amazon.awssdk.services.ecs.endpoints.EcsEndpointProvider;

@SdkInternalApi
final class DefaultEcsAsyncClientBuilder
extends DefaultEcsBaseClientBuilder<EcsAsyncClientBuilder, EcsAsyncClient>
implements EcsAsyncClientBuilder {
    DefaultEcsAsyncClientBuilder() {
    }

    @Override
    public DefaultEcsAsyncClientBuilder endpointProvider(EcsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EcsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEcsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EcsServiceClientConfiguration serviceClientConfiguration = EcsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultEcsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

