/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a task in a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Task implements SdkPojo, Serializable, ToCopyableBuilder<Task.Builder, Task> {
    private static final SdkField<List<Attachment>> ATTACHMENTS_FIELD = SdkField
            .<List<Attachment>> builder(MarshallingType.LIST)
            .memberName("attachments")
            .getter(getter(Task::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(Task::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(Task::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("capacityProviderName").getter(getter(Task::capacityProviderName))
            .setter(setter(Builder::capacityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderName").build())
            .build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(Task::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CONNECTIVITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectivity").getter(getter(Task::connectivityAsString)).setter(setter(Builder::connectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()).build();

    private static final SdkField<Instant> CONNECTIVITY_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("connectivityAt").getter(getter(Task::connectivityAt)).setter(setter(Builder::connectivityAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivityAt").build()).build();

    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstanceArn").getter(getter(Task::containerInstanceArn))
            .setter(setter(Builder::containerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build())
            .build();

    private static final SdkField<List<Container>> CONTAINERS_FIELD = SdkField
            .<List<Container>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(Task::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(Task::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Task::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESIRED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredStatus").getter(getter(Task::desiredStatus)).setter(setter(Builder::desiredStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredStatus").build()).build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExecuteCommand").getter(getter(Task::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build())
            .build();

    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionStoppedAt").getter(getter(Task::executionStoppedAt))
            .setter(setter(Builder::executionStoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build())
            .build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("group")
            .getter(getter(Task::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthStatus").getter(getter(Task::healthStatusAsString)).setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final SdkField<List<InferenceAccelerator>> INFERENCE_ACCELERATORS_FIELD = SdkField
            .<List<InferenceAccelerator>> builder(MarshallingType.LIST)
            .memberName("inferenceAccelerators")
            .getter(getter(Task::inferenceAccelerators))
            .setter(setter(Builder::inferenceAccelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAccelerators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceAccelerator> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceAccelerator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastStatus").getter(getter(Task::lastStatus)).setter(setter(Builder::lastStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchType").getter(getter(Task::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(Task::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.<TaskOverride> builder(MarshallingType.SDK_POJO)
            .memberName("overrides").getter(getter(Task::overrides)).setter(setter(Builder::overrides))
            .constructor(TaskOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(Task::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> PLATFORM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformFamily").getter(getter(Task::platformFamily)).setter(setter(Builder::platformFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFamily").build()).build();

    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pullStartedAt").getter(getter(Task::pullStartedAt)).setter(setter(Builder::pullStartedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()).build();

    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("pullStoppedAt").getter(getter(Task::pullStoppedAt)).setter(setter(Builder::pullStoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt").getter(getter(Task::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<String> STARTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startedBy").getter(getter(Task::startedBy)).setter(setter(Builder::startedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()).build();

    private static final SdkField<String> STOP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stopCode").getter(getter(Task::stopCodeAsString)).setter(setter(Builder::stopCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopCode").build()).build();

    private static final SdkField<Instant> STOPPED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stoppedAt").getter(getter(Task::stoppedAt)).setter(setter(Builder::stoppedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()).build();

    private static final SdkField<String> STOPPED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stoppedReason").getter(getter(Task::stoppedReason)).setter(setter(Builder::stoppedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedReason").build()).build();

    private static final SdkField<Instant> STOPPING_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stoppingAt").getter(getter(Task::stoppingAt)).setter(setter(Builder::stoppingAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingAt").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Task::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(Task::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinitionArn").getter(getter(Task::taskDefinitionArn)).setter(setter(Builder::taskDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("version")
            .getter(getter(Task::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField
            .<EphemeralStorage> builder(MarshallingType.SDK_POJO).memberName("ephemeralStorage")
            .getter(getter(Task::ephemeralStorage)).setter(setter(Builder::ephemeralStorage))
            .constructor(EphemeralStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD,
            ATTRIBUTES_FIELD, AVAILABILITY_ZONE_FIELD, CAPACITY_PROVIDER_NAME_FIELD, CLUSTER_ARN_FIELD, CONNECTIVITY_FIELD,
            CONNECTIVITY_AT_FIELD, CONTAINER_INSTANCE_ARN_FIELD, CONTAINERS_FIELD, CPU_FIELD, CREATED_AT_FIELD,
            DESIRED_STATUS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, EXECUTION_STOPPED_AT_FIELD, GROUP_FIELD, HEALTH_STATUS_FIELD,
            INFERENCE_ACCELERATORS_FIELD, LAST_STATUS_FIELD, LAUNCH_TYPE_FIELD, MEMORY_FIELD, OVERRIDES_FIELD,
            PLATFORM_VERSION_FIELD, PLATFORM_FAMILY_FIELD, PULL_STARTED_AT_FIELD, PULL_STOPPED_AT_FIELD, STARTED_AT_FIELD,
            STARTED_BY_FIELD, STOP_CODE_FIELD, STOPPED_AT_FIELD, STOPPED_REASON_FIELD, STOPPING_AT_FIELD, TAGS_FIELD,
            TASK_ARN_FIELD, TASK_DEFINITION_ARN_FIELD, VERSION_FIELD, EPHEMERAL_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Attachment> attachments;

    private final List<Attribute> attributes;

    private final String availabilityZone;

    private final String capacityProviderName;

    private final String clusterArn;

    private final String connectivity;

    private final Instant connectivityAt;

    private final String containerInstanceArn;

    private final List<Container> containers;

    private final String cpu;

    private final Instant createdAt;

    private final String desiredStatus;

    private final Boolean enableExecuteCommand;

    private final Instant executionStoppedAt;

    private final String group;

    private final String healthStatus;

    private final List<InferenceAccelerator> inferenceAccelerators;

    private final String lastStatus;

    private final String launchType;

    private final String memory;

    private final TaskOverride overrides;

    private final String platformVersion;

    private final String platformFamily;

    private final Instant pullStartedAt;

    private final Instant pullStoppedAt;

    private final Instant startedAt;

    private final String startedBy;

    private final String stopCode;

    private final Instant stoppedAt;

    private final String stoppedReason;

    private final Instant stoppingAt;

    private final List<Tag> tags;

    private final String taskArn;

    private final String taskDefinitionArn;

    private final Long version;

    private final EphemeralStorage ephemeralStorage;

    private Task(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.attributes = builder.attributes;
        this.availabilityZone = builder.availabilityZone;
        this.capacityProviderName = builder.capacityProviderName;
        this.clusterArn = builder.clusterArn;
        this.connectivity = builder.connectivity;
        this.connectivityAt = builder.connectivityAt;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.containers = builder.containers;
        this.cpu = builder.cpu;
        this.createdAt = builder.createdAt;
        this.desiredStatus = builder.desiredStatus;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.executionStoppedAt = builder.executionStoppedAt;
        this.group = builder.group;
        this.healthStatus = builder.healthStatus;
        this.inferenceAccelerators = builder.inferenceAccelerators;
        this.lastStatus = builder.lastStatus;
        this.launchType = builder.launchType;
        this.memory = builder.memory;
        this.overrides = builder.overrides;
        this.platformVersion = builder.platformVersion;
        this.platformFamily = builder.platformFamily;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.startedAt = builder.startedAt;
        this.startedBy = builder.startedBy;
        this.stopCode = builder.stopCode;
        this.stoppedAt = builder.stoppedAt;
        this.stoppedReason = builder.stoppedReason;
        this.stoppingAt = builder.stoppingAt;
        this.tags = builder.tags;
        this.taskArn = builder.taskArn;
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.version = builder.version;
        this.ephemeralStorage = builder.ephemeralStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
     *         network mode.
     */
    public final List<Attachment> attachments() {
        return attachments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes of the task
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes of the task
     */
    public final List<Attribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The Availability Zone for the task.
     * </p>
     * 
     * @return The Availability Zone for the task.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The capacity provider that's associated with the task.
     * </p>
     * 
     * @return The capacity provider that's associated with the task.
     */
    public final String capacityProviderName() {
        return capacityProviderName;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the task.
     * </p>
     * 
     * @return The ARN of the cluster that hosts the task.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivity} will
     * return {@link Connectivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectivityAsString}.
     * </p>
     * 
     * @return The connectivity status of a task.
     * @see Connectivity
     */
    public final Connectivity connectivity() {
        return Connectivity.fromValue(connectivity);
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectivity} will
     * return {@link Connectivity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #connectivityAsString}.
     * </p>
     * 
     * @return The connectivity status of a task.
     * @see Connectivity
     */
    public final String connectivityAsString() {
        return connectivity;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     */
    public final Instant connectivityAt() {
        return connectivityAt;
    }

    /**
     * <p>
     * The ARN of the container instances that host the task.
     * </p>
     * 
     * @return The ARN of the container instances that host the task.
     */
    public final String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The containers that's associated with the task.
     */
    public final List<Container> containers() {
        return containers;
    }

    /**
     * <p>
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
     * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for example,
     * <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that indicates the CPU
     * units when the task definition is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (
     * <code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These
     * values determine the range of supported values for the <code>memory</code> parameter:
     * </p>
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of CPU units used by the task as expressed in a task definition. It can be expressed as an
     *         integer using CPU units (for example, <code>1024</code>). It can also be expressed as a string using
     *         vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an
     *         integer that indicates the CPU units when the task definition is registered.</p>
     *         <p>
     *         If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
     *         units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     *         </p>
     *         <p>
     *         If you use the Fargate launch type, this field is required. You must use one of the following values.
     *         These values determine the range of supported values for the <code>memory</code> parameter:
     *         </p>
     *         <p>
     *         The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
     *         6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024
     *         (1 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024
     *         (1 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was created. More specifically, it's for the time when the
     *         task entered the <code>PENDING</code> state.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The desired status of the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @return The desired status of the task. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
     *         Lifecycle</a>.
     */
    public final String desiredStatus() {
        return desiredStatus;
    }

    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     * 
     * @return Determines whether execute command functionality is turned on for this task. If <code>true</code>,
     *         execute command functionality is turned on all the containers in the task.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task execution stopped.
     */
    public final Instant executionStoppedAt() {
        return executionStoppedAt;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @return The name of the task group that's associated with the task.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status for the task. It's determined by the health of the essential containers in the task. If
     *         all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *         as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *         or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *         .</p> <note>
     *         <p>
     *         The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *         container image and not specified in the container definition. For example, this includes those specified
     *         in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *         container definition override any Docker health checks that are found in the container image.
     *         </p>
     * @see HealthStatus
     */
    public final HealthStatus healthStatus() {
        return HealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link HealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The health status for the task. It's determined by the health of the essential containers in the task. If
     *         all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *         as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *         or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *         .</p> <note>
     *         <p>
     *         The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *         container image and not specified in the container definition. For example, this includes those specified
     *         in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *         container definition override any Docker health checks that are found in the container image.
     *         </p>
     * @see HealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceAccelerators property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceAccelerators() {
        return inferenceAccelerators != null && !(inferenceAccelerators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceAccelerators} method.
     * </p>
     * 
     * @return The Elastic Inference accelerator that's associated with the task.
     */
    public final List<InferenceAccelerator> inferenceAccelerators() {
        return inferenceAccelerators;
    }

    /**
     * <p>
     * The last known status for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @return The last known status for the task. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
     *         Lifecycle</a>.
     */
    public final String lastStatus() {
        return lastStatus;
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The infrastructure where your task runs on. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *         types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public final LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The infrastructure where your task runs on. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *         types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public final String launchTypeAsString() {
        return launchType;
    }

    /**
     * <p>
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
     * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
     * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task definition
     * is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value
     * that you choose determines the range of supported values for the <code>cpu</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed
     *         as an integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for
     *         example, <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the
     *         task definition is registered.</p>
     *         <p>
     *         If you use the EC2 launch type, this field is optional.
     *         </p>
     *         <p>
     *         If you use the Fargate launch type, this field is required. You must use one of the following values. The
     *         value that you choose determines the range of supported values for the <code>cpu</code> parameter.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     *         <code>cpu</code> values: 1024 (1 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         2048 (2 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         4096 (4 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * One or more container overrides.
     * </p>
     * 
     * @return One or more container overrides.
     */
    public final TaskOverride overrides() {
        return overrides;
    }

    /**
     * <p>
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate
     * launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version where your task runs on. A platform version is only specified for tasks that use the
     *         Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the
     * Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX.</code>).
     * </p>
     * 
     * @return The operating system that your tasks are running on. A platform family is specified only for tasks that
     *         use the Fargate launch type. </p>
     *         <p>
     *         All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
     *         service (for example, <code>LINUX.</code>).
     */
    public final String platformFamily() {
        return platformFamily;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull began.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull began.
     */
    public final Instant pullStartedAt() {
        return pullStartedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull completed.
     */
    public final Instant pullStoppedAt() {
        return pullStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     *         transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     * 
     * @return The tag specified when a task is started. If an Amazon ECS service started the task, the
     *         <code>startedBy</code> parameter contains the deployment ID of that service.
     */
    public final String startedBy() {
        return startedBy;
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * The following are valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TaskFailedToStart</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EssentialContainerExited</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserInitiated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TerminationNotice</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServiceSchedulerInitiated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SpotInterruption</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopCode} will
     * return {@link TaskStopCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopCodeAsString}.
     * </p>
     * 
     * @return The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *         details.</p>
     *         <p>
     *         The following are valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TaskFailedToStart</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EssentialContainerExited</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UserInitiated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TerminationNotice</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ServiceSchedulerInitiated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SpotInterruption</code>
     *         </p>
     *         </li>
     * @see TaskStopCode
     */
    public final TaskStopCode stopCode() {
        return TaskStopCode.fromValue(stopCode);
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * The following are valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TaskFailedToStart</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EssentialContainerExited</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserInitiated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TerminationNotice</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServiceSchedulerInitiated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SpotInterruption</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopCode} will
     * return {@link TaskStopCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopCodeAsString}.
     * </p>
     * 
     * @return The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *         details.</p>
     *         <p>
     *         The following are valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TaskFailedToStart</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EssentialContainerExited</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UserInitiated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TerminationNotice</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ServiceSchedulerInitiated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SpotInterruption</code>
     *         </p>
     *         </li>
     * @see TaskStopCode
     */
    public final String stopCodeAsString() {
        return stopCode;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
     * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the
     *         task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     */
    public final Instant stoppedAt() {
        return stoppedAt;
    }

    /**
     * <p>
     * The reason that the task was stopped.
     * </p>
     * 
     * @return The reason that the task was stopped.
     */
    public final String stoppedReason() {
        return stoppedReason;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     * transitions from the <code>RUNNING</code> state to <code>STOPPED</code>.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     *         transitions from the <code>RUNNING</code> state to <code>STOPPED</code>.
     */
    public final Instant stoppingAt() {
        return stoppingAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the task to help you categorize and organize the task. Each tag consists
     *         of a key and an optional value. You define both the key and value.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @return The ARN of the task definition that creates the task.
     */
    public final String taskDefinitionArn() {
        return taskDefinitionArn;
    }

    /**
     * <p>
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
     * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
     * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
     * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream is
     * current.
     * </p>
     * 
     * @return The version counter for the task. Every time a task experiences a change that starts a CloudWatch event,
     *         the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events,
     *         you can compare the version of a task reported by the Amazon ECS API actions with the version reported in
     *         CloudWatch Events for the task (inside the <code>detail</code> object) to verify that the version in your
     *         event stream is current.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The ephemeral storage settings for the task.
     * </p>
     * 
     * @return The ephemeral storage settings for the task.
     */
    public final EphemeralStorage ephemeralStorage() {
        return ephemeralStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectivityAt());
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStatus());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(executionStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceAccelerators() ? inferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastStatus());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformFamily());
        hashCode = 31 * hashCode + Objects.hashCode(pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(stopCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedReason());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task) obj;
        return hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(capacityProviderName(), other.capacityProviderName())
                && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(connectivityAsString(), other.connectivityAsString())
                && Objects.equals(connectivityAt(), other.connectivityAt())
                && Objects.equals(containerInstanceArn(), other.containerInstanceArn())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && Objects.equals(cpu(), other.cpu()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(desiredStatus(), other.desiredStatus())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(executionStoppedAt(), other.executionStoppedAt()) && Objects.equals(group(), other.group())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && hasInferenceAccelerators() == other.hasInferenceAccelerators()
                && Objects.equals(inferenceAccelerators(), other.inferenceAccelerators())
                && Objects.equals(lastStatus(), other.lastStatus())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(memory(), other.memory())
                && Objects.equals(overrides(), other.overrides()) && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(platformFamily(), other.platformFamily())
                && Objects.equals(pullStartedAt(), other.pullStartedAt())
                && Objects.equals(pullStoppedAt(), other.pullStoppedAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(startedBy(), other.startedBy()) && Objects.equals(stopCodeAsString(), other.stopCodeAsString())
                && Objects.equals(stoppedAt(), other.stoppedAt()) && Objects.equals(stoppedReason(), other.stoppedReason())
                && Objects.equals(stoppingAt(), other.stoppingAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(taskArn(), other.taskArn())
                && Objects.equals(taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(version(), other.version())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Task").add("Attachments", hasAttachments() ? attachments() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).add("AvailabilityZone", availabilityZone())
                .add("CapacityProviderName", capacityProviderName()).add("ClusterArn", clusterArn())
                .add("Connectivity", connectivityAsString()).add("ConnectivityAt", connectivityAt())
                .add("ContainerInstanceArn", containerInstanceArn()).add("Containers", hasContainers() ? containers() : null)
                .add("Cpu", cpu()).add("CreatedAt", createdAt()).add("DesiredStatus", desiredStatus())
                .add("EnableExecuteCommand", enableExecuteCommand()).add("ExecutionStoppedAt", executionStoppedAt())
                .add("Group", group()).add("HealthStatus", healthStatusAsString())
                .add("InferenceAccelerators", hasInferenceAccelerators() ? inferenceAccelerators() : null)
                .add("LastStatus", lastStatus()).add("LaunchType", launchTypeAsString()).add("Memory", memory())
                .add("Overrides", overrides()).add("PlatformVersion", platformVersion()).add("PlatformFamily", platformFamily())
                .add("PullStartedAt", pullStartedAt()).add("PullStoppedAt", pullStoppedAt()).add("StartedAt", startedAt())
                .add("StartedBy", startedBy()).add("StopCode", stopCodeAsString()).add("StoppedAt", stoppedAt())
                .add("StoppedReason", stoppedReason()).add("StoppingAt", stoppingAt()).add("Tags", hasTags() ? tags() : null)
                .add("TaskArn", taskArn()).add("TaskDefinitionArn", taskDefinitionArn()).add("Version", version())
                .add("EphemeralStorage", ephemeralStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "capacityProviderName":
            return Optional.ofNullable(clazz.cast(capacityProviderName()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "connectivity":
            return Optional.ofNullable(clazz.cast(connectivityAsString()));
        case "connectivityAt":
            return Optional.ofNullable(clazz.cast(connectivityAt()));
        case "containerInstanceArn":
            return Optional.ofNullable(clazz.cast(containerInstanceArn()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "desiredStatus":
            return Optional.ofNullable(clazz.cast(desiredStatus()));
        case "enableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "executionStoppedAt":
            return Optional.ofNullable(clazz.cast(executionStoppedAt()));
        case "group":
            return Optional.ofNullable(clazz.cast(group()));
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "inferenceAccelerators":
            return Optional.ofNullable(clazz.cast(inferenceAccelerators()));
        case "lastStatus":
            return Optional.ofNullable(clazz.cast(lastStatus()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "platformFamily":
            return Optional.ofNullable(clazz.cast(platformFamily()));
        case "pullStartedAt":
            return Optional.ofNullable(clazz.cast(pullStartedAt()));
        case "pullStoppedAt":
            return Optional.ofNullable(clazz.cast(pullStoppedAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "startedBy":
            return Optional.ofNullable(clazz.cast(startedBy()));
        case "stopCode":
            return Optional.ofNullable(clazz.cast(stopCodeAsString()));
        case "stoppedAt":
            return Optional.ofNullable(clazz.cast(stoppedAt()));
        case "stoppedReason":
            return Optional.ofNullable(clazz.cast(stoppedReason()));
        case "stoppingAt":
            return Optional.ofNullable(clazz.cast(stoppingAt()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "taskDefinitionArn":
            return Optional.ofNullable(clazz.cast(taskDefinitionArn()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "ephemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Task> {
        /**
         * <p>
         * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
         * mode.
         * </p>
         * 
         * @param attachments
         *        The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
         *        network mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<Attachment> attachments);

        /**
         * <p>
         * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
         * mode.
         * </p>
         * 
         * @param attachments
         *        The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
         *        network mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Attachment... attachments);

        /**
         * <p>
         * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
         * mode.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Attachment.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Attachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Attachment.Builder#build()} is called immediately and its
         * result is passed to {@link #attachments(List<Attachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.Attachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<Attachment>)
         */
        Builder attachments(Consumer<Attachment.Builder>... attachments);

        /**
         * <p>
         * The attributes of the task
         * </p>
         * 
         * @param attributes
         *        The attributes of the task
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Attribute> attributes);

        /**
         * <p>
         * The attributes of the task
         * </p>
         * 
         * @param attributes
         *        The attributes of the task
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Attribute... attributes);

        /**
         * <p>
         * The attributes of the task
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Attribute.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Attribute.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(List<Attribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<Attribute>)
         */
        Builder attributes(Consumer<Attribute.Builder>... attributes);

        /**
         * <p>
         * The Availability Zone for the task.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The capacity provider that's associated with the task.
         * </p>
         * 
         * @param capacityProviderName
         *        The capacity provider that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderName(String capacityProviderName);

        /**
         * <p>
         * The ARN of the cluster that hosts the task.
         * </p>
         * 
         * @param clusterArn
         *        The ARN of the cluster that hosts the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The connectivity status of a task.
         * </p>
         * 
         * @param connectivity
         *        The connectivity status of a task.
         * @see Connectivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Connectivity
         */
        Builder connectivity(String connectivity);

        /**
         * <p>
         * The connectivity status of a task.
         * </p>
         * 
         * @param connectivity
         *        The connectivity status of a task.
         * @see Connectivity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Connectivity
         */
        Builder connectivity(Connectivity connectivity);

        /**
         * <p>
         * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
         * </p>
         * 
         * @param connectivityAt
         *        The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivityAt(Instant connectivityAt);

        /**
         * <p>
         * The ARN of the container instances that host the task.
         * </p>
         * 
         * @param containerInstanceArn
         *        The ARN of the container instances that host the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<Container> containers);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * 
         * @param containers
         *        The containers that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Container... containers);

        /**
         * <p>
         * The containers that's associated with the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Container.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Container#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Container.Builder#build()} is called immediately and its
         * result is passed to {@link #containers(List<Container>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.Container.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<Container>)
         */
        Builder containers(Consumer<Container.Builder>... containers);

        /**
         * <p>
         * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
         * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for
         * example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that
         * indicates the CPU units when the task definition is registered.
         * </p>
         * <p>
         * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
         * units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
         * </p>
         * <p>
         * If you use the Fargate launch type, this field is required. You must use one of the following values. These
         * values determine the range of supported values for the <code>memory</code> parameter:
         * </p>
         * <p>
         * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
         * 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1
         * GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1
         * GB)
         * </p>
         * </li>
         * <li>
         * <p>
         * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
         * </p>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
         * </p>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param cpu
         *        The number of CPU units used by the task as expressed in a task definition. It can be expressed as an
         *        integer using CPU units (for example, <code>1024</code>). It can also be expressed as a string using
         *        vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an
         *        integer that indicates the CPU units when the task definition is registered.</p>
         *        <p>
         *        If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code>
         *        CPU units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
         *        </p>
         *        <p>
         *        If you use the Fargate launch type, this field is required. You must use one of the following values.
         *        These values determine the range of supported values for the <code>memory</code> parameter:
         *        </p>
         *        <p>
         *        The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4
         *        GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5
         *        GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of
         *        1024 (1 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of
         *        1024 (1 GB)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
         *        </p>
         *        <p>
         *        This option requires Linux platform <code>1.4.0</code> or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
         *        </p>
         *        <p>
         *        This option requires Linux platform <code>1.4.0</code> or later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
         * entered the <code>PENDING</code> state.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for the time when the task was created. More specifically, it's for the time when
         *        the task entered the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The desired status of the task. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
         * </p>
         * 
         * @param desiredStatus
         *        The desired status of the task. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
         *        Lifecycle</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredStatus(String desiredStatus);

        /**
         * <p>
         * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
         * command functionality is turned on all the containers in the task.
         * </p>
         * 
         * @param enableExecuteCommand
         *        Determines whether execute command functionality is turned on for this task. If <code>true</code>,
         *        execute command functionality is turned on all the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * The Unix timestamp for the time when the task execution stopped.
         * </p>
         * 
         * @param executionStoppedAt
         *        The Unix timestamp for the time when the task execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStoppedAt(Instant executionStoppedAt);

        /**
         * <p>
         * The name of the task group that's associated with the task.
         * </p>
         * 
         * @param group
         *        The name of the task group that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The health status for the task. It's determined by the health of the essential containers in the task. If all
         * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
         * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
         * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
         * container image and not specified in the container definition. For example, this includes those specified in
         * a parent image or from the image's Dockerfile. Health check parameters that are specified in a container
         * definition override any Docker health checks that are found in the container image.
         * </p>
         * </note>
         * 
         * @param healthStatus
         *        The health status for the task. It's determined by the health of the essential containers in the task.
         *        If all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also
         *        reports as <code>HEALTHY</code>. If any essential containers in the task are reporting as
         *        <code>UNHEALTHY</code> or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code>
         *        or <code>UNKNOWN</code>.</p> <note>
         *        <p>
         *        The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in
         *        a container image and not specified in the container definition. For example, this includes those
         *        specified in a parent image or from the image's Dockerfile. Health check parameters that are specified
         *        in a container definition override any Docker health checks that are found in the container image.
         *        </p>
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The health status for the task. It's determined by the health of the essential containers in the task. If all
         * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
         * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
         * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
         * </p>
         * <note>
         * <p>
         * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
         * container image and not specified in the container definition. For example, this includes those specified in
         * a parent image or from the image's Dockerfile. Health check parameters that are specified in a container
         * definition override any Docker health checks that are found in the container image.
         * </p>
         * </note>
         * 
         * @param healthStatus
         *        The health status for the task. It's determined by the health of the essential containers in the task.
         *        If all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also
         *        reports as <code>HEALTHY</code>. If any essential containers in the task are reporting as
         *        <code>UNHEALTHY</code> or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code>
         *        or <code>UNKNOWN</code>.</p> <note>
         *        <p>
         *        The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in
         *        a container image and not specified in the container definition. For example, this includes those
         *        specified in a parent image or from the image's Dockerfile. Health check parameters that are specified
         *        in a container definition override any Docker health checks that are found in the container image.
         *        </p>
         * @see HealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthStatus
         */
        Builder healthStatus(HealthStatus healthStatus);

        /**
         * <p>
         * The Elastic Inference accelerator that's associated with the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerator that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerator that's associated with the task.
         * </p>
         * 
         * @param inferenceAccelerators
         *        The Elastic Inference accelerator that's associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAccelerators(InferenceAccelerator... inferenceAccelerators);

        /**
         * <p>
         * The Elastic Inference accelerator that's associated with the task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.InferenceAccelerator.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.InferenceAccelerator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.InferenceAccelerator.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceAccelerators(List<InferenceAccelerator>)}.
         * 
         * @param inferenceAccelerators
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.InferenceAccelerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceAccelerators(java.util.Collection<InferenceAccelerator>)
         */
        Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder>... inferenceAccelerators);

        /**
         * <p>
         * The last known status for the task. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
         * </p>
         * 
         * @param lastStatus
         *        The last known status for the task. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
         *        Lifecycle</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatus(String lastStatus);

        /**
         * <p>
         * The infrastructure where your task runs on. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The infrastructure where your task runs on. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The infrastructure where your task runs on. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         * types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The infrastructure where your task runs on. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
         *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
         * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
         * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task
         * definition is registered.
         * </p>
         * <p>
         * If you use the EC2 launch type, this field is optional.
         * </p>
         * <p>
         * If you use the Fargate launch type, this field is required. You must use one of the following values. The
         * value that you choose determines the range of supported values for the <code>cpu</code> parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
         * <code>cpu</code> values: 1024 (1 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048
         * (2 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096
         * (4 vCPU)
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
         * </p>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * </p>
         * </li>
         * <li>
         * <p>
         * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
         * </p>
         * <p>
         * This option requires Linux platform <code>1.4.0</code> or later.
         * </p>
         * </li>
         * </ul>
         * 
         * @param memory
         *        The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be
         *        expressed as an integer using MiB (for example, <code>1024</code>). If it's expressed as a string
         *        using GB (for example, <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating
         *        the MiB when the task definition is registered.</p>
         *        <p>
         *        If you use the EC2 launch type, this field is optional.
         *        </p>
         *        <p>
         *        If you use the Fargate launch type, this field is required. You must use one of the following values.
         *        The value that you choose determines the range of supported values for the <code>cpu</code> parameter.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
         *        <code>cpu</code> values: 1024 (1 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code>
         *        values: 2048 (2 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code>
         *        values: 4096 (4 vCPU)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
         *        </p>
         *        <p>
         *        This option requires Linux platform <code>1.4.0</code> or later.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
         *        </p>
         *        <p>
         *        This option requires Linux platform <code>1.4.0</code> or later.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * One or more container overrides.
         * </p>
         * 
         * @param overrides
         *        One or more container overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(TaskOverride overrides);

        /**
         * <p>
         * One or more container overrides.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskOverride.Builder} avoiding the need
         * to create one manually via {@link TaskOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskOverride.Builder#build()} is called immediately and its
         * result is passed to {@link #overrides(TaskOverride)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link TaskOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(TaskOverride)
         */
        default Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return overrides(TaskOverride.builder().applyMutation(overrides).build());
        }

        /**
         * <p>
         * The platform version where your task runs on. A platform version is only specified for tasks that use the
         * Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
         * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version where your task runs on. A platform version is only specified for tasks that use
         *        the Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The operating system that your tasks are running on. A platform family is specified only for tasks that use
         * the Fargate launch type.
         * </p>
         * <p>
         * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
         * (for example, <code>LINUX.</code>).
         * </p>
         * 
         * @param platformFamily
         *        The operating system that your tasks are running on. A platform family is specified only for tasks
         *        that use the Fargate launch type. </p>
         *        <p>
         *        All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
         *        service (for example, <code>LINUX.</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFamily(String platformFamily);

        /**
         * <p>
         * The Unix timestamp for the time when the container image pull began.
         * </p>
         * 
         * @param pullStartedAt
         *        The Unix timestamp for the time when the container image pull began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullStartedAt(Instant pullStartedAt);

        /**
         * <p>
         * The Unix timestamp for the time when the container image pull completed.
         * </p>
         * 
         * @param pullStoppedAt
         *        The Unix timestamp for the time when the container image pull completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullStoppedAt(Instant pullStoppedAt);

        /**
         * <p>
         * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
         * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for the time when the task started. More specifically, it's for the time when the
         *        task transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The tag specified when a task is started. If an Amazon ECS service started the task, the
         * <code>startedBy</code> parameter contains the deployment ID of that service.
         * </p>
         * 
         * @param startedBy
         *        The tag specified when a task is started. If an Amazon ECS service started the task, the
         *        <code>startedBy</code> parameter contains the deployment ID of that service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBy(String startedBy);

        /**
         * <p>
         * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
         * details.
         * </p>
         * <p>
         * The following are valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TaskFailedToStart</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EssentialContainerExited</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UserInitiated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TerminationNotice</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ServiceSchedulerInitiated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SpotInterruption</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param stopCode
         *        The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain
         *        additional details.</p>
         *        <p>
         *        The following are valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TaskFailedToStart</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EssentialContainerExited</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UserInitiated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TerminationNotice</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ServiceSchedulerInitiated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SpotInterruption</code>
         *        </p>
         *        </li>
         * @see TaskStopCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStopCode
         */
        Builder stopCode(String stopCode);

        /**
         * <p>
         * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
         * details.
         * </p>
         * <p>
         * The following are valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TaskFailedToStart</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EssentialContainerExited</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UserInitiated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TerminationNotice</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ServiceSchedulerInitiated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SpotInterruption</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param stopCode
         *        The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain
         *        additional details.</p>
         *        <p>
         *        The following are valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TaskFailedToStart</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EssentialContainerExited</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UserInitiated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TerminationNotice</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ServiceSchedulerInitiated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SpotInterruption</code>
         *        </p>
         *        </li>
         * @see TaskStopCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStopCode
         */
        Builder stopCode(TaskStopCode stopCode);

        /**
         * <p>
         * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
         * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
         * </p>
         * 
         * @param stoppedAt
         *        The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when
         *        the task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedAt(Instant stoppedAt);

        /**
         * <p>
         * The reason that the task was stopped.
         * </p>
         * 
         * @param stoppedReason
         *        The reason that the task was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedReason(String stoppedReason);

        /**
         * <p>
         * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
         * transitions from the <code>RUNNING</code> state to <code>STOPPED</code>.
         * </p>
         * 
         * @param stoppingAt
         *        The Unix timestamp for the time when the task stops. More specifically, it's for the time when the
         *        task transitions from the <code>RUNNING</code> state to <code>STOPPED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingAt(Instant stoppingAt);

        /**
         * <p>
         * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a
         * key and an optional value. You define both the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task to help you categorize and organize the task. Each tag
         *        consists of a key and an optional value. You define both the key and value.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a
         * key and an optional value. You define both the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the task to help you categorize and organize the task. Each tag
         *        consists of a key and an optional value. You define both the key and value.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a
         * key and an optional value. You define both the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon Resource Name (ARN) of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The ARN of the task definition that creates the task.
         * </p>
         * 
         * @param taskDefinitionArn
         *        The ARN of the task definition that creates the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitionArn(String taskDefinitionArn);

        /**
         * <p>
         * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
         * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
         * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
         * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream
         * is current.
         * </p>
         * 
         * @param version
         *        The version counter for the task. Every time a task experiences a change that starts a CloudWatch
         *        event, the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch
         *        Events, you can compare the version of a task reported by the Amazon ECS API actions with the version
         *        reported in CloudWatch Events for the task (inside the <code>detail</code> object) to verify that the
         *        version in your event stream is current.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The ephemeral storage settings for the task.
         * </p>
         * 
         * @param ephemeralStorage
         *        The ephemeral storage settings for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(EphemeralStorage ephemeralStorage);

        /**
         * <p>
         * The ephemeral storage settings for the task.
         * </p>
         * This is a convenience method that creates an instance of the {@link EphemeralStorage.Builder} avoiding the
         * need to create one manually via {@link EphemeralStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemeralStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #ephemeralStorage(EphemeralStorage)}.
         * 
         * @param ephemeralStorage
         *        a consumer that will call methods on {@link EphemeralStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemeralStorage(EphemeralStorage)
         */
        default Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return ephemeralStorage(EphemeralStorage.builder().applyMutation(ephemeralStorage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Attachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String capacityProviderName;

        private String clusterArn;

        private String connectivity;

        private Instant connectivityAt;

        private String containerInstanceArn;

        private List<Container> containers = DefaultSdkAutoConstructList.getInstance();

        private String cpu;

        private Instant createdAt;

        private String desiredStatus;

        private Boolean enableExecuteCommand;

        private Instant executionStoppedAt;

        private String group;

        private String healthStatus;

        private List<InferenceAccelerator> inferenceAccelerators = DefaultSdkAutoConstructList.getInstance();

        private String lastStatus;

        private String launchType;

        private String memory;

        private TaskOverride overrides;

        private String platformVersion;

        private String platformFamily;

        private Instant pullStartedAt;

        private Instant pullStoppedAt;

        private Instant startedAt;

        private String startedBy;

        private String stopCode;

        private Instant stoppedAt;

        private String stoppedReason;

        private Instant stoppingAt;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String taskArn;

        private String taskDefinitionArn;

        private Long version;

        private EphemeralStorage ephemeralStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            attachments(model.attachments);
            attributes(model.attributes);
            availabilityZone(model.availabilityZone);
            capacityProviderName(model.capacityProviderName);
            clusterArn(model.clusterArn);
            connectivity(model.connectivity);
            connectivityAt(model.connectivityAt);
            containerInstanceArn(model.containerInstanceArn);
            containers(model.containers);
            cpu(model.cpu);
            createdAt(model.createdAt);
            desiredStatus(model.desiredStatus);
            enableExecuteCommand(model.enableExecuteCommand);
            executionStoppedAt(model.executionStoppedAt);
            group(model.group);
            healthStatus(model.healthStatus);
            inferenceAccelerators(model.inferenceAccelerators);
            lastStatus(model.lastStatus);
            launchType(model.launchType);
            memory(model.memory);
            overrides(model.overrides);
            platformVersion(model.platformVersion);
            platformFamily(model.platformFamily);
            pullStartedAt(model.pullStartedAt);
            pullStoppedAt(model.pullStoppedAt);
            startedAt(model.startedAt);
            startedBy(model.startedBy);
            stopCode(model.stopCode);
            stoppedAt(model.stoppedAt);
            stoppedReason(model.stoppedReason);
            stoppingAt(model.stoppingAt);
            tags(model.tags);
            taskArn(model.taskArn);
            taskDefinitionArn(model.taskDefinitionArn);
            version(model.version);
            ephemeralStorage(model.ephemeralStorage);
        }

        public final List<Attachment.Builder> getAttachments() {
            List<Attachment.Builder> result = AttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<Attachment.BuilderImpl> attachments) {
            this.attachments = AttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<Attachment> attachments) {
            this.attachments = AttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Attachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<Attachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> Attachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Attribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getCapacityProviderName() {
            return capacityProviderName;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getConnectivity() {
            return connectivity;
        }

        public final void setConnectivity(String connectivity) {
            this.connectivity = connectivity;
        }

        @Override
        public final Builder connectivity(String connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public final Builder connectivity(Connectivity connectivity) {
            this.connectivity(connectivity == null ? null : connectivity.toString());
            return this;
        }

        public final Instant getConnectivityAt() {
            return connectivityAt;
        }

        public final void setConnectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
        }

        @Override
        public final Builder connectivityAt(Instant connectivityAt) {
            this.connectivityAt = connectivityAt;
            return this;
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final List<Container.Builder> getContainers() {
            List<Container.Builder> result = ContainersCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<Container.BuilderImpl> containers) {
            this.containers = ContainersCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<Container> containers) {
            this.containers = ContainersCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Container... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<Container.Builder>... containers) {
            containers(Stream.of(containers).map(c -> Container.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDesiredStatus() {
            return desiredStatus;
        }

        public final void setDesiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
        }

        @Override
        public final Builder desiredStatus(String desiredStatus) {
            this.desiredStatus = desiredStatus;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final Instant getExecutionStoppedAt() {
            return executionStoppedAt;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        @Override
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final List<InferenceAccelerator.Builder> getInferenceAccelerators() {
            List<InferenceAccelerator.Builder> result = InferenceAcceleratorsCopier.copyToBuilder(this.inferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceAccelerators(Collection<InferenceAccelerator.BuilderImpl> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copyFromBuilder(inferenceAccelerators);
        }

        @Override
        public final Builder inferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = InferenceAcceleratorsCopier.copy(inferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(InferenceAccelerator... inferenceAccelerators) {
            inferenceAccelerators(Arrays.asList(inferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAccelerators(Consumer<InferenceAccelerator.Builder>... inferenceAccelerators) {
            inferenceAccelerators(Stream.of(inferenceAccelerators)
                    .map(c -> InferenceAccelerator.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastStatus() {
            return lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final TaskOverride.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPlatformFamily() {
            return platformFamily;
        }

        public final void setPlatformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
        }

        @Override
        public final Builder platformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
            return this;
        }

        public final Instant getPullStartedAt() {
            return pullStartedAt;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        @Override
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final Instant getPullStoppedAt() {
            return pullStoppedAt;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        @Override
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStartedBy() {
            return startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final String getStopCode() {
            return stopCode;
        }

        public final void setStopCode(String stopCode) {
            this.stopCode = stopCode;
        }

        @Override
        public final Builder stopCode(String stopCode) {
            this.stopCode = stopCode;
            return this;
        }

        @Override
        public final Builder stopCode(TaskStopCode stopCode) {
            this.stopCode(stopCode == null ? null : stopCode.toString());
            return this;
        }

        public final Instant getStoppedAt() {
            return stoppedAt;
        }

        public final void setStoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Instant stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final String getStoppedReason() {
            return stoppedReason;
        }

        public final void setStoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
        }

        @Override
        public final Builder stoppedReason(String stoppedReason) {
            this.stoppedReason = stoppedReason;
            return this;
        }

        public final Instant getStoppingAt() {
            return stoppingAt;
        }

        public final void setStoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
        }

        @Override
        public final Builder stoppingAt(Instant stoppingAt) {
            this.stoppingAt = stoppingAt;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskDefinitionArn() {
            return taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return ephemeralStorage != null ? ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        @Override
        public Task build() {
            return new Task(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
