/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse;

public class ListTaskDefinitionsIterable
implements SdkIterable<ListTaskDefinitionsResponse> {
    private final EcsClient client;
    private final ListTaskDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskDefinitionsIterable(EcsClient client, ListTaskDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTaskDefinitionsResponseFetcher();
    }

    public Iterator<ListTaskDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> taskDefinitionArns() {
        Function<ListTaskDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskDefinitionArns() != null) {
                return response.taskDefinitionArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaskDefinitionsResponseFetcher
    implements SyncPageFetcher<ListTaskDefinitionsResponse> {
        private ListTaskDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskDefinitionsResponse nextPage(ListTaskDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaskDefinitionsIterable.this.client.listTaskDefinitions(ListTaskDefinitionsIterable.this.firstRequest);
            }
            return ListTaskDefinitionsIterable.this.client.listTaskDefinitions((ListTaskDefinitionsRequest)((Object)ListTaskDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

