/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(UpdateServiceRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCount").getter(getter(UpdateServiceRequest::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(UpdateServiceRequest::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("capacityProviderStrategy")
            .getter(getter(UpdateServiceRequest::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(UpdateServiceRequest::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(UpdateServiceRequest::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(UpdateServiceRequest::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .memberName("placementStrategy")
            .getter(getter(UpdateServiceRequest::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(UpdateServiceRequest::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<Boolean> FORCE_NEW_DEPLOYMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceNewDeployment").getter(getter(UpdateServiceRequest::forceNewDeployment))
            .setter(setter(Builder::forceNewDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceNewDeployment").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckGracePeriodSeconds")
            .getter(getter(UpdateServiceRequest::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExecuteCommand").getter(getter(UpdateServiceRequest::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build())
            .build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableECSManagedTags").getter(getter(UpdateServiceRequest::enableECSManagedTags))
            .setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .memberName("loadBalancers")
            .getter(getter(UpdateServiceRequest::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propagateTags").getter(getter(UpdateServiceRequest::propagateTagsAsString))
            .setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .memberName("serviceRegistries")
            .getter(getter(UpdateServiceRequest::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField
            .<ServiceConnectConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serviceConnectConfiguration")
            .getter(getter(UpdateServiceRequest::serviceConnectConfiguration))
            .setter(setter(Builder::serviceConnectConfiguration))
            .constructor(ServiceConnectConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            DESIRED_COUNT_FIELD, TASK_DEFINITION_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD,
            FORCE_NEW_DEPLOYMENT_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD,
            ENABLE_ECS_MANAGED_TAGS_FIELD, LOAD_BALANCERS_FIELD, PROPAGATE_TAGS_FIELD, SERVICE_REGISTRIES_FIELD,
            SERVICE_CONNECT_CONFIGURATION_FIELD));

    private final String cluster;

    private final String service;

    private final Integer desiredCount;

    private final String taskDefinition;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final DeploymentConfiguration deploymentConfiguration;

    private final NetworkConfiguration networkConfiguration;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final String platformVersion;

    private final Boolean forceNewDeployment;

    private final Integer healthCheckGracePeriodSeconds;

    private final Boolean enableExecuteCommand;

    private final Boolean enableECSManagedTags;

    private final List<LoadBalancer> loadBalancers;

    private final String propagateTags;

    private final List<ServiceRegistry> serviceRegistries;

    private final ServiceConnectConfiguration serviceConnectConfiguration;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.desiredCount = builder.desiredCount;
        this.taskDefinition = builder.taskDefinition;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.forceNewDeployment = builder.forceNewDeployment;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.loadBalancers = builder.loadBalancers;
        this.propagateTags = builder.propagateTags;
        this.serviceRegistries = builder.serviceRegistries;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify
     * a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not
     *         specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The name of the service to update.
     * </p>
     * 
     * @return The name of the service to update.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The number of instantiations of the task to place and keep running in your service.
     * </p>
     * 
     * @return The number of instantiations of the task to place and keep running in your service.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     * definition to run in your service. If a <code>revision</code> is not specified, the latest <code>ACTIVE</code>
     * revision is used. If you modify the task definition with <code>UpdateService</code>, Amazon ECS spawns a task
     * with the new version of the task definition and then stops an old task after the new version is running.
     * </p>
     * 
     * @return The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
     *         definition to run in your service. If a <code>revision</code> is not specified, the latest
     *         <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
     *         Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the
     *         new version is running.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviderStrategy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to update the service to use.
     * </p>
     * <p>
     * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one
     * or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using
     * a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to
     * use the cluster's default capacity provider strategy.
     * </p>
     * <p>
     * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
     * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in a
     * capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity provider
     * with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created.
     * New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity
     * providers. The Fargate capacity providers are available to all accounts and only need to be associated with a
     * cluster to be used.
     * </p>
     * <p>
     * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity providers
     * for a cluster after the cluster is created.
     * </p>
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviderStrategy} method.
     * </p>
     * 
     * @return The capacity provider strategy to update the service to use.</p>
     *         <p>
     *         if the service uses the default capacity provider strategy for the cluster, the service can be updated to
     *         use one or more capacity providers as opposed to the default capacity provider strategy. However, when a
     *         service is using a capacity provider strategy that's not the default capacity provider strategy, the
     *         service can't be updated to use the cluster's default capacity provider strategy.
     *         </p>
     *         <p>
     *         A capacity provider strategy consists of one or more capacity providers along with the <code>base</code>
     *         and <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be
     *         used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a
     *         capacity provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or
     *         <code>UPDATING</code> status can be used.
     *         </p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
     *         created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     *         capacity providers. The Fargate capacity providers are available to all accounts and only need to be
     *         associated with a cluster to be used.
     *         </p>
     *         <p>
     *         The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
     *         providers for a cluster after the cluster is created.
     *         </p>
     */
    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * An object representing the network configuration for the service.
     * </p>
     * 
     * @return An object representing the network configuration for the service.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of task placement constraint objects to update the service to use. If no value is specified, the
     * existing placement constraints for the service will remain unchanged. If this value is specified, it will
     * override any existing placement constraints defined for the service. To remove all existing placement
     * constraints, specify an empty array.
     * </p>
     * <p>
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition
     * and those specified at runtime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return An array of task placement constraint objects to update the service to use. If no value is specified, the
     *         existing placement constraints for the service will remain unchanged. If this value is specified, it will
     *         override any existing placement constraints defined for the service. To remove all existing placement
     *         constraints, specify an empty array.</p>
     *         <p>
     *         You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
     *         definition and those specified at runtime.
     */
    public final List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementStrategy property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementStrategy() {
        return placementStrategy != null && !(placementStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task placement strategy objects to update the service to use. If no value is specified, the existing
     * placement strategy for the service will remain unchanged. If this value is specified, it will override the
     * existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty
     * object.
     * </p>
     * <p>
     * You can specify a maximum of five strategy rules for each service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementStrategy} method.
     * </p>
     * 
     * @return The task placement strategy objects to update the service to use. If no value is specified, the existing
     *         placement strategy for the service will remain unchanged. If this value is specified, it will override
     *         the existing placement strategy defined for the service. To remove an existing placement strategy,
     *         specify an empty object.</p>
     *         <p>
     *         You can specify a maximum of five strategy rules for each service.
     */
    public final List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The platform version that your tasks in the service run on. A platform version is only specified for tasks using
     * the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform version is
     * used. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version that your tasks in the service run on. A platform version is only specified for
     *         tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code>
     *         platform version is used. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use
     * this option to start a new deployment with no service definition changes. For example, you can update a service's
     * tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>) or to roll
     * Fargate tasks onto a newer platform version.
     * </p>
     * 
     * @return Determines whether to force a new deployment of the service. By default, deployments aren't forced. You
     *         can use this option to start a new deployment with no service definition changes. For example, you can
     *         update a service's tasks to use a newer Docker image with the same image/tag combination (
     *         <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
     */
    public final Boolean forceNewDeployment() {
        return forceNewDeployment;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing
     * target health checks after a task has first started. This is only valid if your service is configured to use a
     * load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks,
     * you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS
     * service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS
     * service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
     *         Balancing target health checks after a task has first started. This is only valid if your service is
     *         configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic
     *         Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds.
     *         During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check
     *         status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and
     *         stopping them before they have time to come up.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * If <code>true</code>, this enables execute command functionality on all task containers.
     * </p>
     * <p>
     * If you do not want to override the value that was set when the service was created, you can set this to
     * <code>null</code> when performing this action.
     * </p>
     * 
     * @return If <code>true</code>, this enables execute command functionality on all task containers.</p>
     *         <p>
     *         If you do not want to override the value that was set when the service was created, you can set this to
     *         <code>null</code> when performing this action.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
     * Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * 
     * @return Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging
     *         Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     */
    public final Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name,
     * and the container port to access from the load balancer. The container name is as it appears in a container
     * definition.
     * </p>
     * <p>
     * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
     * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
     * </p>
     * <p>
     * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You
     * can update from a single target group to multiple target groups and from multiple target groups to a single
     * target group.
     * </p>
     * <p>
     * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
     * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
     * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
     * information see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
     * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * For services that use the external deployment controller, you can add, update, or remove load balancers by using
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
     * Note that multiple target groups are not supported for external deployments. For more information see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
     * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * You can remove existing <code>loadBalancers</code> by passing an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
     *         name, and the container port to access from the load balancer. The container name is as it appears in a
     *         container definition.</p>
     *         <p>
     *         When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
     *         updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
     *         running.
     *         </p>
     *         <p>
     *         For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
     *         groups. You can update from a single target group to multiple target groups and from multiple target
     *         groups to a single target group.
     *         </p>
     *         <p>
     *         For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
     *         using
     *         <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
     *         through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
     *         more information see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
     *         >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     *         </p>
     *         <p>
     *         For services that use the external deployment controller, you can add, update, or remove load balancers
     *         by using <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet
     *         </a>. Note that multiple target groups are not supported for external deployments. For more information
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
     *         >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     *         </p>
     *         <p>
     *         You can remove existing <code>loadBalancers</code> by passing an empty list.
     */
    public final List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     * @see PropagateTags
     */
    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated tags.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.</p>
     *         <p>
     *         Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
     *         <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
     *         updated tags.
     * @see PropagateTags
     */
    public final String propagateTagsAsString() {
        return propagateTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceRegistries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the service discovery registries to assign to this service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <p>
     * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
     * updated service registries configuration, and then stops the old tasks when the new tasks are running.
     * </p>
     * <p>
     * You can remove existing <code>serviceRegistries</code> by passing an empty list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceRegistries} method.
     * </p>
     * 
     * @return The details for the service discovery registries to assign to this service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.</p>
     *         <p>
     *         When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
     *         the updated service registries configuration, and then stops the old tasks when the new tasks are
     *         running.
     *         </p>
     *         <p>
     *         You can remove existing <code>serviceRegistries</code> by passing an empty list.
     */
    public final List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from,
     * other services within a namespace.
     * </p>
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
     * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
     * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported
     * with Service Connect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The configuration for this service to discover and connect to services, and be discovered by, and
     *         connected from, other services within a namespace.</p>
     *         <p>
     *         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
     *         connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
     *         container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
     *         services create are supported with Service Connect. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return serviceConnectConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategy() ? placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(forceNewDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceRegistries() ? serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceConnectConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(desiredCount(), other.desiredCount())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategy() == other.hasPlacementStrategy()
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(forceNewDeployment(), other.forceNewDeployment())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(loadBalancers(), other.loadBalancers())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString())
                && hasServiceRegistries() == other.hasServiceRegistries()
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(serviceConnectConfiguration(), other.serviceConnectConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceRequest").add("Cluster", cluster()).add("Service", service())
                .add("DesiredCount", desiredCount()).add("TaskDefinition", taskDefinition())
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("DeploymentConfiguration", deploymentConfiguration()).add("NetworkConfiguration", networkConfiguration())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategy", hasPlacementStrategy() ? placementStrategy() : null)
                .add("PlatformVersion", platformVersion()).add("ForceNewDeployment", forceNewDeployment())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("EnableExecuteCommand", enableExecuteCommand()).add("EnableECSManagedTags", enableECSManagedTags())
                .add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null).add("PropagateTags", propagateTagsAsString())
                .add("ServiceRegistries", hasServiceRegistries() ? serviceRegistries() : null)
                .add("ServiceConnectConfiguration", serviceConnectConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "forceNewDeployment":
            return Optional.ofNullable(clazz.cast(forceNewDeployment()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "enableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "serviceConnectConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConnectConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do
         *        not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The name of the service to update.
         * </p>
         * 
         * @param service
         *        The name of the service to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The number of instantiations of the task to place and keep running in your service.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the task to place and keep running in your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the task
         * definition to run in your service. If a <code>revision</code> is not specified, the latest
         * <code>ACTIVE</code> revision is used. If you modify the task definition with <code>UpdateService</code>,
         * Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new
         * version is running.
         * </p>
         * 
         * @param taskDefinition
         *        The <code>family</code> and <code>revision</code> (<code>family:revision</code>) or full ARN of the
         *        task definition to run in your service. If a <code>revision</code> is not specified, the latest
         *        <code>ACTIVE</code> revision is used. If you modify the task definition with
         *        <code>UpdateService</code>, Amazon ECS spawns a task with the new version of the task definition and
         *        then stops an old task after the new version is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use
         * one or more capacity providers as opposed to the default capacity provider strategy. However, when a service
         * is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be
         * updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to update the service to use.
         *        </p>
         *        <p>
         *        if the service uses the default capacity provider strategy for the cluster, the service can be updated
         *        to use one or more capacity providers as opposed to the default capacity provider strategy. However,
         *        when a service is using a capacity provider strategy that's not the default capacity provider
         *        strategy, the service can't be updated to use the cluster's default capacity provider strategy.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use
         * one or more capacity providers as opposed to the default capacity provider strategy. However, when a service
         * is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be
         * updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy to update the service to use.
         *        </p>
         *        <p>
         *        if the service uses the default capacity provider strategy for the cluster, the service can be updated
         *        to use one or more capacity providers as opposed to the default capacity provider strategy. However,
         *        when a service is using a capacity provider strategy that's not the default capacity provider
         *        strategy, the service can't be updated to use the cluster's default capacity provider strategy.
         *        </p>
         *        <p>
         *        A capacity provider strategy consists of one or more capacity providers along with the
         *        <code>base</code> and <code>weight</code> to assign to them. A capacity provider must be associated
         *        with the cluster to be used in a capacity provider strategy. The <a>PutClusterCapacityProviders</a>
         *        API is used to associate a capacity provider with a cluster. Only capacity providers with an
         *        <code>ACTIVE</code> or <code>UPDATING</code> status can be used.
         *        </p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already
         *        be created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API
         *        operation.
         *        </p>
         *        <p>
         *        To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         *        providers for a cluster after the cluster is created.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to update the service to use.
         * </p>
         * <p>
         * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use
         * one or more capacity providers as opposed to the default capacity provider strategy. However, when a service
         * is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be
         * updated to use the cluster's default capacity provider strategy.
         * </p>
         * <p>
         * A capacity provider strategy consists of one or more capacity providers along with the <code>base</code> and
         * <code>weight</code> to assign to them. A capacity provider must be associated with the cluster to be used in
         * a capacity provider strategy. The <a>PutClusterCapacityProviders</a> API is used to associate a capacity
         * provider with a cluster. Only capacity providers with an <code>ACTIVE</code> or <code>UPDATING</code> status
         * can be used.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be
         * created. New capacity providers can be created with the <a>CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a>PutClusterCapacityProviders</a> API operation is used to update the list of available capacity
         * providers for a cluster after the cluster is created.
         * </p>
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(java.util.Collection<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * An object representing the network configuration for the service.
         * </p>
         * 
         * @param networkConfiguration
         *        An object representing the network configuration for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * An object representing the network configuration for the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         *        definition and those specified at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * 
         * @param placementConstraints
         *        An array of task placement constraint objects to update the service to use. If no value is specified,
         *        the existing placement constraints for the service will remain unchanged. If this value is specified,
         *        it will override any existing placement constraints defined for the service. To remove all existing
         *        placement constraints, specify an empty array.</p>
         *        <p>
         *        You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         *        definition and those specified at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * An array of task placement constraint objects to update the service to use. If no value is specified, the
         * existing placement constraints for the service will remain unchanged. If this value is specified, it will
         * override any existing placement constraints defined for the service. To remove all existing placement
         * constraints, specify an empty array.
         * </p>
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task
         * definition and those specified at runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules for each service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * 
         * @param placementStrategy
         *        The task placement strategy objects to update the service to use. If no value is specified, the
         *        existing placement strategy for the service will remain unchanged. If this value is specified, it will
         *        override the existing placement strategy defined for the service. To remove an existing placement
         *        strategy, specify an empty object.</p>
         *        <p>
         *        You can specify a maximum of five strategy rules for each service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The task placement strategy objects to update the service to use. If no value is specified, the existing
         * placement strategy for the service will remain unchanged. If this value is specified, it will override the
         * existing placement strategy defined for the service. To remove an existing placement strategy, specify an
         * empty object.
         * </p>
         * <p>
         * You can specify a maximum of five strategy rules for each service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder#build()} is called immediately and
         * its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(java.util.Collection<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The platform version that your tasks in the service run on. A platform version is only specified for tasks
         * using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code> platform
         * version is used. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
         * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version that your tasks in the service run on. A platform version is only specified for
         *        tasks using the Fargate launch type. If a platform version is not specified, the <code>LATEST</code>
         *        platform version is used. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can
         * use this option to start a new deployment with no service definition changes. For example, you can update a
         * service's tasks to use a newer Docker image with the same image/tag combination (<code>my_image:latest</code>
         * ) or to roll Fargate tasks onto a newer platform version.
         * </p>
         * 
         * @param forceNewDeployment
         *        Determines whether to force a new deployment of the service. By default, deployments aren't forced.
         *        You can use this option to start a new deployment with no service definition changes. For example, you
         *        can update a service's tasks to use a newer Docker image with the same image/tag combination (
         *        <code>my_image:latest</code>) or to roll Fargate tasks onto a newer platform version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceNewDeployment(Boolean forceNewDeployment);

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         * Balancing target health checks after a task has first started. This is only valid if your service is
         * configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load
         * Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During
         * that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This
         * grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before
         * they have time to come up.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         *        Balancing target health checks after a task has first started. This is only valid if your service is
         *        configured to use a load balancer. If your service's tasks take a while to start and respond to
         *        Elastic Load Balancing health checks, you can specify a health check grace period of up to
         *        2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load
         *        Balancing health check status. This grace period can prevent the ECS service scheduler from marking
         *        tasks as unhealthy and stopping them before they have time to come up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * If <code>true</code>, this enables execute command functionality on all task containers.
         * </p>
         * <p>
         * If you do not want to override the value that was set when the service was created, you can set this to
         * <code>null</code> when performing this action.
         * </p>
         * 
         * @param enableExecuteCommand
         *        If <code>true</code>, this enables execute command functionality on all task containers.</p>
         *        <p>
         *        If you do not want to override the value that was set when the service was created, you can set this
         *        to <code>null</code> when performing this action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon
         * ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
         *        Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.</p>
         *        <p>
         *        When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
         *        updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
         *        groups. You can update from a single target group to multiple target groups and from multiple target
         *        groups to a single target group.
         *        </p>
         *        <p>
         *        For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
         *        using
         *        <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         *        through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        For services that use the external deployment controller, you can add, update, or remove load
         *        balancers by using <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html"
         *        >CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can remove existing <code>loadBalancers</code> by passing an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.</p>
         *        <p>
         *        When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the
         *        updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target
         *        groups. You can update from a single target group to multiple target groups and from multiple target
         *        groups to a single target group.
         *        </p>
         *        <p>
         *        For services that use blue/green deployments, you can update Elastic Load Balancing target groups by
         *        using
         *        <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         *        through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        For services that use the external deployment controller, you can add, update, or remove load
         *        balancers by using <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html"
         *        >CreateTaskSet</a>. Note that multiple target groups are not supported for external deployments. For
         *        more information see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         *        >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can remove existing <code>loadBalancers</code> by passing an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * <p>
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated
         * Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups.
         * You can update from a single target group to multiple target groups and from multiple target groups to a
         * single target group.
         * </p>
         * <p>
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using
         * <code> <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> </code>
         * through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more
         * information see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html"
         * >Register multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * <p>
         * For services that use the external deployment controller, you can add, update, or remove load balancers by
         * using <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html">CreateTaskSet</a>.
         * Note that multiple target groups are not supported for external deployments. For more information see <a
         * href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Register
         * multiple target groups with a service</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <p>
         * You can remove existing <code>loadBalancers</code> by passing an empty list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.LoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * <p>
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         * <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the updated
         * tags.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.</p>
         *        <p>
         *        Only tasks launched after the update will reflect the update. To update the tags on all tasks, set
         *        <code>forceNewDeployment</code> to <code>true</code>, so that Amazon ECS starts new tasks with the
         *        updated tags.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * 
         * @param serviceRegistries
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.</p>
         *        <p>
         *        When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
         *        the updated service registries configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * 
         * @param serviceRegistries
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.</p>
         *        <p>
         *        When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with
         *        the updated service registries configuration, and then stops the old tasks when the new tasks are
         *        running.
         *        </p>
         *        <p>
         *        You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * <p>
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the
         * updated service registries configuration, and then stops the old tasks when the new tasks are running.
         * </p>
         * <p>
         * You can remove existing <code>serviceRegistries</code> by passing an empty list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(java.util.Collection<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param serviceConnectConfiguration
         *        The configuration for this service to discover and connect to services, and be discovered by, and
         *        connected from, other services within a namespace.</p>
         *        <p>
         *        Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
         *        connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
         *        container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
         *        services create are supported with Service Connect. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration);

        /**
         * <p>
         * The configuration for this service to discover and connect to services, and be discovered by, and connected
         * from, other services within a namespace.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceConnectConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServiceConnectConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceConnectConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConnectConfiguration(ServiceConnectConfiguration)}.
         * 
         * @param serviceConnectConfiguration
         *        a consumer that will call methods on {@link ServiceConnectConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConnectConfiguration(ServiceConnectConfiguration)
         */
        default Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return serviceConnectConfiguration(ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private Integer desiredCount;

        private String taskDefinition;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfiguration deploymentConfiguration;

        private NetworkConfiguration networkConfiguration;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private Boolean forceNewDeployment;

        private Integer healthCheckGracePeriodSeconds;

        private Boolean enableExecuteCommand;

        private Boolean enableECSManagedTags;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private String propagateTags;

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private ServiceConnectConfiguration serviceConnectConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            desiredCount(model.desiredCount);
            taskDefinition(model.taskDefinition);
            capacityProviderStrategy(model.capacityProviderStrategy);
            deploymentConfiguration(model.deploymentConfiguration);
            networkConfiguration(model.networkConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            platformVersion(model.platformVersion);
            forceNewDeployment(model.forceNewDeployment);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            enableExecuteCommand(model.enableExecuteCommand);
            enableECSManagedTags(model.enableECSManagedTags);
            loadBalancers(model.loadBalancers);
            propagateTags(model.propagateTags);
            serviceRegistries(model.serviceRegistries);
            serviceConnectConfiguration(model.serviceConnectConfiguration);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier
                    .copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final Boolean getForceNewDeployment() {
            return forceNewDeployment;
        }

        public final void setForceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
        }

        @Override
        public final Builder forceNewDeployment(Boolean forceNewDeployment) {
            this.forceNewDeployment = forceNewDeployment;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return serviceConnectConfiguration != null ? serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
