/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTaskProtectionResponse extends EcsResponse implements
        ToCopyableBuilder<UpdateTaskProtectionResponse.Builder, UpdateTaskProtectionResponse> {
    private static final SdkField<List<ProtectedTask>> PROTECTED_TASKS_FIELD = SdkField
            .<List<ProtectedTask>> builder(MarshallingType.LIST)
            .memberName("protectedTasks")
            .getter(getter(UpdateTaskProtectionResponse::protectedTasks))
            .setter(setter(Builder::protectedTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectedTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProtectedTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProtectedTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(UpdateTaskProtectionResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTED_TASKS_FIELD,
            FAILURES_FIELD));

    private final List<ProtectedTask> protectedTasks;

    private final List<Failure> failures;

    private UpdateTaskProtectionResponse(BuilderImpl builder) {
        super(builder);
        this.protectedTasks = builder.protectedTasks;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectedTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectedTasks() {
        return protectedTasks != null && !(protectedTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tasks with the following information.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>taskArn</code>: The task ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on for a
     * task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expirationDate</code>: The epoch time when protection for the task will expire.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectedTasks} method.
     * </p>
     * 
     * @return A list of tasks with the following information.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>taskArn</code>: The task ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on
     *         for a task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expirationDate</code>: The epoch time when protection for the task will expire.
     *         </p>
     *         </li>
     */
    public final List<ProtectedTask> protectedTasks() {
        return protectedTasks;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectedTasks() ? protectedTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskProtectionResponse)) {
            return false;
        }
        UpdateTaskProtectionResponse other = (UpdateTaskProtectionResponse) obj;
        return hasProtectedTasks() == other.hasProtectedTasks() && Objects.equals(protectedTasks(), other.protectedTasks())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTaskProtectionResponse")
                .add("ProtectedTasks", hasProtectedTasks() ? protectedTasks() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "protectedTasks":
            return Optional.ofNullable(clazz.cast(protectedTasks()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskProtectionResponse, T> g) {
        return obj -> g.apply((UpdateTaskProtectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTaskProtectionResponse> {
        /**
         * <p>
         * A list of tasks with the following information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>taskArn</code>: The task ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on for a
         * task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expirationDate</code>: The epoch time when protection for the task will expire.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectedTasks
         *        A list of tasks with the following information.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>taskArn</code>: The task ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on
         *        for a task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expirationDate</code>: The epoch time when protection for the task will expire.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedTasks(Collection<ProtectedTask> protectedTasks);

        /**
         * <p>
         * A list of tasks with the following information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>taskArn</code>: The task ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on for a
         * task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expirationDate</code>: The epoch time when protection for the task will expire.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protectedTasks
         *        A list of tasks with the following information.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>taskArn</code>: The task ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on
         *        for a task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expirationDate</code>: The epoch time when protection for the task will expire.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedTasks(ProtectedTask... protectedTasks);

        /**
         * <p>
         * A list of tasks with the following information.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>taskArn</code>: The task ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>protectionEnabled</code>: The protection status of the task. If scale-in protection is turned on for a
         * task, the value is <code>true</code>. Otherwise, it is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expirationDate</code>: The epoch time when protection for the task will expire.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ProtectedTask.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ProtectedTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ProtectedTask.Builder#build()} is called immediately and its
         * result is passed to {@link #protectedTasks(List<ProtectedTask>)}.
         * 
         * @param protectedTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ProtectedTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protectedTasks(java.util.Collection<ProtectedTask>)
         */
        Builder protectedTasks(Consumer<ProtectedTask.Builder>... protectedTasks);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Failure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Failure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<ProtectedTask> protectedTasks = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskProtectionResponse model) {
            super(model);
            protectedTasks(model.protectedTasks);
            failures(model.failures);
        }

        public final List<ProtectedTask.Builder> getProtectedTasks() {
            List<ProtectedTask.Builder> result = ProtectedTasksCopier.copyToBuilder(this.protectedTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtectedTasks(Collection<ProtectedTask.BuilderImpl> protectedTasks) {
            this.protectedTasks = ProtectedTasksCopier.copyFromBuilder(protectedTasks);
        }

        @Override
        public final Builder protectedTasks(Collection<ProtectedTask> protectedTasks) {
            this.protectedTasks = ProtectedTasksCopier.copy(protectedTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedTasks(ProtectedTask... protectedTasks) {
            protectedTasks(Arrays.asList(protectedTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectedTasks(Consumer<ProtectedTask.Builder>... protectedTasks) {
            protectedTasks(Stream.of(protectedTasks).map(c -> ProtectedTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateTaskProtectionResponse build() {
            return new UpdateTaskProtectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
