/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AvailabilityZoneRebalancing;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.DeploymentConfiguration;
import software.amazon.awssdk.services.ecs.model.DeploymentController;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.LoadBalancer;
import software.amazon.awssdk.services.ecs.model.LoadBalancersCopier;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.SchedulingStrategy;
import software.amazon.awssdk.services.ecs.model.ServiceConnectConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceRegistriesCopier;
import software.amazon.awssdk.services.ecs.model.ServiceRegistry;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.ServiceVolumeConfigurationsCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.VpcLatticeConfiguration;
import software.amazon.awssdk.services.ecs.model.VpcLatticeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(CreateServiceRequest.getter(CreateServiceRequest::cluster)).setter(CreateServiceRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(CreateServiceRequest.getter(CreateServiceRequest::serviceName)).setter(CreateServiceRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(CreateServiceRequest.getter(CreateServiceRequest::taskDefinition)).setter(CreateServiceRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_REBALANCING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneRebalancing").getter(CreateServiceRequest.getter(CreateServiceRequest::availabilityZoneRebalancingAsString)).setter(CreateServiceRequest.setter(Builder::availabilityZoneRebalancing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneRebalancing").build()}).build();
    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("loadBalancers").getter(CreateServiceRequest.getter(CreateServiceRequest::loadBalancers)).setter(CreateServiceRequest.setter(Builder::loadBalancers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceRegistries").getter(CreateServiceRequest.getter(CreateServiceRequest::serviceRegistries)).setter(CreateServiceRequest.setter(Builder::serviceRegistries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceRegistry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCount").getter(CreateServiceRequest.getter(CreateServiceRequest::desiredCount)).setter(CreateServiceRequest.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateServiceRequest.getter(CreateServiceRequest::clientToken)).setter(CreateServiceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(CreateServiceRequest.getter(CreateServiceRequest::launchTypeAsString)).setter(CreateServiceRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(CreateServiceRequest.getter(CreateServiceRequest::capacityProviderStrategy)).setter(CreateServiceRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(CreateServiceRequest.getter(CreateServiceRequest::platformVersion)).setter(CreateServiceRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("role").getter(CreateServiceRequest.getter(CreateServiceRequest::role)).setter(CreateServiceRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::deploymentConfiguration)).setter(CreateServiceRequest.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementConstraints").getter(CreateServiceRequest.getter(CreateServiceRequest::placementConstraints)).setter(CreateServiceRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementStrategy").getter(CreateServiceRequest.getter(CreateServiceRequest::placementStrategy)).setter(CreateServiceRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::networkConfiguration)).setter(CreateServiceRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("healthCheckGracePeriodSeconds").getter(CreateServiceRequest.getter(CreateServiceRequest::healthCheckGracePeriodSeconds)).setter(CreateServiceRequest.setter(Builder::healthCheckGracePeriodSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds").build()}).build();
    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schedulingStrategy").getter(CreateServiceRequest.getter(CreateServiceRequest::schedulingStrategyAsString)).setter(CreateServiceRequest.setter(Builder::schedulingStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build()}).build();
    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentController").getter(CreateServiceRequest.getter(CreateServiceRequest::deploymentController)).setter(CreateServiceRequest.setter(Builder::deploymentController)).constructor(DeploymentController::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableECSManagedTags").getter(CreateServiceRequest.getter(CreateServiceRequest::enableECSManagedTags)).setter(CreateServiceRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(CreateServiceRequest.getter(CreateServiceRequest::propagateTagsAsString)).setter(CreateServiceRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableExecuteCommand").getter(CreateServiceRequest.getter(CreateServiceRequest::enableExecuteCommand)).setter(CreateServiceRequest.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build()}).build();
    private static final SdkField<ServiceConnectConfiguration> SERVICE_CONNECT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceConnectConfiguration").getter(CreateServiceRequest.getter(CreateServiceRequest::serviceConnectConfiguration)).setter(CreateServiceRequest.setter(Builder::serviceConnectConfiguration)).constructor(ServiceConnectConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectConfiguration").build()}).build();
    private static final SdkField<List<ServiceVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeConfigurations").getter(CreateServiceRequest.getter(CreateServiceRequest::volumeConfigurations)).setter(CreateServiceRequest.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcLatticeConfiguration>> VPC_LATTICE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcLatticeConfigurations").getter(CreateServiceRequest.getter(CreateServiceRequest::vpcLatticeConfigurations)).setter(CreateServiceRequest.setter(Builder::vpcLatticeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcLatticeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcLatticeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_NAME_FIELD, TASK_DEFINITION_FIELD, AVAILABILITY_ZONE_REBALANCING_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, DESIRED_COUNT_FIELD, CLIENT_TOKEN_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, ROLE_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, SERVICE_CONNECT_CONFIGURATION_FIELD, VOLUME_CONFIGURATIONS_FIELD, VPC_LATTICE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cluster", CLUSTER_FIELD);
            this.put("serviceName", SERVICE_NAME_FIELD);
            this.put("taskDefinition", TASK_DEFINITION_FIELD);
            this.put("availabilityZoneRebalancing", AVAILABILITY_ZONE_REBALANCING_FIELD);
            this.put("loadBalancers", LOAD_BALANCERS_FIELD);
            this.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
            this.put("desiredCount", DESIRED_COUNT_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("launchType", LAUNCH_TYPE_FIELD);
            this.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
            this.put("platformVersion", PLATFORM_VERSION_FIELD);
            this.put("role", ROLE_FIELD);
            this.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
            this.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
            this.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("healthCheckGracePeriodSeconds", HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD);
            this.put("schedulingStrategy", SCHEDULING_STRATEGY_FIELD);
            this.put("deploymentController", DEPLOYMENT_CONTROLLER_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
            this.put("propagateTags", PROPAGATE_TAGS_FIELD);
            this.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
            this.put("serviceConnectConfiguration", SERVICE_CONNECT_CONFIGURATION_FIELD);
            this.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
            this.put("vpcLatticeConfigurations", VPC_LATTICE_CONFIGURATIONS_FIELD);
        }
    });
    private final String cluster;
    private final String serviceName;
    private final String taskDefinition;
    private final String availabilityZoneRebalancing;
    private final List<LoadBalancer> loadBalancers;
    private final List<ServiceRegistry> serviceRegistries;
    private final Integer desiredCount;
    private final String clientToken;
    private final String launchType;
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String platformVersion;
    private final String role;
    private final DeploymentConfiguration deploymentConfiguration;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final NetworkConfiguration networkConfiguration;
    private final Integer healthCheckGracePeriodSeconds;
    private final String schedulingStrategy;
    private final DeploymentController deploymentController;
    private final List<Tag> tags;
    private final Boolean enableECSManagedTags;
    private final String propagateTags;
    private final Boolean enableExecuteCommand;
    private final ServiceConnectConfiguration serviceConnectConfiguration;
    private final List<ServiceVolumeConfiguration> volumeConfigurations;
    private final List<VpcLatticeConfiguration> vpcLatticeConfigurations;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.taskDefinition = builder.taskDefinition;
        this.availabilityZoneRebalancing = builder.availabilityZoneRebalancing;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.desiredCount = builder.desiredCount;
        this.clientToken = builder.clientToken;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.role = builder.role;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.serviceConnectConfiguration = builder.serviceConnectConfiguration;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.vpcLatticeConfigurations = builder.vpcLatticeConfigurations;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final AvailabilityZoneRebalancing availabilityZoneRebalancing() {
        return AvailabilityZoneRebalancing.fromValue(this.availabilityZoneRebalancing);
    }

    public final String availabilityZoneRebalancingAsString() {
        return this.availabilityZoneRebalancing;
    }

    public final boolean hasLoadBalancers() {
        return this.loadBalancers != null && !(this.loadBalancers instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancer> loadBalancers() {
        return this.loadBalancers;
    }

    public final boolean hasServiceRegistries() {
        return this.serviceRegistries != null && !(this.serviceRegistries instanceof SdkAutoConstructList);
    }

    public final List<ServiceRegistry> serviceRegistries() {
        return this.serviceRegistries;
    }

    public final Integer desiredCount() {
        return this.desiredCount;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String role() {
        return this.role;
    }

    public final DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public final boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public final List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final Integer healthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    public final SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(this.schedulingStrategy);
    }

    public final String schedulingStrategyAsString() {
        return this.schedulingStrategy;
    }

    public final DeploymentController deploymentController() {
        return this.deploymentController;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public final ServiceConnectConfiguration serviceConnectConfiguration() {
        return this.serviceConnectConfiguration;
    }

    public final boolean hasVolumeConfigurations() {
        return this.volumeConfigurations != null && !(this.volumeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ServiceVolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public final boolean hasVpcLatticeConfigurations() {
        return this.vpcLatticeConfigurations != null && !(this.vpcLatticeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<VpcLatticeConfiguration> vpcLatticeConfigurations() {
        return this.vpcLatticeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneRebalancingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancers() ? this.loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceRegistries() ? this.serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementStrategy() ? this.placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceConnectConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeConfigurations() ? this.volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcLatticeConfigurations() ? this.vpcLatticeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.availabilityZoneRebalancingAsString(), other.availabilityZoneRebalancingAsString()) && this.hasLoadBalancers() == other.hasLoadBalancers() && Objects.equals(this.loadBalancers(), other.loadBalancers()) && this.hasServiceRegistries() == other.hasServiceRegistries() && Objects.equals(this.serviceRegistries(), other.serviceRegistries()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && this.hasPlacementStrategy() == other.hasPlacementStrategy() && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds()) && Objects.equals(this.schedulingStrategyAsString(), other.schedulingStrategyAsString()) && Objects.equals(this.deploymentController(), other.deploymentController()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand()) && Objects.equals(this.serviceConnectConfiguration(), other.serviceConnectConfiguration()) && this.hasVolumeConfigurations() == other.hasVolumeConfigurations() && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations()) && this.hasVpcLatticeConfigurations() == other.hasVpcLatticeConfigurations() && Objects.equals(this.vpcLatticeConfigurations(), other.vpcLatticeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("Cluster", (Object)this.cluster()).add("ServiceName", (Object)this.serviceName()).add("TaskDefinition", (Object)this.taskDefinition()).add("AvailabilityZoneRebalancing", (Object)this.availabilityZoneRebalancingAsString()).add("LoadBalancers", this.hasLoadBalancers() ? this.loadBalancers() : null).add("ServiceRegistries", this.hasServiceRegistries() ? this.serviceRegistries() : null).add("DesiredCount", (Object)this.desiredCount()).add("ClientToken", (Object)this.clientToken()).add("LaunchType", (Object)this.launchTypeAsString()).add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("PlatformVersion", (Object)this.platformVersion()).add("Role", (Object)this.role()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("PlacementStrategy", this.hasPlacementStrategy() ? this.placementStrategy() : null).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("HealthCheckGracePeriodSeconds", (Object)this.healthCheckGracePeriodSeconds()).add("SchedulingStrategy", (Object)this.schedulingStrategyAsString()).add("DeploymentController", (Object)this.deploymentController()).add("Tags", this.hasTags() ? this.tags() : null).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("PropagateTags", (Object)this.propagateTagsAsString()).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).add("ServiceConnectConfiguration", (Object)this.serviceConnectConfiguration()).add("VolumeConfigurations", this.hasVolumeConfigurations() ? this.volumeConfigurations() : null).add("VpcLatticeConfigurations", this.hasVpcLatticeConfigurations() ? this.vpcLatticeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "availabilityZoneRebalancing": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneRebalancingAsString()));
            }
            case "loadBalancers": {
                return Optional.ofNullable(clazz.cast(this.loadBalancers()));
            }
            case "serviceRegistries": {
                return Optional.ofNullable(clazz.cast(this.serviceRegistries()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "healthCheckGracePeriodSeconds": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriodSeconds()));
            }
            case "schedulingStrategy": {
                return Optional.ofNullable(clazz.cast(this.schedulingStrategyAsString()));
            }
            case "deploymentController": {
                return Optional.ofNullable(clazz.cast(this.deploymentController()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
            case "enableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
            case "serviceConnectConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serviceConnectConfiguration()));
            }
            case "volumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
            case "vpcLatticeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.vpcLatticeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String serviceName;
        private String taskDefinition;
        private String availabilityZoneRebalancing;
        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();
        private Integer desiredCount;
        private String clientToken;
        private String launchType;
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private String role;
        private DeploymentConfiguration deploymentConfiguration;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private NetworkConfiguration networkConfiguration;
        private Integer healthCheckGracePeriodSeconds;
        private String schedulingStrategy;
        private DeploymentController deploymentController;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableECSManagedTags;
        private String propagateTags;
        private Boolean enableExecuteCommand;
        private ServiceConnectConfiguration serviceConnectConfiguration;
        private List<ServiceVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<VpcLatticeConfiguration> vpcLatticeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.serviceName(model.serviceName);
            this.taskDefinition(model.taskDefinition);
            this.availabilityZoneRebalancing(model.availabilityZoneRebalancing);
            this.loadBalancers(model.loadBalancers);
            this.serviceRegistries(model.serviceRegistries);
            this.desiredCount(model.desiredCount);
            this.clientToken(model.clientToken);
            this.launchType(model.launchType);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.platformVersion(model.platformVersion);
            this.role(model.role);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.networkConfiguration(model.networkConfiguration);
            this.healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            this.schedulingStrategy(model.schedulingStrategy);
            this.deploymentController(model.deploymentController);
            this.tags(model.tags);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.propagateTags(model.propagateTags);
            this.enableExecuteCommand(model.enableExecuteCommand);
            this.serviceConnectConfiguration(model.serviceConnectConfiguration);
            this.volumeConfigurations(model.volumeConfigurations);
            this.vpcLatticeConfigurations(model.vpcLatticeConfigurations);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final String getAvailabilityZoneRebalancing() {
            return this.availabilityZoneRebalancing;
        }

        public final void setAvailabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
        }

        @Override
        public final Builder availabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
            return this;
        }

        @Override
        public final Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing(availabilityZoneRebalancing == null ? null : availabilityZoneRebalancing.toString());
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder> ... loadBalancers) {
            this.loadBalancers(Stream.of(loadBalancers).map(c -> (LoadBalancer)((LoadBalancer.Builder)LoadBalancer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry ... serviceRegistries) {
            this.serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... serviceRegistries) {
            this.serviceRegistries(Stream.of(serviceRegistries).map(c -> (ServiceRegistry)((ServiceRegistry.Builder)ServiceRegistry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getDesiredCount() {
            return this.desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return this.healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final String getSchedulingStrategy() {
            return this.schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return this.deploymentController != null ? this.deploymentController.toBuilder() : null;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final ServiceConnectConfiguration.Builder getServiceConnectConfiguration() {
            return this.serviceConnectConfiguration != null ? this.serviceConnectConfiguration.toBuilder() : null;
        }

        public final void setServiceConnectConfiguration(ServiceConnectConfiguration.BuilderImpl serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration != null ? serviceConnectConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConnectConfiguration(ServiceConnectConfiguration serviceConnectConfiguration) {
            this.serviceConnectConfiguration = serviceConnectConfiguration;
            return this;
        }

        public final List<ServiceVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<ServiceVolumeConfiguration.Builder> result = ServiceVolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<ServiceVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = ServiceVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(ServiceVolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (ServiceVolumeConfiguration)((ServiceVolumeConfiguration.Builder)ServiceVolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcLatticeConfiguration.Builder> getVpcLatticeConfigurations() {
            List<VpcLatticeConfiguration.Builder> result = VpcLatticeConfigurationsCopier.copyToBuilder(this.vpcLatticeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcLatticeConfigurations(Collection<VpcLatticeConfiguration.BuilderImpl> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copyFromBuilder(vpcLatticeConfigurations);
        }

        @Override
        public final Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations = VpcLatticeConfigurationsCopier.copy(vpcLatticeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(VpcLatticeConfiguration ... vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations(Arrays.asList(vpcLatticeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder> ... vpcLatticeConfigurations) {
            this.vpcLatticeConfigurations(Stream.of(vpcLatticeConfigurations).map(c -> (VpcLatticeConfiguration)((VpcLatticeConfiguration.Builder)VpcLatticeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder cluster(String var1);

        public Builder serviceName(String var1);

        public Builder taskDefinition(String var1);

        public Builder availabilityZoneRebalancing(String var1);

        public Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing var1);

        public Builder loadBalancers(Collection<LoadBalancer> var1);

        public Builder loadBalancers(LoadBalancer ... var1);

        public Builder loadBalancers(Consumer<LoadBalancer.Builder> ... var1);

        public Builder serviceRegistries(Collection<ServiceRegistry> var1);

        public Builder serviceRegistries(ServiceRegistry ... var1);

        public Builder serviceRegistries(Consumer<ServiceRegistry.Builder> ... var1);

        public Builder desiredCount(Integer var1);

        public Builder clientToken(String var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder role(String var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder healthCheckGracePeriodSeconds(Integer var1);

        public Builder schedulingStrategy(String var1);

        public Builder schedulingStrategy(SchedulingStrategy var1);

        public Builder deploymentController(DeploymentController var1);

        default public Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return this.deploymentController((DeploymentController)((DeploymentController.Builder)DeploymentController.builder().applyMutation(deploymentController)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder enableExecuteCommand(Boolean var1);

        public Builder serviceConnectConfiguration(ServiceConnectConfiguration var1);

        default public Builder serviceConnectConfiguration(Consumer<ServiceConnectConfiguration.Builder> serviceConnectConfiguration) {
            return this.serviceConnectConfiguration((ServiceConnectConfiguration)((ServiceConnectConfiguration.Builder)ServiceConnectConfiguration.builder().applyMutation(serviceConnectConfiguration)).build());
        }

        public Builder volumeConfigurations(Collection<ServiceVolumeConfiguration> var1);

        public Builder volumeConfigurations(ServiceVolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<ServiceVolumeConfiguration.Builder> ... var1);

        public Builder vpcLatticeConfigurations(Collection<VpcLatticeConfiguration> var1);

        public Builder vpcLatticeConfigurations(VpcLatticeConfiguration ... var1);

        public Builder vpcLatticeConfigurations(Consumer<VpcLatticeConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

