/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTaskProtectionRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, UpdateTaskProtectionRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdateTaskProtectionRequest.getter(UpdateTaskProtectionRequest::cluster)).setter(UpdateTaskProtectionRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<String>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tasks").getter(UpdateTaskProtectionRequest.getter(UpdateTaskProtectionRequest::tasks)).setter(UpdateTaskProtectionRequest.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("protectionEnabled").getter(UpdateTaskProtectionRequest.getter(UpdateTaskProtectionRequest::protectionEnabled)).setter(UpdateTaskProtectionRequest.setter(Builder::protectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protectionEnabled").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("expiresInMinutes").getter(UpdateTaskProtectionRequest.getter(UpdateTaskProtectionRequest::expiresInMinutes)).setter(UpdateTaskProtectionRequest.setter(Builder::expiresInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASKS_FIELD, PROTECTION_ENABLED_FIELD, EXPIRES_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cluster", CLUSTER_FIELD);
            this.put("tasks", TASKS_FIELD);
            this.put("protectionEnabled", PROTECTION_ENABLED_FIELD);
            this.put("expiresInMinutes", EXPIRES_IN_MINUTES_FIELD);
        }
    });
    private final String cluster;
    private final List<String> tasks;
    private final Boolean protectionEnabled;
    private final Integer expiresInMinutes;

    private UpdateTaskProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.tasks = builder.tasks;
        this.protectionEnabled = builder.protectionEnabled;
        this.expiresInMinutes = builder.expiresInMinutes;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<String> tasks() {
        return this.tasks;
    }

    public final Boolean protectionEnabled() {
        return this.protectionEnabled;
    }

    public final Integer expiresInMinutes() {
        return this.expiresInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskProtectionRequest)) {
            return false;
        }
        UpdateTaskProtectionRequest other = (UpdateTaskProtectionRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.protectionEnabled(), other.protectionEnabled()) && Objects.equals(this.expiresInMinutes(), other.expiresInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTaskProtectionRequest").add("Cluster", (Object)this.cluster()).add("Tasks", this.hasTasks() ? this.tasks() : null).add("ProtectionEnabled", (Object)this.protectionEnabled()).add("ExpiresInMinutes", (Object)this.expiresInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "protectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.protectionEnabled()));
            }
            case "expiresInMinutes": {
                return Optional.ofNullable(clazz.cast(this.expiresInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskProtectionRequest, T> g) {
        return obj -> g.apply((UpdateTaskProtectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private List<String> tasks = DefaultSdkAutoConstructList.getInstance();
        private Boolean protectionEnabled;
        private Integer expiresInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskProtectionRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.tasks(model.tasks);
            this.protectionEnabled(model.protectionEnabled);
            this.expiresInMinutes(model.expiresInMinutes);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final Collection<String> getTasks() {
            if (this.tasks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tasks;
        }

        public final void setTasks(Collection<String> tasks) {
            this.tasks = StringListCopier.copy(tasks);
        }

        @Override
        public final Builder tasks(Collection<String> tasks) {
            this.tasks = StringListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(String ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        public final Boolean getProtectionEnabled() {
            return this.protectionEnabled;
        }

        public final void setProtectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
        }

        @Override
        public final Builder protectionEnabled(Boolean protectionEnabled) {
            this.protectionEnabled = protectionEnabled;
            return this;
        }

        public final Integer getExpiresInMinutes() {
            return this.expiresInMinutes;
        }

        public final void setExpiresInMinutes(Integer expiresInMinutes) {
            this.expiresInMinutes = expiresInMinutes;
        }

        @Override
        public final Builder expiresInMinutes(Integer expiresInMinutes) {
            this.expiresInMinutes = expiresInMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskProtectionRequest build() {
            return new UpdateTaskProtectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTaskProtectionRequest> {
        public Builder cluster(String var1);

        public Builder tasks(Collection<String> var1);

        public Builder tasks(String ... var1);

        public Builder protectionEnabled(Boolean var1);

        public Builder expiresInMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

