/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends EcsRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField
            .<List<ClusterSetting>> builder(MarshallingType.LIST)
            .memberName("settings")
            .getter(getter(CreateClusterRequest::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClusterConfiguration> CONFIGURATION_FIELD = SdkField
            .<ClusterConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateClusterRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(ClusterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capacityProviders")
            .getter(getter(CreateClusterRequest::capacityProviders))
            .setter(setter(Builder::capacityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("defaultCapacityProviderStrategy")
            .getter(getter(CreateClusterRequest::defaultCapacityProviderStrategy))
            .setter(setter(Builder::defaultCapacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCapacityProviderStrategy")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClusterServiceConnectDefaultsRequest> SERVICE_CONNECT_DEFAULTS_FIELD = SdkField
            .<ClusterServiceConnectDefaultsRequest> builder(MarshallingType.SDK_POJO).memberName("serviceConnectDefaults")
            .getter(getter(CreateClusterRequest::serviceConnectDefaults)).setter(setter(Builder::serviceConnectDefaults))
            .constructor(ClusterServiceConnectDefaultsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConnectDefaults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            TAGS_FIELD, SETTINGS_FIELD, CONFIGURATION_FIELD, CAPACITY_PROVIDERS_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD,
            SERVICE_CONNECT_DEFAULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("clusterName", CLUSTER_NAME_FIELD);
                    put("tags", TAGS_FIELD);
                    put("settings", SETTINGS_FIELD);
                    put("configuration", CONFIGURATION_FIELD);
                    put("capacityProviders", CAPACITY_PROVIDERS_FIELD);
                    put("defaultCapacityProviderStrategy", DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD);
                    put("serviceConnectDefaults", SERVICE_CONNECT_DEFAULTS_FIELD);
                }
            });

    private final String clusterName;

    private final List<Tag> tags;

    private final List<ClusterSetting> settings;

    private final ClusterConfiguration configuration;

    private final List<String> capacityProviders;

    private final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;

    private final ClusterServiceConnectDefaultsRequest serviceConnectDefaults;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.tags = builder.tags;
        this.settings = builder.settings;
        this.configuration = builder.configuration;
        this.capacityProviders = builder.capacityProviders;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
        this.serviceConnectDefaults = builder.serviceConnectDefaults;
    }

    /**
     * <p>
     * The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named
     * <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
     * </p>
     * 
     * @return The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named
     *         <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
     *         allowed.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key
     * and an optional value. You define both.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of
     *         a key and an optional value. You define both.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights for a
     * cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
     * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
     * PutAccountSettingDefault</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container
     *         Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value
     *         set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">
     *         PutAccountSetting</a> or <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
     *         >PutAccountSettingDefault</a>.
     */
    public final List<ClusterSetting> settings() {
        return settings;
    }

    /**
     * <p>
     * The <code>execute</code> command configuration for the cluster.
     * </p>
     * 
     * @return The <code>execute</code> command configuration for the cluster.
     */
    public final ClusterConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityProviders() {
        return capacityProviders != null && !(capacityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The short name of one or more capacity providers to associate with the cluster. A capacity provider must be
     * associated with a cluster before it can be included as part of the default capacity provider strategy of the
     * cluster or used in a capacity provider strategy when calling the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
     * </p>
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not
     * associated with another cluster. New Auto Scaling group capacity providers can be created with the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html"
     * >CreateCapacityProvider</a> API operation.
     * </p>
     * <p>
     * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity
     * providers. The Fargate capacity providers are available to all accounts and only need to be associated with a
     * cluster to be used.
     * </p>
     * <p>
     * The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
     * PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a cluster
     * after the cluster is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviders} method.
     * </p>
     * 
     * @return The short name of one or more capacity providers to associate with the cluster. A capacity provider must
     *         be associated with a cluster before it can be included as part of the default capacity provider strategy
     *         of the cluster or used in a capacity provider strategy when calling the <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a>
     *         or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a>
     *         actions.</p>
     *         <p>
     *         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created
     *         but not associated with another cluster. New Auto Scaling group capacity providers can be created with
     *         the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">
     *         CreateCapacityProvider</a> API operation.
     *         </p>
     *         <p>
     *         To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
     *         capacity providers. The Fargate capacity providers are available to all accounts and only need to be
     *         associated with a cluster to be used.
     *         </p>
     *         <p>
     *         The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
     *         PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a
     *         cluster after the cluster is created.
     */
    public final List<String> capacityProviders() {
        return capacityProviders;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultCapacityProviderStrategy
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDefaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy != null && !(defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy to set as the default for the cluster. After a default capacity provider strategy
     * is set for a cluster, when you call the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs with no
     * capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster is
     * used.
     * </p>
     * <p>
     * If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined later
     * with the <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html">
     * PutClusterCapacityProviders</a> API operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultCapacityProviderStrategy}
     * method.
     * </p>
     * 
     * @return The capacity provider strategy to set as the default for the cluster. After a default capacity provider
     *         strategy is set for a cluster, when you call the <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a>
     *         or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs
     *         with no capacity provider strategy or launch type specified, the default capacity provider strategy for
     *         the cluster is used.</p>
     *         <p>
     *         If a default capacity provider strategy isn't defined for a cluster when it was created, it can be
     *         defined later with the <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
     *         >PutClusterCapacityProviders</a> API operation.
     */
    public final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy() {
        return defaultCapacityProviderStrategy;
    }

    /**
     * <p>
     * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace,
     * any new services with Service Connect turned on that are created in the cluster are added as client services in
     * the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to
     * <code>true</code> in the <code>ServiceConnectConfiguration</code>. You can set the namespace of each service
     * individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
     * </p>
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
     * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
     * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported
     * with Service Connect. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Use this parameter to set a default Service Connect namespace. After you set a default Service Connect
     *         namespace, any new services with Service Connect turned on that are created in the cluster are added as
     *         client services in the namespace. This setting only applies to new services that set the
     *         <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code>. You
     *         can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to
     *         override this default parameter.</p>
     *         <p>
     *         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
     *         connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
     *         container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
     *         services create are supported with Service Connect. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final ClusterServiceConnectDefaultsRequest serviceConnectDefaults() {
        return serviceConnectDefaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviders() ? capacityProviders() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceConnectDefaults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasSettings() == other.hasSettings()
                && Objects.equals(settings(), other.settings()) && Objects.equals(configuration(), other.configuration())
                && hasCapacityProviders() == other.hasCapacityProviders()
                && Objects.equals(capacityProviders(), other.capacityProviders())
                && hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy()
                && Objects.equals(defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy())
                && Objects.equals(serviceConnectDefaults(), other.serviceConnectDefaults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateClusterRequest")
                .add("ClusterName", clusterName())
                .add("Tags", hasTags() ? tags() : null)
                .add("Settings", hasSettings() ? settings() : null)
                .add("Configuration", configuration())
                .add("CapacityProviders", hasCapacityProviders() ? capacityProviders() : null)
                .add("DefaultCapacityProviderStrategy",
                        hasDefaultCapacityProviderStrategy() ? defaultCapacityProviderStrategy() : null)
                .add("ServiceConnectDefaults", serviceConnectDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "capacityProviders":
            return Optional.ofNullable(clazz.cast(capacityProviders()));
        case "defaultCapacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(defaultCapacityProviderStrategy()));
        case "serviceConnectDefaults":
            return Optional.ofNullable(clazz.cast(serviceConnectDefaults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's named
         * <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
         * allowed.
         * </p>
         * 
         * @param clusterName
         *        The name of your cluster. If you don't specify a name for your cluster, you create a cluster that's
         *        named <code>default</code>. Up to 255 letters (uppercase and lowercase), numbers, underscores, and
         *        hyphens are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists
         *        of a key and an optional value. You define both.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists
         *        of a key and an optional value. You define both.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define both.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * 
         * @param settings
         *        The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container
         *        Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code>
         *        value set with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html"
         *        >PutAccountSetting</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
         *        >PutAccountSettingDefault</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Collection<ClusterSetting> settings);

        /**
         * <p>
         * The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * 
         * @param settings
         *        The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container
         *        Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code>
         *        value set with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html"
         *        >PutAccountSetting</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
         *        >PutAccountSettingDefault</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(ClusterSetting... settings);

        /**
         * <p>
         * The setting to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ClusterSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(List<ClusterSetting>)}.
         * 
         * @param settings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(java.util.Collection<ClusterSetting>)
         */
        Builder settings(Consumer<ClusterSetting.Builder>... settings);

        /**
         * <p>
         * The <code>execute</code> command configuration for the cluster.
         * </p>
         * 
         * @param configuration
         *        The <code>execute</code> command configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ClusterConfiguration configuration);

        /**
         * <p>
         * The <code>execute</code> command configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterConfiguration.Builder} avoiding
         * the need to create one manually via {@link ClusterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(ClusterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ClusterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ClusterConfiguration)
         */
        default Builder configuration(Consumer<ClusterConfiguration.Builder> configuration) {
            return configuration(ClusterConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The short name of one or more capacity providers to associate with the cluster. A capacity provider must be
         * associated with a cluster before it can be included as part of the default capacity provider strategy of the
         * cluster or used in a capacity provider strategy when calling the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but
         * not associated with another cluster. New Auto Scaling group capacity providers can be created with the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">
         * CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
         * PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a
         * cluster after the cluster is created.
         * </p>
         * 
         * @param capacityProviders
         *        The short name of one or more capacity providers to associate with the cluster. A capacity provider
         *        must be associated with a cluster before it can be included as part of the default capacity provider
         *        strategy of the cluster or used in a capacity provider strategy when calling the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a>
         *        actions.</p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be
         *        created but not associated with another cluster. New Auto Scaling group capacity providers can be
         *        created with the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html"
         *        >CreateCapacityProvider</a> API operation.
         *        </p>
         *        <p>
         *        To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
         *        PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a
         *        cluster after the cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(Collection<String> capacityProviders);

        /**
         * <p>
         * The short name of one or more capacity providers to associate with the cluster. A capacity provider must be
         * associated with a cluster before it can be included as part of the default capacity provider strategy of the
         * cluster or used in a capacity provider strategy when calling the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
         * </p>
         * <p>
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but
         * not associated with another cluster. New Auto Scaling group capacity providers can be created with the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">
         * CreateCapacityProvider</a> API operation.
         * </p>
         * <p>
         * To use a Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code>
         * capacity providers. The Fargate capacity providers are available to all accounts and only need to be
         * associated with a cluster to be used.
         * </p>
         * <p>
         * The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
         * PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a
         * cluster after the cluster is created.
         * </p>
         * 
         * @param capacityProviders
         *        The short name of one or more capacity providers to associate with the cluster. A capacity provider
         *        must be associated with a cluster before it can be included as part of the default capacity provider
         *        strategy of the cluster or used in a capacity provider strategy when calling the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a>
         *        actions.</p>
         *        <p>
         *        If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be
         *        created but not associated with another cluster. New Auto Scaling group capacity providers can be
         *        created with the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html"
         *        >CreateCapacityProvider</a> API operation.
         *        </p>
         *        <p>
         *        To use a Fargate capacity provider, specify either the <code>FARGATE</code> or
         *        <code>FARGATE_SPOT</code> capacity providers. The Fargate capacity providers are available to all
         *        accounts and only need to be associated with a cluster to be used.
         *        </p>
         *        <p>
         *        The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">
         *        PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a
         *        cluster after the cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(String... capacityProviders);

        /**
         * <p>
         * The capacity provider strategy to set as the default for the cluster. After a default capacity provider
         * strategy is set for a cluster, when you call the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs with no
         * capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster
         * is used.
         * </p>
         * <p>
         * If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined
         * later with the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
         * >PutClusterCapacityProviders</a> API operation.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The capacity provider strategy to set as the default for the cluster. After a default capacity
         *        provider strategy is set for a cluster, when you call the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs
         *        with no capacity provider strategy or launch type specified, the default capacity provider strategy
         *        for the cluster is used.</p>
         *        <p>
         *        If a default capacity provider strategy isn't defined for a cluster when it was created, it can be
         *        defined later with the <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
         *        >PutClusterCapacityProviders</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to set as the default for the cluster. After a default capacity provider
         * strategy is set for a cluster, when you call the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs with no
         * capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster
         * is used.
         * </p>
         * <p>
         * If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined
         * later with the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
         * >PutClusterCapacityProviders</a> API operation.
         * </p>
         * 
         * @param defaultCapacityProviderStrategy
         *        The capacity provider strategy to set as the default for the cluster. After a default capacity
         *        provider strategy is set for a cluster, when you call the <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs
         *        with no capacity provider strategy or launch type specified, the default capacity provider strategy
         *        for the cluster is used.</p>
         *        <p>
         *        If a default capacity provider strategy isn't defined for a cluster when it was created, it can be
         *        defined later with the <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
         *        >PutClusterCapacityProviders</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem... defaultCapacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy to set as the default for the cluster. After a default capacity provider
         * strategy is set for a cluster, when you call the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> APIs with no
         * capacity provider strategy or launch type specified, the default capacity provider strategy for the cluster
         * is used.
         * </p>
         * <p>
         * If a default capacity provider strategy isn't defined for a cluster when it was created, it can be defined
         * later with the <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutClusterCapacityProviders.html"
         * >PutClusterCapacityProviders</a> API operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #defaultCapacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param defaultCapacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCapacityProviderStrategy(java.util.Collection<CapacityProviderStrategyItem>)
         */
        Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... defaultCapacityProviderStrategy);

        /**
         * <p>
         * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect
         * namespace, any new services with Service Connect turned on that are created in the cluster are added as
         * client services in the namespace. This setting only applies to new services that set the <code>enabled</code>
         * parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code>. You can set the namespace of
         * each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param serviceConnectDefaults
         *        Use this parameter to set a default Service Connect namespace. After you set a default Service Connect
         *        namespace, any new services with Service Connect turned on that are created in the cluster are added
         *        as client services in the namespace. This setting only applies to new services that set the
         *        <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code>.
         *        You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code>
         *        to override this default parameter.</p>
         *        <p>
         *        Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can
         *        connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy
         *        container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS
         *        services create are supported with Service Connect. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConnectDefaults(ClusterServiceConnectDefaultsRequest serviceConnectDefaults);

        /**
         * <p>
         * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect
         * namespace, any new services with Service Connect turned on that are created in the cluster are added as
         * client services in the namespace. This setting only applies to new services that set the <code>enabled</code>
         * parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code>. You can set the namespace of
         * each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         * </p>
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect
         * to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that
         * collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are
         * supported with Service Connect. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ClusterServiceConnectDefaultsRequest.Builder} avoiding the need to create one manually via
         * {@link ClusterServiceConnectDefaultsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterServiceConnectDefaultsRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConnectDefaults(ClusterServiceConnectDefaultsRequest)}.
         * 
         * @param serviceConnectDefaults
         *        a consumer that will call methods on {@link ClusterServiceConnectDefaultsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConnectDefaults(ClusterServiceConnectDefaultsRequest)
         */
        default Builder serviceConnectDefaults(Consumer<ClusterServiceConnectDefaultsRequest.Builder> serviceConnectDefaults) {
            return serviceConnectDefaults(ClusterServiceConnectDefaultsRequest.builder().applyMutation(serviceConnectDefaults)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();

        private ClusterConfiguration configuration;

        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();

        private List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private ClusterServiceConnectDefaultsRequest serviceConnectDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            tags(model.tags);
            settings(model.settings);
            configuration(model.configuration);
            capacityProviders(model.capacityProviders);
            defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
            serviceConnectDefaults(model.serviceConnectDefaults);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterSetting.Builder> getSettings() {
            List<ClusterSetting.Builder> result = ClusterSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(ClusterSetting... settings) {
            settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder>... settings) {
            settings(Stream.of(settings).map(c -> ClusterSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ClusterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ClusterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Collection<String> getCapacityProviders() {
            if (capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String... capacityProviders) {
            capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getDefaultCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier
                    .copyToBuilder(this.defaultCapacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier
                    .copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        public final Builder defaultCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(
                Consumer<CapacityProviderStrategyItem.Builder>... defaultCapacityProviderStrategy) {
            defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterServiceConnectDefaultsRequest.Builder getServiceConnectDefaults() {
            return serviceConnectDefaults != null ? serviceConnectDefaults.toBuilder() : null;
        }

        public final void setServiceConnectDefaults(ClusterServiceConnectDefaultsRequest.BuilderImpl serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults != null ? serviceConnectDefaults.build() : null;
        }

        @Override
        public final Builder serviceConnectDefaults(ClusterServiceConnectDefaultsRequest serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
