/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTaskDefinitionsResponse extends EcsResponse implements
        ToCopyableBuilder<DeleteTaskDefinitionsResponse.Builder, DeleteTaskDefinitionsResponse> {
    private static final SdkField<List<TaskDefinition>> TASK_DEFINITIONS_FIELD = SdkField
            .<List<TaskDefinition>> builder(MarshallingType.LIST)
            .memberName("taskDefinitions")
            .getter(getter(DeleteTaskDefinitionsResponse::taskDefinitions))
            .setter(setter(Builder::taskDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField
            .<List<Failure>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(DeleteTaskDefinitionsResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Failure> builder(MarshallingType.SDK_POJO)
                                            .constructor(Failure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITIONS_FIELD,
            FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("taskDefinitions", TASK_DEFINITIONS_FIELD);
                    put("failures", FAILURES_FIELD);
                }
            });

    private final List<TaskDefinition> taskDefinitions;

    private final List<Failure> failures;

    private DeleteTaskDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.taskDefinitions = builder.taskDefinitions;
        this.failures = builder.failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskDefinitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskDefinitions() {
        return taskDefinitions != null && !(taskDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of deleted task definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskDefinitions} method.
     * </p>
     * 
     * @return The list of deleted task definitions.
     */
    public final List<TaskDefinition> taskDefinitions() {
        return taskDefinitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any failures associated with the call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return Any failures associated with the call.
     */
    public final List<Failure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskDefinitions() ? taskDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTaskDefinitionsResponse)) {
            return false;
        }
        DeleteTaskDefinitionsResponse other = (DeleteTaskDefinitionsResponse) obj;
        return hasTaskDefinitions() == other.hasTaskDefinitions() && Objects.equals(taskDefinitions(), other.taskDefinitions())
                && hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTaskDefinitionsResponse")
                .add("TaskDefinitions", hasTaskDefinitions() ? taskDefinitions() : null)
                .add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskDefinitions":
            return Optional.ofNullable(clazz.cast(taskDefinitions()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteTaskDefinitionsResponse, T> g) {
        return obj -> g.apply((DeleteTaskDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTaskDefinitionsResponse> {
        /**
         * <p>
         * The list of deleted task definitions.
         * </p>
         * 
         * @param taskDefinitions
         *        The list of deleted task definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitions(Collection<TaskDefinition> taskDefinitions);

        /**
         * <p>
         * The list of deleted task definitions.
         * </p>
         * 
         * @param taskDefinitions
         *        The list of deleted task definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitions(TaskDefinition... taskDefinitions);

        /**
         * <p>
         * The list of deleted task definitions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.TaskDefinition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.TaskDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.TaskDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #taskDefinitions(List<TaskDefinition>)}.
         * 
         * @param taskDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.TaskDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskDefinitions(java.util.Collection<TaskDefinition>)
         */
        Builder taskDefinitions(Consumer<TaskDefinition.Builder>... taskDefinitions);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<Failure> failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * 
         * @param failures
         *        Any failures associated with the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Failure... failures);

        /**
         * <p>
         * Any failures associated with the call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Failure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Failure.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<Failure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Failure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<Failure>)
         */
        Builder failures(Consumer<Failure.Builder>... failures);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<TaskDefinition> taskDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTaskDefinitionsResponse model) {
            super(model);
            taskDefinitions(model.taskDefinitions);
            failures(model.failures);
        }

        public final List<TaskDefinition.Builder> getTaskDefinitions() {
            List<TaskDefinition.Builder> result = TaskDefinitionListCopier.copyToBuilder(this.taskDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskDefinitions(Collection<TaskDefinition.BuilderImpl> taskDefinitions) {
            this.taskDefinitions = TaskDefinitionListCopier.copyFromBuilder(taskDefinitions);
        }

        @Override
        public final Builder taskDefinitions(Collection<TaskDefinition> taskDefinitions) {
            this.taskDefinitions = TaskDefinitionListCopier.copy(taskDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(TaskDefinition... taskDefinitions) {
            taskDefinitions(Arrays.asList(taskDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(Consumer<TaskDefinition.Builder>... taskDefinitions) {
            taskDefinitions(Stream.of(taskDefinitions).map(c -> TaskDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> Failure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteTaskDefinitionsResponse build() {
            return new DeleteTaskDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
