/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
 * Currently, the only supported volume type is an Amazon EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceVolumeConfiguration.Builder, ServiceVolumeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceVolumeConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ServiceManagedEBSVolumeConfiguration> MANAGED_EBS_VOLUME_FIELD = SdkField
            .<ServiceManagedEBSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("managedEBSVolume")
            .getter(getter(ServiceVolumeConfiguration::managedEBSVolume)).setter(setter(Builder::managedEBSVolume))
            .constructor(ServiceManagedEBSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEBSVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MANAGED_EBS_VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("managedEBSVolume", MANAGED_EBS_VOLUME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ServiceManagedEBSVolumeConfiguration managedEBSVolume;

    private ServiceVolumeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.managedEBSVolume = builder.managedEBSVolume;
    }

    /**
     * <p>
     * The name of the volume. This value must match the volume name from the <code>Volume</code> object in the task
     * definition.
     * </p>
     * 
     * @return The name of the volume. This value must match the volume name from the <code>Volume</code> object in the
     *         task definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings
     * are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS
     * volumes are visible in your account in the Amazon EC2 console once they are created.
     * </p>
     * 
     * @return The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
     *         settings are used to create each Amazon EBS volume, with one volume created for each task in the service.
     *         The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
     */
    public final ServiceManagedEBSVolumeConfiguration managedEBSVolume() {
        return managedEBSVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(managedEBSVolume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceVolumeConfiguration)) {
            return false;
        }
        ServiceVolumeConfiguration other = (ServiceVolumeConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(managedEBSVolume(), other.managedEBSVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceVolumeConfiguration").add("Name", name()).add("ManagedEBSVolume", managedEBSVolume())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "managedEBSVolume":
            return Optional.ofNullable(clazz.cast(managedEBSVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceVolumeConfiguration, T> g) {
        return obj -> g.apply((ServiceVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceVolumeConfiguration> {
        /**
         * <p>
         * The name of the volume. This value must match the volume name from the <code>Volume</code> object in the task
         * definition.
         * </p>
         * 
         * @param name
         *        The name of the volume. This value must match the volume name from the <code>Volume</code> object in
         *        the task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         * settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The
         * Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
         * </p>
         * 
         * @param managedEBSVolume
         *        The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         *        settings are used to create each Amazon EBS volume, with one volume created for each task in the
         *        service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEBSVolume(ServiceManagedEBSVolumeConfiguration managedEBSVolume);

        /**
         * <p>
         * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         * settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The
         * Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceManagedEBSVolumeConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServiceManagedEBSVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedEBSVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #managedEBSVolume(ServiceManagedEBSVolumeConfiguration)}.
         * 
         * @param managedEBSVolume
         *        a consumer that will call methods on {@link ServiceManagedEBSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedEBSVolume(ServiceManagedEBSVolumeConfiguration)
         */
        default Builder managedEBSVolume(Consumer<ServiceManagedEBSVolumeConfiguration.Builder> managedEBSVolume) {
            return managedEBSVolume(ServiceManagedEBSVolumeConfiguration.builder().applyMutation(managedEBSVolume).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ServiceManagedEBSVolumeConfiguration managedEBSVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceVolumeConfiguration model) {
            name(model.name);
            managedEBSVolume(model.managedEBSVolume);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServiceManagedEBSVolumeConfiguration.Builder getManagedEBSVolume() {
            return managedEBSVolume != null ? managedEBSVolume.toBuilder() : null;
        }

        public final void setManagedEBSVolume(ServiceManagedEBSVolumeConfiguration.BuilderImpl managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume != null ? managedEBSVolume.build() : null;
        }

        @Override
        public final Builder managedEBSVolume(ServiceManagedEBSVolumeConfiguration managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume;
            return this;
        }

        @Override
        public ServiceVolumeConfiguration build() {
            return new ServiceVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
