/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceConnectClientAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceConnectClientAlias> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(ServiceConnectClientAlias.getter(ServiceConnectClientAlias::port)).setter(ServiceConnectClientAlias.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsName").getter(ServiceConnectClientAlias.getter(ServiceConnectClientAlias::dnsName)).setter(ServiceConnectClientAlias.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, DNS_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("port", PORT_FIELD);
            this.put("dnsName", DNS_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final String dnsName;

    private ServiceConnectClientAlias(BuilderImpl builder) {
        this.port = builder.port;
        this.dnsName = builder.dnsName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectClientAlias)) {
            return false;
        }
        ServiceConnectClientAlias other = (ServiceConnectClientAlias)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.dnsName(), other.dnsName());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceConnectClientAlias").add("Port", (Object)this.port()).add("DnsName", (Object)this.dnsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "dnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectClientAlias, T> g) {
        return obj -> g.apply((ServiceConnectClientAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String dnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectClientAlias model) {
            this.port(model.port);
            this.dnsName(model.dnsName);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public ServiceConnectClientAlias build() {
            return new ServiceConnectClientAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceConnectClientAlias> {
        public Builder port(Integer var1);

        public Builder dnsName(String var1);
    }
}

