/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any
 * new services with Service Connect turned on that are created in the cluster are added as client services in the
 * namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code>
 * in the <code>ServiceConnectConfiguration</code>. You can set the namespace of each service individually in the
 * <code>ServiceConnectConfiguration</code> to override this default parameter.
 * </p>
 * <p>
 * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
 * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects
 * logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service
 * Connect. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the
 * <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterServiceConnectDefaultsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterServiceConnectDefaultsRequest.Builder, ClusterServiceConnectDefaultsRequest> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ClusterServiceConnectDefaultsRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("namespace", NAMESPACE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private ClusterServiceConnectDefaultsRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace that's used when you create a
     * service and don't specify a Service Connect configuration. The namespace name can include up to 1024 characters.
     * The name is case-sensitive. The name can't include hyphens (-), tilde (~), greater than (&gt;), less than (&lt;),
     * or slash (/).
     * </p>
     * <p>
     * If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is
     * supported. The namespace must be in this account and this Amazon Web Services Region.
     * </p>
     * <p>
     * If you enter a new name, a Cloud Map namespace will be created. Amazon ECS creates a Cloud Map namespace with the
     * "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace type in the
     * Command Line Interface. Other types of instance discovery aren't used by Service Connect.
     * </p>
     * <p>
     * If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster configuration
     * for Service Connect is removed. Note that the namespace will remain in Cloud Map and must be deleted separately.
     * </p>
     * <p>
     * For more information about Cloud Map, see <a
     * href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a> in
     * the <i>Cloud Map Developer Guide</i>.
     * </p>
     * 
     * @return The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace that's used when you
     *         create a service and don't specify a Service Connect configuration. The namespace name can include up to
     *         1024 characters. The name is case-sensitive. The name can't include hyphens (-), tilde (~), greater than
     *         (&gt;), less than (&lt;), or slash (/).</p>
     *         <p>
     *         If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is
     *         supported. The namespace must be in this account and this Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you enter a new name, a Cloud Map namespace will be created. Amazon ECS creates a Cloud Map namespace
     *         with the "API calls" method of instance discovery only. This instance discovery method is the "HTTP"
     *         namespace type in the Command Line Interface. Other types of instance discovery aren't used by Service
     *         Connect.
     *         </p>
     *         <p>
     *         If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster
     *         configuration for Service Connect is removed. Note that the namespace will remain in Cloud Map and must
     *         be deleted separately.
     *         </p>
     *         <p>
     *         For more information about Cloud Map, see <a
     *         href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with
     *         Services</a> in the <i>Cloud Map Developer Guide</i>.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterServiceConnectDefaultsRequest)) {
            return false;
        }
        ClusterServiceConnectDefaultsRequest other = (ClusterServiceConnectDefaultsRequest) obj;
        return Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterServiceConnectDefaultsRequest").add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterServiceConnectDefaultsRequest, T> g) {
        return obj -> g.apply((ClusterServiceConnectDefaultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterServiceConnectDefaultsRequest> {
        /**
         * <p>
         * The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace that's used when you create
         * a service and don't specify a Service Connect configuration. The namespace name can include up to 1024
         * characters. The name is case-sensitive. The name can't include hyphens (-), tilde (~), greater than (&gt;),
         * less than (&lt;), or slash (/).
         * </p>
         * <p>
         * If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is
         * supported. The namespace must be in this account and this Amazon Web Services Region.
         * </p>
         * <p>
         * If you enter a new name, a Cloud Map namespace will be created. Amazon ECS creates a Cloud Map namespace with
         * the "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace
         * type in the Command Line Interface. Other types of instance discovery aren't used by Service Connect.
         * </p>
         * <p>
         * If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster
         * configuration for Service Connect is removed. Note that the namespace will remain in Cloud Map and must be
         * deleted separately.
         * </p>
         * <p>
         * For more information about Cloud Map, see <a
         * href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a>
         * in the <i>Cloud Map Developer Guide</i>.
         * </p>
         * 
         * @param namespace
         *        The namespace name or full Amazon Resource Name (ARN) of the Cloud Map namespace that's used when you
         *        create a service and don't specify a Service Connect configuration. The namespace name can include up
         *        to 1024 characters. The name is case-sensitive. The name can't include hyphens (-), tilde (~), greater
         *        than (&gt;), less than (&lt;), or slash (/).</p>
         *        <p>
         *        If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type
         *        is supported. The namespace must be in this account and this Amazon Web Services Region.
         *        </p>
         *        <p>
         *        If you enter a new name, a Cloud Map namespace will be created. Amazon ECS creates a Cloud Map
         *        namespace with the "API calls" method of instance discovery only. This instance discovery method is
         *        the "HTTP" namespace type in the Command Line Interface. Other types of instance discovery aren't used
         *        by Service Connect.
         *        </p>
         *        <p>
         *        If you update the cluster with an empty string <code>""</code> for the namespace name, the cluster
         *        configuration for Service Connect is removed. Note that the namespace will remain in Cloud Map and
         *        must be deleted separately.
         *        </p>
         *        <p>
         *        For more information about Cloud Map, see <a
         *        href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with
         *        Services</a> in the <i>Cloud Map Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterServiceConnectDefaultsRequest model) {
            namespace(model.namespace);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public ClusterServiceConnectDefaultsRequest build() {
            return new ClusterServiceConnectDefaultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
