/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesRequest extends EcsRequest implements
        ToCopyableBuilder<ListServicesRequest.Builder, ListServicesRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(ListServicesRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchType").getter(getter(ListServicesRequest::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedulingStrategy").getter(getter(ListServicesRequest::schedulingStrategyAsString))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LAUNCH_TYPE_FIELD, SCHEDULING_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("cluster", CLUSTER_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                    put("launchType", LAUNCH_TYPE_FIELD);
                    put("schedulingStrategy", SCHEDULING_STRATEGY_FIELD);
                }
            });

    private final String cluster;

    private final String nextToken;

    private final Integer maxResults;

    private final String launchType;

    private final String schedulingStrategy;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.launchType = builder.launchType;
        this.schedulingStrategy = builder.schedulingStrategy;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
     * <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
     *         <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more results
     * are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was provided,
     * it is possible the number of results to be fewer than <code>maxResults</code>.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more
     *         results are available to fulfill the request and further calls will be needed. If <code>maxResults</code>
     *         was provided, it is possible the number of results to be fewer than <code>maxResults</code>.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of service results that <code>ListServices</code> returned in paginated output. When this
     * parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page along
     * with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     * sending another <code>ListServices</code> request with the returned <code>nextToken</code> value. This value can
     * be between 1 and 100. If this parameter isn't used, then <code>ListServices</code> returns up to 10 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of service results that <code>ListServices</code> returned in paginated output. When
     *         this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a
     *         single page along with a <code>nextToken</code> response element. The remaining results of the initial
     *         request can be seen by sending another <code>ListServices</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The launch type to use when filtering the <code>ListServices</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type to use when filtering the <code>ListServices</code> results.
     * @see LaunchType
     */
    public final LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type to use when filtering the <code>ListServices</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type to use when filtering the <code>ListServices</code> results.
     * @see LaunchType
     */
    public final String launchTypeAsString() {
        return launchType;
    }

    /**
     * <p>
     * The scheduling strategy to use when filtering the <code>ListServices</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use when filtering the <code>ListServices</code> results.
     * @see SchedulingStrategy
     */
    public final SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy to use when filtering the <code>ListServices</code> results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use when filtering the <code>ListServices</code> results.
     * @see SchedulingStrategy
     */
    public final String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesRequest").add("Cluster", cluster()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("LaunchType", launchTypeAsString())
                .add("SchedulingStrategy", schedulingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesRequest, T> g) {
        return obj -> g.apply((ListServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
         * <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster to use when filtering the
         *        <code>ListServices</code> results. If you do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that more
         * results are available to fulfill the request and further calls will be needed. If <code>maxResults</code> was
         * provided, it is possible the number of results to be fewer than <code>maxResults</code>.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a <code>ListServices</code> request indicating that
         *        more results are available to fulfill the request and further calls will be needed. If
         *        <code>maxResults</code> was provided, it is possible the number of results to be fewer than
         *        <code>maxResults</code>.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of service results that <code>ListServices</code> returned in paginated output. When this
         * parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in a single page
         * along with a <code>nextToken</code> response element. The remaining results of the initial request can be
         * seen by sending another <code>ListServices</code> request with the returned <code>nextToken</code> value.
         * This value can be between 1 and 100. If this parameter isn't used, then <code>ListServices</code> returns up
         * to 10 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of service results that <code>ListServices</code> returned in paginated output.
         *        When this parameter is used, <code>ListServices</code> only returns <code>maxResults</code> results in
         *        a single page along with a <code>nextToken</code> response element. The remaining results of the
         *        initial request can be seen by sending another <code>ListServices</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         *        <code>ListServices</code> returns up to 10 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The launch type to use when filtering the <code>ListServices</code> results.
         * </p>
         * 
         * @param launchType
         *        The launch type to use when filtering the <code>ListServices</code> results.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type to use when filtering the <code>ListServices</code> results.
         * </p>
         * 
         * @param launchType
         *        The launch type to use when filtering the <code>ListServices</code> results.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The scheduling strategy to use when filtering the <code>ListServices</code> results.
         * </p>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use when filtering the <code>ListServices</code> results.
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy to use when filtering the <code>ListServices</code> results.
         * </p>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use when filtering the <code>ListServices</code> results.
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String nextToken;

        private Integer maxResults;

        private String launchType;

        private String schedulingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            cluster(model.cluster);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            launchType(model.launchType);
            schedulingStrategy(model.schedulingStrategy);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
