/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The managed storage configuration for the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedStorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedStorageConfiguration.Builder, ManagedStorageConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(ManagedStorageConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("fargateEphemeralStorageKmsKeyId")
            .getter(getter(ManagedStorageConfiguration::fargateEphemeralStorageKmsKeyId))
            .setter(setter(Builder::fargateEphemeralStorageKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fargateEphemeralStorageKmsKeyId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("kmsKeyId", KMS_KEY_ID_FIELD);
                    put("fargateEphemeralStorageKmsKeyId", FARGATE_EPHEMERAL_STORAGE_KMS_KEY_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String fargateEphemeralStorageKmsKeyId;

    private ManagedStorageConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.fargateEphemeralStorageKmsKeyId = builder.fargateEphemeralStorageKmsKeyId;
    }

    /**
     * <p>
     * Specify a Key Management Service key ID to encrypt the managed storage.
     * </p>
     * 
     * @return Specify a Key Management Service key ID to encrypt the managed storage.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specify the Key Management Service key ID for the Fargate ephemeral storage.
     * </p>
     * 
     * @return Specify the Key Management Service key ID for the Fargate ephemeral storage.
     */
    public final String fargateEphemeralStorageKmsKeyId() {
        return fargateEphemeralStorageKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(fargateEphemeralStorageKmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedStorageConfiguration)) {
            return false;
        }
        ManagedStorageConfiguration other = (ManagedStorageConfiguration) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(fargateEphemeralStorageKmsKeyId(), other.fargateEphemeralStorageKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedStorageConfiguration").add("KmsKeyId", kmsKeyId())
                .add("FargateEphemeralStorageKmsKeyId", fargateEphemeralStorageKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "fargateEphemeralStorageKmsKeyId":
            return Optional.ofNullable(clazz.cast(fargateEphemeralStorageKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ManagedStorageConfiguration, T> g) {
        return obj -> g.apply((ManagedStorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedStorageConfiguration> {
        /**
         * <p>
         * Specify a Key Management Service key ID to encrypt the managed storage.
         * </p>
         * 
         * @param kmsKeyId
         *        Specify a Key Management Service key ID to encrypt the managed storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specify the Key Management Service key ID for the Fargate ephemeral storage.
         * </p>
         * 
         * @param fargateEphemeralStorageKmsKeyId
         *        Specify the Key Management Service key ID for the Fargate ephemeral storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fargateEphemeralStorageKmsKeyId(String fargateEphemeralStorageKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String fargateEphemeralStorageKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedStorageConfiguration model) {
            kmsKeyId(model.kmsKeyId);
            fargateEphemeralStorageKmsKeyId(model.fargateEphemeralStorageKmsKeyId);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getFargateEphemeralStorageKmsKeyId() {
            return fargateEphemeralStorageKmsKeyId;
        }

        public final void setFargateEphemeralStorageKmsKeyId(String fargateEphemeralStorageKmsKeyId) {
            this.fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId;
        }

        @Override
        public final Builder fargateEphemeralStorageKmsKeyId(String fargateEphemeralStorageKmsKeyId) {
            this.fargateEphemeralStorageKmsKeyId = fargateEphemeralStorageKmsKeyId;
            return this;
        }

        @Override
        public ManagedStorageConfiguration build() {
            return new ManagedStorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
