/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountSettingDefaultRequest extends EcsRequest implements
        ToCopyableBuilder<PutAccountSettingDefaultRequest.Builder, PutAccountSettingDefaultRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PutAccountSettingDefaultRequest::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(PutAccountSettingDefaultRequest::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private final String name;

    private final String value;

    private PutAccountSettingDefaultRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The resource name for which to modify the account setting.
     * </p>
     * <p>
     * The following are the valid values for the account setting name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
     * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
     * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource
     * is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to
     * use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
     * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
     * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource
     * is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to
     * use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
     * format of the resource type for a specified user, role, or the root user for an account is affected. The opt-in
     * and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format
     * of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on
     * this setting to use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new container
     * instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any new container
     * instances that support the feature are launched have the increased ENI limits available to them. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic Network
     * Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>containerInsights</code> - Container Insights with enhanced observability provides all the Container
     * Insights metrics, plus additional task and container metrics. This version supports enhanced observability for
     * Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with
     * enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the
     * cluster level down to the container level in your environment and displays these critical performance data in
     * curated dashboards removing the heavy lifting in observability set-up.
     * </p>
     * <p>
     * To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting to
     * <code>enhanced</code>.
     * </p>
     * <p>
     * To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor
     * Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon Elastic Container
     * Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
     * <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6 with tasks
     * launched on Amazon EC2 instances, see <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
     * >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
     * >Using a VPC in dual-stack mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance is
     * affected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
     * infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new
     * tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the wait time to
     * retire a Fargate task. For information about the Fargate tasks maintenance, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web Services
     * Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource creation.
     * Users must have permissions for actions that create the resource, such as <code>ecsCreateCluster</code>. If tags
     * are specified when you create a resource, Amazon Web Services performs additional authorization to verify if
     * users or roles have permissions to create tags. Therefore, you must grant explicit permissions to use the
     * <code>ecs:TagResource</code> action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
     * permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS and
     * indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your
     * Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html">Protecting
     * Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name for which to modify the account setting.</p>
     *         <p>
     *         The following are the valid values for the account setting name.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format
     *         of the resource type for a specified user, role, or the root user for an account is affected. The opt-in
     *         and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID
     *         format of a resource is defined by the opt-in status of the user or role that created the resource. You
     *         must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of
     *         the resource type for a specified user, role, or the root user for an account is affected. The opt-in and
     *         opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID
     *         format of a resource is defined by the opt-in status of the user or role that created the resource. You
     *         must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource
     *         ID format of the resource type for a specified user, role, or the root user for an account is affected.
     *         The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and
     *         resource ID format of a resource is defined by the opt-in status of the user or role that created the
     *         resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new
     *         container instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any
     *         new container instances that support the feature are launched have the increased ENI limits available to
     *         them. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
     *         Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>containerInsights</code> - Container Insights with enhanced observability provides all the
     *         Container Insights metrics, plus additional task and container metrics. This version supports enhanced
     *         observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure
     *         Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed
     *         infrastructure telemetry from the cluster level down to the container level in your environment and
     *         displays these critical performance data in curated dashboards removing the heavy lifting in
     *         observability set-up.
     *         </p>
     *         <p>
     *         To use Container Insights with enhanced observability, set the <code>containerInsights</code> account
     *         setting to <code>enhanced</code>.
     *         </p>
     *         <p>
     *         To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>
     *         .
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html"
     *         >Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon
     *         Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
     *         <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6
     *         with tasks launched on Amazon EC2 instances, see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
     *         >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
     *         >Using a VPC in dual-stack mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance
     *         is affected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
     *         infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped
     *         and new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the
     *         wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web
     *         Services Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
     *         creation. Users must have permissions for actions that create the resource, such as
     *         <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services
     *         performs additional authorization to verify if users or roles have permissions to create tags. Therefore,
     *         you must grant explicit permissions to use the <code>ecs:TagResource</code> action. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html"
     *         >Grant permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS
     *         and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator
     *         in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html"
     *         >Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
     *         </p>
     *         </li>
     * @see SettingName
     */
    public final SettingName name() {
        return SettingName.fromValue(name);
    }

    /**
     * <p>
     * The resource name for which to modify the account setting.
     * </p>
     * <p>
     * The following are the valid values for the account setting name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
     * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
     * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource
     * is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to
     * use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
     * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
     * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a resource
     * is defined by the opt-in status of the user or role that created the resource. You must turn on this setting to
     * use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
     * format of the resource type for a specified user, role, or the root user for an account is affected. The opt-in
     * and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format
     * of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on
     * this setting to use Amazon ECS features such as resource tagging.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new container
     * instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any new container
     * instances that support the feature are launched have the increased ENI limits available to them. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic Network
     * Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>containerInsights</code> - Container Insights with enhanced observability provides all the Container
     * Insights metrics, plus additional task and container metrics. This version supports enhanced observability for
     * Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with
     * enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the
     * cluster level down to the container level in your environment and displays these critical performance data in
     * curated dashboards removing the heavy lifting in observability set-up.
     * </p>
     * <p>
     * To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting to
     * <code>enhanced</code>.
     * </p>
     * <p>
     * To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor
     * Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon Elastic Container
     * Service Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
     * <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6 with tasks
     * launched on Amazon EC2 instances, see <a href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
     * >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate, see <a
     * href=
     * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
     * >Using a VPC in dual-stack mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance is
     * affected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
     * infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and new
     * tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the wait time to
     * retire a Fargate task. For information about the Fargate tasks maintenance, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web Services
     * Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource creation.
     * Users must have permissions for actions that create the resource, such as <code>ecsCreateCluster</code>. If tags
     * are specified when you create a resource, Amazon Web Services performs additional authorization to verify if
     * users or roles have permissions to create tags. Therefore, you must grant explicit permissions to use the
     * <code>ecs:TagResource</code> action. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
     * permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS and
     * indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your
     * Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html">Protecting
     * Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name for which to modify the account setting.</p>
     *         <p>
     *         The following are the valid values for the account setting name.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format
     *         of the resource type for a specified user, role, or the root user for an account is affected. The opt-in
     *         and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID
     *         format of a resource is defined by the opt-in status of the user or role that created the resource. You
     *         must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of
     *         the resource type for a specified user, role, or the root user for an account is affected. The opt-in and
     *         opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID
     *         format of a resource is defined by the opt-in status of the user or role that created the resource. You
     *         must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource
     *         ID format of the resource type for a specified user, role, or the root user for an account is affected.
     *         The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and
     *         resource ID format of a resource is defined by the opt-in status of the user or role that created the
     *         resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new
     *         container instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any
     *         new container instances that support the feature are launched have the increased ENI limits available to
     *         them. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
     *         Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>containerInsights</code> - Container Insights with enhanced observability provides all the
     *         Container Insights metrics, plus additional task and container metrics. This version supports enhanced
     *         observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure
     *         Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed
     *         infrastructure telemetry from the cluster level down to the container level in your environment and
     *         displays these critical performance data in curated dashboards removing the heavy lifting in
     *         observability set-up.
     *         </p>
     *         <p>
     *         To use Container Insights with enhanced observability, set the <code>containerInsights</code> account
     *         setting to <code>enhanced</code>.
     *         </p>
     *         <p>
     *         To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>
     *         .
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html"
     *         >Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon
     *         Elastic Container Service Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
     *         <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6
     *         with tasks launched on Amazon EC2 instances, see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
     *         >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
     *         >Using a VPC in dual-stack mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance
     *         is affected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
     *         infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped
     *         and new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the
     *         wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web
     *         Services Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
     *         creation. Users must have permissions for actions that create the resource, such as
     *         <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services
     *         performs additional authorization to verify if users or roles have permissions to create tags. Therefore,
     *         you must grant explicit permissions to use the <code>ecs:TagResource</code> action. For more information,
     *         see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html"
     *         >Grant permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS
     *         and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator
     *         in your Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html"
     *         >Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
     *         </p>
     *         </li>
     * @see SettingName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The account setting value for the specified principal ARN. Accepted values are <code>enabled</code>,
     * <code>disabled</code>, <code>on</code>, <code>enhanced</code>, and <code>off</code>.
     * </p>
     * <p>
     * When you specify <code>fargateTaskRetirementWaitPeriod</code> for the <code>name</code>, the following are the
     * valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>0</code> - Amazon Web Services sends the notification, and immediately retires the affected tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>7</code> - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>14</code> - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The account setting value for the specified principal ARN. Accepted values are <code>enabled</code>,
     *         <code>disabled</code>, <code>on</code>, <code>enhanced</code>, and <code>off</code>.</p>
     *         <p>
     *         When you specify <code>fargateTaskRetirementWaitPeriod</code> for the <code>name</code>, the following
     *         are the valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>0</code> - Amazon Web Services sends the notification, and immediately retires the affected tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>7</code> - Amazon Web Services sends the notification, and waits 7 calendar days to retire the
     *         tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>14</code> - Amazon Web Services sends the notification, and waits 14 calendar days to retire the
     *         tasks.
     *         </p>
     *         </li>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountSettingDefaultRequest)) {
            return false;
        }
        PutAccountSettingDefaultRequest other = (PutAccountSettingDefaultRequest) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountSettingDefaultRequest").add("Name", nameAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountSettingDefaultRequest, T> g) {
        return obj -> g.apply((PutAccountSettingDefaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountSettingDefaultRequest> {
        /**
         * <p>
         * The resource name for which to modify the account setting.
         * </p>
         * <p>
         * The following are the valid values for the account setting name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of
         * the resource type for a specified user, role, or the root user for an account is affected. The opt-in and
         * opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format
         * of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on
         * this setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
         * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
         * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a
         * resource is defined by the opt-in status of the user or role that created the resource. You must turn on this
         * setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
         * format of the resource type for a specified user, role, or the root user for an account is affected. The
         * opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource
         * ID format of a resource is defined by the opt-in status of the user or role that created the resource. You
         * must turn on this setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new container
         * instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any new container
         * instances that support the feature are launched have the increased ENI limits available to them. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
         * Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>containerInsights</code> - Container Insights with enhanced observability provides all the Container
         * Insights metrics, plus additional task and container metrics. This version supports enhanced observability
         * for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights
         * with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry
         * from the cluster level down to the container level in your environment and displays these critical
         * performance data in curated dashboards removing the heavy lifting in observability set-up.
         * </p>
         * <p>
         * To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting
         * to <code>enhanced</code>.
         * </p>
         * <p>
         * To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor
         * Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon Elastic
         * Container Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
         * <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6 with
         * tasks launched on Amazon EC2 instances, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
         * >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate, see
         * <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
         * >Using a VPC in dual-stack mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance is
         * affected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
         * infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and
         * new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the wait
         * time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web Services
         * Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
         * creation. Users must have permissions for actions that create the resource, such as
         * <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services performs
         * additional authorization to verify if users or roles have permissions to create tags. Therefore, you must
         * grant explicit permissions to use the <code>ecs:TagResource</code> action. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
         * permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS and
         * indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your
         * Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html">
         * Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The resource name for which to modify the account setting.</p>
         *        <p>
         *        The following are the valid values for the account setting name.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
         *        format of the resource type for a specified user, role, or the root user for an account is affected.
         *        The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN
         *        and resource ID format of a resource is defined by the opt-in status of the user or role that created
         *        the resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format
         *        of the resource type for a specified user, role, or the root user for an account is affected. The
         *        opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and
         *        resource ID format of a resource is defined by the opt-in status of the user or role that created the
         *        resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and
         *        resource ID format of the resource type for a specified user, role, or the root user for an account is
         *        affected. The opt-in and opt-out account setting must be set for each Amazon ECS resource separately.
         *        The ARN and resource ID format of a resource is defined by the opt-in status of the user or role that
         *        created the resource. You must turn on this setting to use Amazon ECS features such as resource
         *        tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new
         *        container instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on,
         *        any new container instances that support the feature are launched have the increased ENI limits
         *        available to them. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
         *        Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>containerInsights</code> - Container Insights with enhanced observability provides all the
         *        Container Insights metrics, plus additional task and container metrics. This version supports enhanced
         *        observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you
         *        configure Container Insights with enhanced observability on Amazon ECS, Container Insights
         *        auto-collects detailed infrastructure telemetry from the cluster level down to the container level in
         *        your environment and displays these critical performance data in curated dashboards removing the heavy
         *        lifting in observability set-up.
         *        </p>
         *        <p>
         *        To use Container Insights with enhanced observability, set the <code>containerInsights</code> account
         *        setting to <code>enhanced</code>.
         *        </p>
         *        <p>
         *        To use Container Insights, set the <code>containerInsights</code> account setting to
         *        <code>enabled</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html"
         *        >Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the
         *        <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
         *        <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6
         *        with tasks launched on Amazon EC2 instances, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
         *        >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on
         *        Fargate, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
         *        >Using a VPC in dual-stack mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140
         *        compliance is affected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
         *        infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped
         *        and new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure
         *        the wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web
         *        Services Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
         *        creation. Users must have permissions for actions that create the resource, such as
         *        <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services
         *        performs additional authorization to verify if users or roles have permissions to create tags.
         *        Therefore, you must grant explicit permissions to use the <code>ecs:TagResource</code> action. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
         *        permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon
         *        ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security
         *        administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your
         *        behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html"
         *        >Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
         *        </p>
         *        </li>
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(String name);

        /**
         * <p>
         * The resource name for which to modify the account setting.
         * </p>
         * <p>
         * The following are the valid values for the account setting name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of
         * the resource type for a specified user, role, or the root user for an account is affected. The opt-in and
         * opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format
         * of a resource is defined by the opt-in status of the user or role that created the resource. You must turn on
         * this setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format of the
         * resource type for a specified user, role, or the root user for an account is affected. The opt-in and opt-out
         * account setting must be set for each Amazon ECS resource separately. The ARN and resource ID format of a
         * resource is defined by the opt-in status of the user or role that created the resource. You must turn on this
         * setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
         * format of the resource type for a specified user, role, or the root user for an account is affected. The
         * opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and resource
         * ID format of a resource is defined by the opt-in status of the user or role that created the resource. You
         * must turn on this setting to use Amazon ECS features such as resource tagging.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new container
         * instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on, any new container
         * instances that support the feature are launched have the increased ENI limits available to them. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
         * Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>containerInsights</code> - Container Insights with enhanced observability provides all the Container
         * Insights metrics, plus additional task and container metrics. This version supports enhanced observability
         * for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights
         * with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry
         * from the cluster level down to the container level in your environment and displays these critical
         * performance data in curated dashboards removing the heavy lifting in observability set-up.
         * </p>
         * <p>
         * To use Container Insights with enhanced observability, set the <code>containerInsights</code> account setting
         * to <code>enhanced</code>.
         * </p>
         * <p>
         * To use Container Insights, set the <code>containerInsights</code> account setting to <code>enabled</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor
         * Amazon ECS containers using Container Insights with enhanced observability</a> in the <i>Amazon Elastic
         * Container Service Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
         * <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6 with
         * tasks launched on Amazon EC2 instances, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
         * >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on Fargate, see
         * <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
         * >Using a VPC in dual-stack mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140 compliance is
         * affected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
         * infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped and
         * new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure the wait
         * time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web Services
         * Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
         * creation. Users must have permissions for actions that create the resource, such as
         * <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services performs
         * additional authorization to verify if users or roles have permissions to create tags. Therefore, you must
         * grant explicit permissions to use the <code>ecs:TagResource</code> action. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
         * permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon ECS and
         * indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security administrator in your
         * Amazon ECS account. Amazon GuardDuty controls this account setting on your behalf. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html">
         * Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The resource name for which to modify the account setting.</p>
         *        <p>
         *        The following are the valid values for the account setting name.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>serviceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID
         *        format of the resource type for a specified user, role, or the root user for an account is affected.
         *        The opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN
         *        and resource ID format of a resource is defined by the opt-in status of the user or role that created
         *        the resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>taskLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and resource ID format
         *        of the resource type for a specified user, role, or the root user for an account is affected. The
         *        opt-in and opt-out account setting must be set for each Amazon ECS resource separately. The ARN and
         *        resource ID format of a resource is defined by the opt-in status of the user or role that created the
         *        resource. You must turn on this setting to use Amazon ECS features such as resource tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>containerInstanceLongArnFormat</code> - When modified, the Amazon Resource Name (ARN) and
         *        resource ID format of the resource type for a specified user, role, or the root user for an account is
         *        affected. The opt-in and opt-out account setting must be set for each Amazon ECS resource separately.
         *        The ARN and resource ID format of a resource is defined by the opt-in status of the user or role that
         *        created the resource. You must turn on this setting to use Amazon ECS features such as resource
         *        tagging.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>awsvpcTrunking</code> - When modified, the elastic network interface (ENI) limit for any new
         *        container instances that support the feature is changed. If <code>awsvpcTrunking</code> is turned on,
         *        any new container instances that support the feature are launched have the increased ENI limits
         *        available to them. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-eni.html">Elastic
         *        Network Interface Trunking</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>containerInsights</code> - Container Insights with enhanced observability provides all the
         *        Container Insights metrics, plus additional task and container metrics. This version supports enhanced
         *        observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you
         *        configure Container Insights with enhanced observability on Amazon ECS, Container Insights
         *        auto-collects detailed infrastructure telemetry from the cluster level down to the container level in
         *        your environment and displays these critical performance data in curated dashboards removing the heavy
         *        lifting in observability set-up.
         *        </p>
         *        <p>
         *        To use Container Insights with enhanced observability, set the <code>containerInsights</code> account
         *        setting to <code>enhanced</code>.
         *        </p>
         *        <p>
         *        To use Container Insights, set the <code>containerInsights</code> account setting to
         *        <code>enabled</code>.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html"
         *        >Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the
         *        <i>Amazon Elastic Container Service Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dualStackIPv6</code> - When turned on, when using a VPC in dual stack mode, your tasks using the
         *        <code>awsvpc</code> network mode can have an IPv6 address assigned. For more information on using IPv6
         *        with tasks launched on Amazon EC2 instances, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking-awsvpc.html#task-networking-vpc-dual-stack"
         *        >Using a VPC in dual-stack mode</a>. For more information on using IPv6 with tasks launched on
         *        Fargate, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-task-networking.html#fargate-task-networking-vpc-dual-stack"
         *        >Using a VPC in dual-stack mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fargateFIPSMode</code> - If you specify <code>fargateFIPSMode</code>, Fargate FIPS 140
         *        compliance is affected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fargateTaskRetirementWaitPeriod</code> - When Amazon Web Services determines that a security or
         *        infrastructure update is needed for an Amazon ECS task hosted on Fargate, the tasks need to be stopped
         *        and new tasks launched to replace them. Use <code>fargateTaskRetirementWaitPeriod</code> to configure
         *        the wait time to retire a Fargate task. For information about the Fargate tasks maintenance, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-maintenance.html">Amazon Web
         *        Services Fargate task maintenance</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tagResourceAuthorization</code> - Amazon ECS is introducing tagging authorization for resource
         *        creation. Users must have permissions for actions that create the resource, such as
         *        <code>ecsCreateCluster</code>. If tags are specified when you create a resource, Amazon Web Services
         *        performs additional authorization to verify if users or roles have permissions to create tags.
         *        Therefore, you must grant explicit permissions to use the <code>ecs:TagResource</code> action. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/supported-iam-actions-tagging.html">Grant
         *        permission to tag resources on creation</a> in the <i>Amazon ECS Developer Guide</i>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>guardDutyActivate</code> - The <code>guardDutyActivate</code> parameter is read-only in Amazon
         *        ECS and indicates whether Amazon ECS Runtime Monitoring is enabled or disabled by your security
         *        administrator in your Amazon ECS account. Amazon GuardDuty controls this account setting on your
         *        behalf. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html"
         *        >Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring</a>.
         *        </p>
         *        </li>
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(SettingName name);

        /**
         * <p>
         * The account setting value for the specified principal ARN. Accepted values are <code>enabled</code>,
         * <code>disabled</code>, <code>on</code>, <code>enhanced</code>, and <code>off</code>.
         * </p>
         * <p>
         * When you specify <code>fargateTaskRetirementWaitPeriod</code> for the <code>name</code>, the following are
         * the valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>0</code> - Amazon Web Services sends the notification, and immediately retires the affected tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>7</code> - Amazon Web Services sends the notification, and waits 7 calendar days to retire the tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>14</code> - Amazon Web Services sends the notification, and waits 14 calendar days to retire the tasks.
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        The account setting value for the specified principal ARN. Accepted values are <code>enabled</code>,
         *        <code>disabled</code>, <code>on</code>, <code>enhanced</code>, and <code>off</code>.</p>
         *        <p>
         *        When you specify <code>fargateTaskRetirementWaitPeriod</code> for the <code>name</code>, the following
         *        are the valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>0</code> - Amazon Web Services sends the notification, and immediately retires the affected
         *        tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>7</code> - Amazon Web Services sends the notification, and waits 7 calendar days to retire the
         *        tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>14</code> - Amazon Web Services sends the notification, and waits 14 calendar days to retire the
         *        tasks.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountSettingDefaultRequest model) {
            super(model);
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SettingName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountSettingDefaultRequest build() {
            return new PutAccountSettingDefaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
