/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of ephemeral storage to allocate for the task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskEphemeralStorage implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskEphemeralStorage.Builder, TaskEphemeralStorage> {
    private static final SdkField<Integer> SIZE_IN_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGiB").getter(getter(TaskEphemeralStorage::sizeInGiB)).setter(setter(Builder::sizeInGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGiB").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(TaskEphemeralStorage::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_GIB_FIELD,
            KMS_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("sizeInGiB", SIZE_IN_GIB_FIELD);
                    put("kmsKeyId", KMS_KEY_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer sizeInGiB;

    private final String kmsKeyId;

    private TaskEphemeralStorage(BuilderImpl builder) {
        this.sizeInGiB = builder.sizeInGiB;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * The total amount, in GiB, of the ephemeral storage to set for the task. The minimum supported value is
     * <code>20</code> GiB and the maximum supported value is&#x2028; <code>200</code> GiB.
     * </p>
     * 
     * @return The total amount, in GiB, of the ephemeral storage to set for the task. The minimum supported value is
     *         <code>20</code> GiB and the maximum supported value is&#x2028; <code>200</code> GiB.
     */
    public final Integer sizeInGiB() {
        return sizeInGiB;
    }

    /**
     * <p>
     * Specify an Key Management Service key ID to encrypt the ephemeral storage for the task.
     * </p>
     * 
     * @return Specify an Key Management Service key ID to encrypt the ephemeral storage for the task.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGiB());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskEphemeralStorage)) {
            return false;
        }
        TaskEphemeralStorage other = (TaskEphemeralStorage) obj;
        return Objects.equals(sizeInGiB(), other.sizeInGiB()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskEphemeralStorage").add("SizeInGiB", sizeInGiB()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sizeInGiB":
            return Optional.ofNullable(clazz.cast(sizeInGiB()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TaskEphemeralStorage, T> g) {
        return obj -> g.apply((TaskEphemeralStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskEphemeralStorage> {
        /**
         * <p>
         * The total amount, in GiB, of the ephemeral storage to set for the task. The minimum supported value is
         * <code>20</code> GiB and the maximum supported value is&#x2028; <code>200</code> GiB.
         * </p>
         * 
         * @param sizeInGiB
         *        The total amount, in GiB, of the ephemeral storage to set for the task. The minimum supported value is
         *        <code>20</code> GiB and the maximum supported value is&#x2028; <code>200</code> GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGiB(Integer sizeInGiB);

        /**
         * <p>
         * Specify an Key Management Service key ID to encrypt the ephemeral storage for the task.
         * </p>
         * 
         * @param kmsKeyId
         *        Specify an Key Management Service key ID to encrypt the ephemeral storage for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInGiB;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskEphemeralStorage model) {
            sizeInGiB(model.sizeInGiB);
            kmsKeyId(model.kmsKeyId);
        }

        public final Integer getSizeInGiB() {
            return sizeInGiB;
        }

        public final void setSizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
        }

        @Override
        public final Builder sizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public TaskEphemeralStorage build() {
            return new TaskEphemeralStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
