/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the timeout configurations for Service Connect.
 * </p>
 * <note>
 * <p>
 * If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code>, the connection will
 * close when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeoutConfiguration.Builder, TimeoutConfiguration> {
    private static final SdkField<Integer> IDLE_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("idleTimeoutSeconds").getter(getter(TimeoutConfiguration::idleTimeoutSeconds))
            .setter(setter(Builder::idleTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleTimeoutSeconds").build())
            .build();

    private static final SdkField<Integer> PER_REQUEST_TIMEOUT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("perRequestTimeoutSeconds")
            .getter(getter(TimeoutConfiguration::perRequestTimeoutSeconds)).setter(setter(Builder::perRequestTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRequestTimeoutSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDLE_TIMEOUT_SECONDS_FIELD,
            PER_REQUEST_TIMEOUT_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("idleTimeoutSeconds", IDLE_TIMEOUT_SECONDS_FIELD);
                    put("perRequestTimeoutSeconds", PER_REQUEST_TIMEOUT_SECONDS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer idleTimeoutSeconds;

    private final Integer perRequestTimeoutSeconds;

    private TimeoutConfiguration(BuilderImpl builder) {
        this.idleTimeoutSeconds = builder.idleTimeoutSeconds;
        this.perRequestTimeoutSeconds = builder.perRequestTimeoutSeconds;
    }

    /**
     * <p>
     * The amount of time in seconds a connection will stay active while idle. A value of <code>0</code> can be set to
     * disable <code>idleTimeout</code>.
     * </p>
     * <p>
     * The <code>idleTimeout</code> default for <code>HTTP</code>/<code>HTTP2</code>/<code>GRPC</code> is 5 minutes.
     * </p>
     * <p>
     * The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
     * </p>
     * 
     * @return The amount of time in seconds a connection will stay active while idle. A value of <code>0</code> can be
     *         set to disable <code>idleTimeout</code>.</p>
     *         <p>
     *         The <code>idleTimeout</code> default for <code>HTTP</code>/<code>HTTP2</code>/<code>GRPC</code> is 5
     *         minutes.
     *         </p>
     *         <p>
     *         The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
     */
    public final Integer idleTimeoutSeconds() {
        return idleTimeoutSeconds;
    }

    /**
     * <p>
     * The amount of time waiting for the upstream to respond with a complete response per request. A value of
     * <code>0</code> can be set to disable <code>perRequestTimeout</code>. <code>perRequestTimeout</code> can only be
     * set if Service Connect <code>appProtocol</code> isn't <code>TCP</code>. Only <code>idleTimeout</code> is allowed
     * for <code>TCP</code> <code>appProtocol</code>.
     * </p>
     * 
     * @return The amount of time waiting for the upstream to respond with a complete response per request. A value of
     *         <code>0</code> can be set to disable <code>perRequestTimeout</code>. <code>perRequestTimeout</code> can
     *         only be set if Service Connect <code>appProtocol</code> isn't <code>TCP</code>. Only
     *         <code>idleTimeout</code> is allowed for <code>TCP</code> <code>appProtocol</code>.
     */
    public final Integer perRequestTimeoutSeconds() {
        return perRequestTimeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(perRequestTimeoutSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutConfiguration)) {
            return false;
        }
        TimeoutConfiguration other = (TimeoutConfiguration) obj;
        return Objects.equals(idleTimeoutSeconds(), other.idleTimeoutSeconds())
                && Objects.equals(perRequestTimeoutSeconds(), other.perRequestTimeoutSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeoutConfiguration").add("IdleTimeoutSeconds", idleTimeoutSeconds())
                .add("PerRequestTimeoutSeconds", perRequestTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idleTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(idleTimeoutSeconds()));
        case "perRequestTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(perRequestTimeoutSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimeoutConfiguration, T> g) {
        return obj -> g.apply((TimeoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeoutConfiguration> {
        /**
         * <p>
         * The amount of time in seconds a connection will stay active while idle. A value of <code>0</code> can be set
         * to disable <code>idleTimeout</code>.
         * </p>
         * <p>
         * The <code>idleTimeout</code> default for <code>HTTP</code>/<code>HTTP2</code>/<code>GRPC</code> is 5 minutes.
         * </p>
         * <p>
         * The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
         * </p>
         * 
         * @param idleTimeoutSeconds
         *        The amount of time in seconds a connection will stay active while idle. A value of <code>0</code> can
         *        be set to disable <code>idleTimeout</code>.</p>
         *        <p>
         *        The <code>idleTimeout</code> default for <code>HTTP</code>/<code>HTTP2</code>/<code>GRPC</code> is 5
         *        minutes.
         *        </p>
         *        <p>
         *        The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeoutSeconds(Integer idleTimeoutSeconds);

        /**
         * <p>
         * The amount of time waiting for the upstream to respond with a complete response per request. A value of
         * <code>0</code> can be set to disable <code>perRequestTimeout</code>. <code>perRequestTimeout</code> can only
         * be set if Service Connect <code>appProtocol</code> isn't <code>TCP</code>. Only <code>idleTimeout</code> is
         * allowed for <code>TCP</code> <code>appProtocol</code>.
         * </p>
         * 
         * @param perRequestTimeoutSeconds
         *        The amount of time waiting for the upstream to respond with a complete response per request. A value
         *        of <code>0</code> can be set to disable <code>perRequestTimeout</code>. <code>perRequestTimeout</code>
         *        can only be set if Service Connect <code>appProtocol</code> isn't <code>TCP</code>. Only
         *        <code>idleTimeout</code> is allowed for <code>TCP</code> <code>appProtocol</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perRequestTimeoutSeconds(Integer perRequestTimeoutSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer idleTimeoutSeconds;

        private Integer perRequestTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeoutConfiguration model) {
            idleTimeoutSeconds(model.idleTimeoutSeconds);
            perRequestTimeoutSeconds(model.perRequestTimeoutSeconds);
        }

        public final Integer getIdleTimeoutSeconds() {
            return idleTimeoutSeconds;
        }

        public final void setIdleTimeoutSeconds(Integer idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
        }

        @Override
        public final Builder idleTimeoutSeconds(Integer idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
            return this;
        }

        public final Integer getPerRequestTimeoutSeconds() {
            return perRequestTimeoutSeconds;
        }

        public final void setPerRequestTimeoutSeconds(Integer perRequestTimeoutSeconds) {
            this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
        }

        @Override
        public final Builder perRequestTimeoutSeconds(Integer perRequestTimeoutSeconds) {
            this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
            return this;
        }

        @Override
        public TimeoutConfiguration build() {
            return new TimeoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
