/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopTaskRequest extends EcsRequest implements ToCopyableBuilder<StopTaskRequest.Builder, StopTaskRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(StopTaskRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> TASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("task")
            .getter(getter(StopTaskRequest::task)).setter(setter(Builder::task))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(StopTaskRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("cluster", CLUSTER_FIELD);
                    put("task", TASK_FIELD);
                    put("reason", REASON_FIELD);
                }
            });

    private final String cluster;

    private final String task;

    private final String reason;

    private StopTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not
     * specify a cluster, the default cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do
     *         not specify a cluster, the default cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The task ID of the task to stop.
     * </p>
     * 
     * @return The task ID of the task to stop.
     */
    public final String task() {
        return task;
    }

    /**
     * <p>
     * An optional message specified when a task is stopped. For example, if you're using a custom scheduler, you can
     * use this parameter to specify the reason for stopping the task here, and the message appears in subsequent <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a>&gt; API
     * operations on this task.
     * </p>
     * 
     * @return An optional message specified when a task is stopped. For example, if you're using a custom scheduler,
     *         you can use this parameter to specify the reason for stopping the task here, and the message appears in
     *         subsequent <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks
     *         </a>&gt; API operations on this task.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(task());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopTaskRequest)) {
            return false;
        }
        StopTaskRequest other = (StopTaskRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(task(), other.task())
                && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopTaskRequest").add("Cluster", cluster()).add("Task", task()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StopTaskRequest, T> g) {
        return obj -> g.apply((StopTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopTaskRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you do not
         * specify a cluster, the default cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the task to stop. If you
         *        do not specify a cluster, the default cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The task ID of the task to stop.
         * </p>
         * 
         * @param task
         *        The task ID of the task to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(String task);

        /**
         * <p>
         * An optional message specified when a task is stopped. For example, if you're using a custom scheduler, you
         * can use this parameter to specify the reason for stopping the task here, and the message appears in
         * subsequent <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html">DescribeTasks</a>&gt;
         * API operations on this task.
         * </p>
         * 
         * @param reason
         *        An optional message specified when a task is stopped. For example, if you're using a custom scheduler,
         *        you can use this parameter to specify the reason for stopping the task here, and the message appears
         *        in subsequent <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html"
         *        >DescribeTasks</a>&gt; API operations on this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String task;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopTaskRequest model) {
            super(model);
            cluster(model.cluster);
            task(model.task);
            reason(model.reason);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getTask() {
            return task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopTaskRequest build() {
            return new StopTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
