/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionFamilyStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskDefinitionFamiliesRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListTaskDefinitionFamiliesRequest> {
    private static final SdkField<String> FAMILY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("familyPrefix").getter(ListTaskDefinitionFamiliesRequest.getter(ListTaskDefinitionFamiliesRequest::familyPrefix)).setter(ListTaskDefinitionFamiliesRequest.setter(Builder::familyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("familyPrefix").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListTaskDefinitionFamiliesRequest.getter(ListTaskDefinitionFamiliesRequest::statusAsString)).setter(ListTaskDefinitionFamiliesRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaskDefinitionFamiliesRequest.getter(ListTaskDefinitionFamiliesRequest::nextToken)).setter(ListTaskDefinitionFamiliesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTaskDefinitionFamiliesRequest.getter(ListTaskDefinitionFamiliesRequest::maxResults)).setter(ListTaskDefinitionFamiliesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_PREFIX_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("familyPrefix", FAMILY_PREFIX_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String familyPrefix;
    private final String status;
    private final String nextToken;
    private final Integer maxResults;

    private ListTaskDefinitionFamiliesRequest(BuilderImpl builder) {
        super(builder);
        this.familyPrefix = builder.familyPrefix;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String familyPrefix() {
        return this.familyPrefix;
    }

    public final TaskDefinitionFamilyStatus status() {
        return TaskDefinitionFamilyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.familyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionFamiliesRequest)) {
            return false;
        }
        ListTaskDefinitionFamiliesRequest other = (ListTaskDefinitionFamiliesRequest)((Object)obj);
        return Objects.equals(this.familyPrefix(), other.familyPrefix()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaskDefinitionFamiliesRequest").add("FamilyPrefix", (Object)this.familyPrefix()).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "familyPrefix": {
                return Optional.ofNullable(clazz.cast(this.familyPrefix()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionFamiliesRequest, T> g) {
        return obj -> g.apply((ListTaskDefinitionFamiliesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String familyPrefix;
        private String status;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionFamiliesRequest model) {
            super(model);
            this.familyPrefix(model.familyPrefix);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getFamilyPrefix() {
            return this.familyPrefix;
        }

        public final void setFamilyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
        }

        @Override
        public final Builder familyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskDefinitionFamilyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTaskDefinitionFamiliesRequest build() {
            return new ListTaskDefinitionFamiliesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskDefinitionFamiliesRequest> {
        public Builder familyPrefix(String var1);

        public Builder status(String var1);

        public Builder status(TaskDefinitionFamilyStatus var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

