/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancer> {
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetGroupArn").getter(LoadBalancer.getter(LoadBalancer::targetGroupArn)).setter(LoadBalancer.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArn").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadBalancerName").getter(LoadBalancer.getter(LoadBalancer::loadBalancerName)).setter(LoadBalancer.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(LoadBalancer.getter(LoadBalancer::containerName)).setter(LoadBalancer.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(LoadBalancer.getter(LoadBalancer::containerPort)).setter(LoadBalancer.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_ARN_FIELD, LOAD_BALANCER_NAME_FIELD, CONTAINER_NAME_FIELD, CONTAINER_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("targetGroupArn", TARGET_GROUP_ARN_FIELD);
            this.put("loadBalancerName", LOAD_BALANCER_NAME_FIELD);
            this.put("containerName", CONTAINER_NAME_FIELD);
            this.put("containerPort", CONTAINER_PORT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String targetGroupArn;
    private final String loadBalancerName;
    private final String containerName;
    private final Integer containerPort;

    private LoadBalancer(BuilderImpl builder) {
        this.targetGroupArn = builder.targetGroupArn;
        this.loadBalancerName = builder.loadBalancerName;
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
    }

    public final String targetGroupArn() {
        return this.targetGroupArn;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        return Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.containerPort(), other.containerPort());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancer").add("TargetGroupArn", (Object)this.targetGroupArn()).add("LoadBalancerName", (Object)this.loadBalancerName()).add("ContainerName", (Object)this.containerName()).add("ContainerPort", (Object)this.containerPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancer, T> g) {
        return obj -> g.apply((LoadBalancer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetGroupArn;
        private String loadBalancerName;
        private String containerName;
        private Integer containerPort;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            this.targetGroupArn(model.targetGroupArn);
            this.loadBalancerName(model.loadBalancerName);
            this.containerName(model.containerName);
            this.containerPort(model.containerPort);
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancer> {
        public Builder targetGroupArn(String var1);

        public Builder loadBalancerName(String var1);

        public Builder containerName(String var1);

        public Builder containerPort(Integer var1);
    }
}

