/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAccountSettingRequest extends EcsRequest implements
        ToCopyableBuilder<DeleteAccountSettingRequest.Builder, DeleteAccountSettingRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeleteAccountSettingRequest::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalArn").getter(getter(DeleteAccountSettingRequest::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PRINCIPAL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String principalArn;

    private DeleteAccountSettingRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.principalArn = builder.principalArn;
    }

    /**
     * <p>
     * The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the ARN
     * for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID
     * for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and
     * resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the
     * ENI limit for your Amazon ECS container instances is affected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified,
     *         the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN
     *         and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
     *         specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
     *         <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is
     *         affected.
     * @see SettingName
     */
    public final SettingName name() {
        return SettingName.fromValue(name);
    }

    /**
     * <p>
     * The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the ARN
     * for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and resource ID
     * for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is specified, the ARN and
     * resource ID for your Amazon ECS container instances is affected. If <code>awsvpcTrunking</code> is specified, the
     * ENI limit for your Amazon ECS container instances is affected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SettingName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified,
     *         the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN
     *         and resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
     *         specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
     *         <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is
     *         affected.
     * @see SettingName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the principal. It can be an user, role, or the root user. If you specify the
     * root user, it disables the account setting for all users, roles, and the root user of the account unless a user
     * or role explicitly overrides these settings. If this field is omitted, the setting is changed only for the
     * authenticated user.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the principal. It can be an user, role, or the root user. If you
     *         specify the root user, it disables the account setting for all users, roles, and the root user of the
     *         account unless a user or role explicitly overrides these settings. If this field is omitted, the setting
     *         is changed only for the authenticated user.
     */
    public final String principalArn() {
        return principalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountSettingRequest)) {
            return false;
        }
        DeleteAccountSettingRequest other = (DeleteAccountSettingRequest) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(principalArn(), other.principalArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAccountSettingRequest").add("Name", nameAsString()).add("PrincipalArn", principalArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "principalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountSettingRequest, T> g) {
        return obj -> g.apply((DeleteAccountSettingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAccountSettingRequest> {
        /**
         * <p>
         * The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the
         * ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and
         * resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
         * specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
         * <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected.
         * </p>
         * 
         * @param name
         *        The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is
         *        specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is
         *        specified, the ARN and resource ID for your Amazon ECS tasks is affected. If
         *        <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS
         *        container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your
         *        Amazon ECS container instances is affected.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(String name);

        /**
         * <p>
         * The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is specified, the
         * ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is specified, the ARN and
         * resource ID for your Amazon ECS tasks is affected. If <code>containerInstanceLongArnFormat</code> is
         * specified, the ARN and resource ID for your Amazon ECS container instances is affected. If
         * <code>awsvpcTrunking</code> is specified, the ENI limit for your Amazon ECS container instances is affected.
         * </p>
         * 
         * @param name
         *        The resource name to disable the account setting for. If <code>serviceLongArnFormat</code> is
         *        specified, the ARN for your Amazon ECS services is affected. If <code>taskLongArnFormat</code> is
         *        specified, the ARN and resource ID for your Amazon ECS tasks is affected. If
         *        <code>containerInstanceLongArnFormat</code> is specified, the ARN and resource ID for your Amazon ECS
         *        container instances is affected. If <code>awsvpcTrunking</code> is specified, the ENI limit for your
         *        Amazon ECS container instances is affected.
         * @see SettingName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SettingName
         */
        Builder name(SettingName name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the principal. It can be an user, role, or the root user. If you specify
         * the root user, it disables the account setting for all users, roles, and the root user of the account unless
         * a user or role explicitly overrides these settings. If this field is omitted, the setting is changed only for
         * the authenticated user.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the principal. It can be an user, role, or the root user. If you
         *        specify the root user, it disables the account setting for all users, roles, and the root user of the
         *        account unless a user or role explicitly overrides these settings. If this field is omitted, the
         *        setting is changed only for the authenticated user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String name;

        private String principalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountSettingRequest model) {
            super(model);
            name(model.name);
            principalArn(model.principalArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SettingName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccountSettingRequest build() {
            return new DeleteAccountSettingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
