/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The optional filter to narrow the <code>ListServiceDeployment</code> results.
 * </p>
 * <p>
 * If you do not specify a value, service deployments that were created before the current time are included in the
 * result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatedAt implements SdkPojo, Serializable, ToCopyableBuilder<CreatedAt.Builder, CreatedAt> {
    private static final SdkField<Instant> BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("before").getter(getter(CreatedAt::before)).setter(setter(Builder::before))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("before").build()).build();

    private static final SdkField<Instant> AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("after")
            .getter(getter(CreatedAt::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("after").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEFORE_FIELD, AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant before;

    private final Instant after;

    private CreatedAt(BuilderImpl builder) {
        this.before = builder.before;
        this.after = builder.after;
    }

    /**
     * <p>
     * Include service deployments in the result that were created before this time. The format is yyyy-MM-dd
     * HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return Include service deployments in the result that were created before this time. The format is yyyy-MM-dd
     *         HH:mm:ss.SSSSSS.
     */
    public final Instant before() {
        return before;
    }

    /**
     * <p>
     * Include service deployments in the result that were created after this time. The format is yyyy-MM-dd
     * HH:mm:ss.SSSSSS.
     * </p>
     * 
     * @return Include service deployments in the result that were created after this time. The format is yyyy-MM-dd
     *         HH:mm:ss.SSSSSS.
     */
    public final Instant after() {
        return after;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(before());
        hashCode = 31 * hashCode + Objects.hashCode(after());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatedAt)) {
            return false;
        }
        CreatedAt other = (CreatedAt) obj;
        return Objects.equals(before(), other.before()) && Objects.equals(after(), other.after());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatedAt").add("Before", before()).add("After", after()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "before":
            return Optional.ofNullable(clazz.cast(before()));
        case "after":
            return Optional.ofNullable(clazz.cast(after()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("before", BEFORE_FIELD);
        map.put("after", AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatedAt, T> g) {
        return obj -> g.apply((CreatedAt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreatedAt> {
        /**
         * <p>
         * Include service deployments in the result that were created before this time. The format is yyyy-MM-dd
         * HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param before
         *        Include service deployments in the result that were created before this time. The format is yyyy-MM-dd
         *        HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder before(Instant before);

        /**
         * <p>
         * Include service deployments in the result that were created after this time. The format is yyyy-MM-dd
         * HH:mm:ss.SSSSSS.
         * </p>
         * 
         * @param after
         *        Include service deployments in the result that were created after this time. The format is yyyy-MM-dd
         *        HH:mm:ss.SSSSSS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(Instant after);
    }

    static final class BuilderImpl implements Builder {
        private Instant before;

        private Instant after;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatedAt model) {
            before(model.before);
            after(model.after);
        }

        public final Instant getBefore() {
            return before;
        }

        public final void setBefore(Instant before) {
            this.before = before;
        }

        @Override
        public final Builder before(Instant before) {
            this.before = before;
            return this;
        }

        public final Instant getAfter() {
            return after;
        }

        public final void setAfter(Instant after) {
            this.after = after;
        }

        @Override
        public final Builder after(Instant after) {
            this.after = after;
            return this;
        }

        @Override
        public CreatedAt build() {
            return new CreatedAt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
