/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceDeploymentsResponse extends EcsResponse implements
        ToCopyableBuilder<ListServiceDeploymentsResponse.Builder, ListServiceDeploymentsResponse> {
    private static final SdkField<List<ServiceDeploymentBrief>> SERVICE_DEPLOYMENTS_FIELD = SdkField
            .<List<ServiceDeploymentBrief>> builder(MarshallingType.LIST)
            .memberName("serviceDeployments")
            .getter(getter(ListServiceDeploymentsResponse::serviceDeployments))
            .setter(setter(Builder::serviceDeployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceDeploymentBrief> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceDeploymentBrief::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceDeploymentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ServiceDeploymentBrief> serviceDeployments;

    private final String nextToken;

    private ListServiceDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceDeployments = builder.serviceDeployments;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceDeployments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceDeployments() {
        return serviceDeployments != null && !(serviceDeployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An overview of the service deployment, including the following properties:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The ARN of the service deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN of the service being deployed.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN of the cluster that hosts the service in the service deployment.
     * </p>
     * </li>
     * <li>
     * <p>
     * The time that the service deployment started.
     * </p>
     * </li>
     * <li>
     * <p>
     * The time that the service deployment completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service deployment status.
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about why the service deployment is in the current state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The ARN of the service revision that is being deployed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceDeployments} method.
     * </p>
     * 
     * @return An overview of the service deployment, including the following properties:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The ARN of the service deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ARN of the service being deployed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ARN of the cluster that hosts the service in the service deployment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The time that the service deployment started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The time that the service deployment completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The service deployment status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Information about why the service deployment is in the current state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The ARN of the service revision that is being deployed.
     *         </p>
     *         </li>
     */
    public final List<ServiceDeploymentBrief> serviceDeployments() {
        return serviceDeployments;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListServiceDeployments</code> request. When the
     * results of a <code>ListServiceDeployments</code> request exceed <code>maxResults</code>, this value can be used
     * to retrieve the next page of results. This value is null when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListServiceDeployments</code> request. When
     *         the results of a <code>ListServiceDeployments</code> request exceed <code>maxResults</code>, this value
     *         can be used to retrieve the next page of results. This value is null when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceDeployments() ? serviceDeployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceDeploymentsResponse)) {
            return false;
        }
        ListServiceDeploymentsResponse other = (ListServiceDeploymentsResponse) obj;
        return hasServiceDeployments() == other.hasServiceDeployments()
                && Objects.equals(serviceDeployments(), other.serviceDeployments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceDeploymentsResponse")
                .add("ServiceDeployments", hasServiceDeployments() ? serviceDeployments() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceDeployments":
            return Optional.ofNullable(clazz.cast(serviceDeployments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceDeployments", SERVICE_DEPLOYMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceDeploymentsResponse, T> g) {
        return obj -> g.apply((ListServiceDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceDeploymentsResponse> {
        /**
         * <p>
         * An overview of the service deployment, including the following properties:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ARN of the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service being deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the cluster that hosts the service in the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment started.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The service deployment status.
         * </p>
         * </li>
         * <li>
         * <p>
         * Information about why the service deployment is in the current state.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service revision that is being deployed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceDeployments
         *        An overview of the service deployment, including the following properties:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ARN of the service deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the service being deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the cluster that hosts the service in the service deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The time that the service deployment started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The time that the service deployment completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The service deployment status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Information about why the service deployment is in the current state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the service revision that is being deployed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeployments(Collection<ServiceDeploymentBrief> serviceDeployments);

        /**
         * <p>
         * An overview of the service deployment, including the following properties:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ARN of the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service being deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the cluster that hosts the service in the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment started.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The service deployment status.
         * </p>
         * </li>
         * <li>
         * <p>
         * Information about why the service deployment is in the current state.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service revision that is being deployed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceDeployments
         *        An overview of the service deployment, including the following properties:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The ARN of the service deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the service being deployed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the cluster that hosts the service in the service deployment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The time that the service deployment started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The time that the service deployment completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The service deployment status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Information about why the service deployment is in the current state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The ARN of the service revision that is being deployed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeployments(ServiceDeploymentBrief... serviceDeployments);

        /**
         * <p>
         * An overview of the service deployment, including the following properties:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The ARN of the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service being deployed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the cluster that hosts the service in the service deployment.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment started.
         * </p>
         * </li>
         * <li>
         * <p>
         * The time that the service deployment completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * The service deployment status.
         * </p>
         * </li>
         * <li>
         * <p>
         * Information about why the service deployment is in the current state.
         * </p>
         * </li>
         * <li>
         * <p>
         * The ARN of the service revision that is being deployed.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceDeploymentBrief.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ecs.model.ServiceDeploymentBrief#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceDeploymentBrief.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceDeployments(List<ServiceDeploymentBrief>)}.
         * 
         * @param serviceDeployments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceDeploymentBrief.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceDeployments(java.util.Collection<ServiceDeploymentBrief>)
         */
        Builder serviceDeployments(Consumer<ServiceDeploymentBrief.Builder>... serviceDeployments);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListServiceDeployments</code> request. When the
         * results of a <code>ListServiceDeployments</code> request exceed <code>maxResults</code>, this value can be
         * used to retrieve the next page of results. This value is null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListServiceDeployments</code> request.
         *        When the results of a <code>ListServiceDeployments</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<ServiceDeploymentBrief> serviceDeployments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceDeploymentsResponse model) {
            super(model);
            serviceDeployments(model.serviceDeployments);
            nextToken(model.nextToken);
        }

        public final List<ServiceDeploymentBrief.Builder> getServiceDeployments() {
            List<ServiceDeploymentBrief.Builder> result = ServiceDeploymentsBriefCopier.copyToBuilder(this.serviceDeployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceDeployments(Collection<ServiceDeploymentBrief.BuilderImpl> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsBriefCopier.copyFromBuilder(serviceDeployments);
        }

        @Override
        public final Builder serviceDeployments(Collection<ServiceDeploymentBrief> serviceDeployments) {
            this.serviceDeployments = ServiceDeploymentsBriefCopier.copy(serviceDeployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(ServiceDeploymentBrief... serviceDeployments) {
            serviceDeployments(Arrays.asList(serviceDeployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeployments(Consumer<ServiceDeploymentBrief.Builder>... serviceDeployments) {
            serviceDeployments(Stream.of(serviceDeployments).map(c -> ServiceDeploymentBrief.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServiceDeploymentsResponse build() {
            return new ListServiceDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
