/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTasksResponse extends EcsResponse implements
        ToCopyableBuilder<ListTasksResponse.Builder, ListTasksResponse> {
    private static final SdkField<List<String>> TASK_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("taskArns")
            .getter(getter(ListTasksResponse::taskArns))
            .setter(setter(Builder::taskArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ARNS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> taskArns;

    private final String nextToken;

    private ListTasksResponse(BuilderImpl builder) {
        super(builder);
        this.taskArns = builder.taskArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskArns() {
        return taskArns != null && !(taskArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of task ARN entries for the <code>ListTasks</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskArns} method.
     * </p>
     * 
     * @return The list of task ARN entries for the <code>ListTasks</code> request.
     */
    public final List<String> taskArns() {
        return taskArns;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a
     * <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page
     * of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results
     *         of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve
     *         the next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskArns() ? taskArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTasksResponse)) {
            return false;
        }
        ListTasksResponse other = (ListTasksResponse) obj;
        return hasTaskArns() == other.hasTaskArns() && Objects.equals(taskArns(), other.taskArns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTasksResponse").add("TaskArns", hasTaskArns() ? taskArns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskArns":
            return Optional.ofNullable(clazz.cast(taskArns()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskArns", TASK_ARNS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTasksResponse, T> g) {
        return obj -> g.apply((ListTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTasksResponse> {
        /**
         * <p>
         * The list of task ARN entries for the <code>ListTasks</code> request.
         * </p>
         * 
         * @param taskArns
         *        The list of task ARN entries for the <code>ListTasks</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArns(Collection<String> taskArns);

        /**
         * <p>
         * The list of task ARN entries for the <code>ListTasks</code> request.
         * </p>
         * 
         * @param taskArns
         *        The list of task ARN entries for the <code>ListTasks</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArns(String... taskArns);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the results of a
         * <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
         * page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListTasks</code> request. When the
         *        results of a <code>ListTasks</code> request exceed <code>maxResults</code>, this value can be used to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<String> taskArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTasksResponse model) {
            super(model);
            taskArns(model.taskArns);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTaskArns() {
            if (taskArns instanceof SdkAutoConstructList) {
                return null;
            }
            return taskArns;
        }

        public final void setTaskArns(Collection<String> taskArns) {
            this.taskArns = StringListCopier.copy(taskArns);
        }

        @Override
        public final Builder taskArns(Collection<String> taskArns) {
            this.taskArns = StringListCopier.copy(taskArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskArns(String... taskArns) {
            taskArns(Arrays.asList(taskArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTasksResponse build() {
            return new ListTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
