/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopTaskResponse extends EcsResponse implements ToCopyableBuilder<StopTaskResponse.Builder, StopTaskResponse> {
    private static final SdkField<Task> TASK_FIELD = SdkField.<Task> builder(MarshallingType.SDK_POJO).memberName("task")
            .getter(getter(StopTaskResponse::task)).setter(setter(Builder::task)).constructor(Task::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Task task;

    private StopTaskResponse(BuilderImpl builder) {
        super(builder);
        this.task = builder.task;
    }

    /**
     * <p>
     * The task that was stopped.
     * </p>
     * 
     * @return The task that was stopped.
     */
    public final Task task() {
        return task;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(task());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopTaskResponse)) {
            return false;
        }
        StopTaskResponse other = (StopTaskResponse) obj;
        return Objects.equals(task(), other.task());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopTaskResponse").add("Task", task()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "task":
            return Optional.ofNullable(clazz.cast(task()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("task", TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopTaskResponse, T> g) {
        return obj -> g.apply((StopTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopTaskResponse> {
        /**
         * <p>
         * The task that was stopped.
         * </p>
         * 
         * @param task
         *        The task that was stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder task(Task task);

        /**
         * <p>
         * The task that was stopped.
         * </p>
         * This is a convenience method that creates an instance of the {@link Task.Builder} avoiding the need to create
         * one manually via {@link Task#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Task.Builder#build()} is called immediately and its result is
         * passed to {@link #task(Task)}.
         * 
         * @param task
         *        a consumer that will call methods on {@link Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #task(Task)
         */
        default Builder task(Consumer<Task.Builder> task) {
            return task(Task.builder().applyMutation(task).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private Task task;

        private BuilderImpl() {
        }

        private BuilderImpl(StopTaskResponse model) {
            super(model);
            task(model.task);
        }

        public final Task.Builder getTask() {
            return task != null ? task.toBuilder() : null;
        }

        public final void setTask(Task.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        @Override
        public final Builder task(Task task) {
            this.task = task;
            return this;
        }

        @Override
        public StopTaskResponse build() {
            return new StopTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
