/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a service within a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(Service::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(Service::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(Service::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .memberName("loadBalancers")
            .getter(getter(Service::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .memberName("serviceRegistries")
            .getter(getter(Service::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Service::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("desiredCount").getter(getter(Service::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("runningCount").getter(getter(Service::runningCount)).setter(setter(Builder::runningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()).build();

    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pendingCount").getter(getter(Service::pendingCount)).setter(setter(Builder::pendingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchType").getter(getter(Service::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<CapacityProviderStrategyItem>> builder(MarshallingType.LIST)
            .memberName("capacityProviderStrategy")
            .getter(getter(Service::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProviderStrategyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProviderStrategyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(Service::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> PLATFORM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformFamily").getter(getter(Service::platformFamily)).setter(setter(Builder::platformFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFamily").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinition").getter(getter(Service::taskDefinition)).setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("deploymentConfiguration")
            .getter(getter(Service::deploymentConfiguration)).setter(setter(Builder::deploymentConfiguration))
            .constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<List<TaskSet>> TASK_SETS_FIELD = SdkField
            .<List<TaskSet>> builder(MarshallingType.LIST)
            .memberName("taskSets")
            .getter(getter(Service::taskSets))
            .setter(setter(Builder::taskSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField
            .<List<Deployment>> builder(MarshallingType.LIST)
            .memberName("deployments")
            .getter(getter(Service::deployments))
            .setter(setter(Builder::deployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Deployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Deployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(Service::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<ServiceEvent>> EVENTS_FIELD = SdkField
            .<List<ServiceEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(Service::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Service::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .memberName("placementConstraints")
            .getter(getter(Service::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .memberName("placementStrategy")
            .getter(getter(Service::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(Service::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("healthCheckGracePeriodSeconds")
            .getter(getter(Service::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schedulingStrategy").getter(getter(Service::schedulingStrategyAsString))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<DeploymentController> builder(MarshallingType.SDK_POJO).memberName("deploymentController")
            .getter(getter(Service::deploymentController)).setter(setter(Builder::deploymentController))
            .constructor(DeploymentController::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(Service::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(Service::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableECSManagedTags").getter(getter(Service::enableECSManagedTags))
            .setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("propagateTags").getter(getter(Service::propagateTagsAsString)).setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableExecuteCommand").getter(getter(Service::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_REBALANCING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneRebalancing")
            .getter(getter(Service::availabilityZoneRebalancingAsString))
            .setter(setter(Builder::availabilityZoneRebalancing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneRebalancing")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            SERVICE_NAME_FIELD, CLUSTER_ARN_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, STATUS_FIELD,
            DESIRED_COUNT_FIELD, RUNNING_COUNT_FIELD, PENDING_COUNT_FIELD, LAUNCH_TYPE_FIELD, CAPACITY_PROVIDER_STRATEGY_FIELD,
            PLATFORM_VERSION_FIELD, PLATFORM_FAMILY_FIELD, TASK_DEFINITION_FIELD, DEPLOYMENT_CONFIGURATION_FIELD,
            TASK_SETS_FIELD, DEPLOYMENTS_FIELD, ROLE_ARN_FIELD, EVENTS_FIELD, CREATED_AT_FIELD, PLACEMENT_CONSTRAINTS_FIELD,
            PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD, HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD,
            SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD, CREATED_BY_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD,
            PROPAGATE_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, AVAILABILITY_ZONE_REBALANCING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceArn;

    private final String serviceName;

    private final String clusterArn;

    private final List<LoadBalancer> loadBalancers;

    private final List<ServiceRegistry> serviceRegistries;

    private final String status;

    private final Integer desiredCount;

    private final Integer runningCount;

    private final Integer pendingCount;

    private final String launchType;

    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;

    private final String platformVersion;

    private final String platformFamily;

    private final String taskDefinition;

    private final DeploymentConfiguration deploymentConfiguration;

    private final List<TaskSet> taskSets;

    private final List<Deployment> deployments;

    private final String roleArn;

    private final List<ServiceEvent> events;

    private final Instant createdAt;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final NetworkConfiguration networkConfiguration;

    private final Integer healthCheckGracePeriodSeconds;

    private final String schedulingStrategy;

    private final DeploymentController deploymentController;

    private final List<Tag> tags;

    private final String createdBy;

    private final Boolean enableECSManagedTags;

    private final String propagateTags;

    private final Boolean enableExecuteCommand;

    private final String availabilityZoneRebalancing;

    private Service(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.serviceName = builder.serviceName;
        this.clusterArn = builder.clusterArn;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.status = builder.status;
        this.desiredCount = builder.desiredCount;
        this.runningCount = builder.runningCount;
        this.pendingCount = builder.pendingCount;
        this.launchType = builder.launchType;
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.platformVersion = builder.platformVersion;
        this.platformFamily = builder.platformFamily;
        this.taskDefinition = builder.taskDefinition;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.taskSets = builder.taskSets;
        this.deployments = builder.deployments;
        this.roleArn = builder.roleArn;
        this.events = builder.events;
        this.createdAt = builder.createdAt;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.createdBy = builder.createdBy;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.availabilityZoneRebalancing = builder.availabilityZoneRebalancing;
    }

    /**
     * <p>
     * The ARN that identifies the service. For more information about the ARN format, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids"
     * >Amazon Resource Name (ARN)</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @return The ARN that identifies the service. For more information about the ARN format, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids"
     *         >Amazon Resource Name (ARN)</a> in the <i>Amazon ECS Developer Guide</i>.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
     * allowed. Service names must be unique within a cluster. However, you can have similarly named services in
     * multiple clusters within a Region or across multiple Regions.
     * </p>
     * 
     * @return The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens
     *         are allowed. Service names must be unique within a cluster. However, you can have similarly named
     *         services in multiple clusters within a Region or across multiple Regions.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster that hosts the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster that hosts the service.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name,
     * and the container port to access from the load balancer. The container name is as it appears in a container
     * definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
     *         name, and the container port to access from the load balancer. The container name is as it appears in a
     *         container definition.
     */
    public final List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceRegistries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details for the service discovery registries to assign to this service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceRegistries} method.
     * </p>
     * 
     * @return The details for the service discovery registries to assign to this service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.
     */
    public final List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
     * <code>INACTIVE</code>.
     * </p>
     * 
     * @return The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
     *         <code>INACTIVE</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The desired number of instantiations of the task definition to keep running on the service. This value is
     * specified when the service is created with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> , and
     * it can be modified with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * 
     * @return The desired number of instantiations of the task definition to keep running on the service. This value is
     *         specified when the service is created with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a>
     *         , and it can be modified with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html"
     *         >UpdateService</a>.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     */
    public final Integer runningCount() {
        return runningCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>PENDING</code> state.
     */
    public final Integer pendingCount() {
        return pendingCount;
    }

    /**
     * <p>
     * The launch type the service is using. When using the DescribeServices API, this field is omitted if the service
     * was created using a capacity provider strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type the service is using. When using the DescribeServices API, this field is omitted if the
     *         service was created using a capacity provider strategy.
     * @see LaunchType
     */
    public final LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type the service is using. When using the DescribeServices API, this field is omitted if the service
     * was created using a capacity provider strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type the service is using. When using the DescribeServices API, this field is omitted if the
     *         service was created using a capacity provider strategy.
     * @see LaunchType
     */
    public final String launchTypeAsString() {
        return launchType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviderStrategy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted if
     * the service was created using a launch type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviderStrategy} method.
     * </p>
     * 
     * @return The capacity provider strategy the service uses. When using the DescribeServices API, this field is
     *         omitted if the service was created using a launch type.
     */
    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * The platform version to run your service on. A platform version is only specified for tasks that are hosted on
     * Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version to run your service on. A platform version is only specified for tasks that are
     *         hosted on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The operating system that your tasks in the service run on. A platform family is specified only for tasks using
     * the Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX</code>).
     * </p>
     * 
     * @return The operating system that your tasks in the service run on. A platform family is specified only for tasks
     *         using the Fargate launch type. </p>
     *         <p>
     *         All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
     *         service (for example, <code>LINUX</code>).
     */
    public final String platformFamily() {
        return platformFamily;
    }

    /**
     * <p>
     * The task definition to use for tasks in the service. This value is specified when the service is created with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a>, and it
     * can be modified with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
     * </p>
     * 
     * @return The task definition to use for tasks in the service. This value is specified when the service is created
     *         with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService
     *         </a>, and it can be modified with <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html"
     *         >UpdateService</a>.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public final DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskSets() {
        return taskSets != null && !(taskSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. An
     * Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and whether
     * the task set serves production traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskSets} method.
     * </p>
     * 
     * @return Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
     *         deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks
     *         are running, and whether the task set serves production traffic.
     */
    public final List<TaskSet> taskSets() {
        return taskSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deployments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeployments() {
        return deployments != null && !(deployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current state of deployments for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeployments} method.
     * </p>
     * 
     * @return The current state of deployments for the service.
     */
    public final List<Deployment> deployments() {
        return deployments;
    }

    /**
     * <p>
     * The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent to register
     * container instances with an Elastic Load Balancing load balancer.
     * </p>
     * 
     * @return The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent to
     *         register container instances with an Elastic Load Balancing load balancer.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Events property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event stream for your service. A maximum of 100 of the latest events are displayed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvents} method.
     * </p>
     * 
     * @return The event stream for your service. A maximum of 100 of the latest events are displayed.
     */
    public final List<ServiceEvent> events() {
        return events;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the service was created.
     * </p>
     * 
     * @return The Unix timestamp for the time when the service was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The placement constraints for the tasks in the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return The placement constraints for the tasks in the service.
     */
    public final List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementStrategy property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementStrategy() {
        return placementStrategy != null && !(placementStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The placement strategy that determines how tasks for the service are placed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementStrategy} method.
     * </p>
     * 
     * @return The placement strategy that determines how tasks for the service are placed.
     */
    public final List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
     * using the <code>awsvpc</code> networking mode.
     * </p>
     * 
     * @return The VPC subnet and security group configuration for tasks that receive their own elastic network
     *         interface by using the <code>awsvpc</code> networking mode.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing
     * target health checks after a task has first started.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
     *         Balancing target health checks after a task has first started.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance.
     * This task meets all of the task placement constraints that you specify in your cluster. The service scheduler
     * also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the placement
     * constraints.
     * </p>
     * <note>
     * <p>
     * Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance. This task meets all of the task placement constraints that you specify in your cluster. The
     *         service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that
     *         don't meet the placement constraints.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public final SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container instance.
     * This task meets all of the task placement constraints that you specify in your cluster. The service scheduler
     * also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the placement
     * constraints.
     * </p>
     * <note>
     * <p>
     * Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
     *         instance. This task meets all of the task placement constraints that you specify in your cluster. The
     *         service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that
     *         don't meet the placement constraints.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public final String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The deployment controller type the service is using.
     * </p>
     * 
     * @return The deployment controller type the service is using.
     */
    public final DeploymentController deploymentController() {
        return deploymentController;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key
     * and an optional value. You define bot the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the service to help you categorize and organize them. Each tag consists of
     *         a key and an optional value. You define bot the key and value.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The principal that created the service.
     * </p>
     * 
     * @return The principal that created the service.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
     * Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
     *         Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.
     * @see PropagateTags
     */
    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags aren't propagated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Determines whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags aren't propagated.
     * @see PropagateTags
     */
    public final String propagateTagsAsString() {
        return propagateTags;
    }

    /**
     * <p>
     * Determines whether the execute command functionality is turned on for the service. If <code>true</code>, the
     * execute command functionality is turned on for all containers in tasks as part of the service.
     * </p>
     * 
     * @return Determines whether the execute command functionality is turned on for the service. If <code>true</code>,
     *         the execute command functionality is turned on for all containers in tasks as part of the service.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     * @see AvailabilityZoneRebalancing
     */
    public final AvailabilityZoneRebalancing availabilityZoneRebalancing() {
        return AvailabilityZoneRebalancing.fromValue(availabilityZoneRebalancing);
    }

    /**
     * <p>
     * Indicates whether to use Availability Zone rebalancing for the service.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an Amazon
     * ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #availabilityZoneRebalancing} will return {@link AvailabilityZoneRebalancing#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #availabilityZoneRebalancingAsString}.
     * </p>
     * 
     * @return Indicates whether to use Availability Zone rebalancing for the service.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
     *         Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer
     *         Guide</i>.
     * @see AvailabilityZoneRebalancing
     */
    public final String availabilityZoneRebalancingAsString() {
        return availabilityZoneRebalancing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceRegistries() ? serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(platformFamily());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskSets() ? taskSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeployments() ? deployments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategy() ? placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneRebalancingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(clusterArn(), other.clusterArn()) && hasLoadBalancers() == other.hasLoadBalancers()
                && Objects.equals(loadBalancers(), other.loadBalancers())
                && hasServiceRegistries() == other.hasServiceRegistries()
                && Objects.equals(serviceRegistries(), other.serviceRegistries()) && Objects.equals(status(), other.status())
                && Objects.equals(desiredCount(), other.desiredCount()) && Objects.equals(runningCount(), other.runningCount())
                && Objects.equals(pendingCount(), other.pendingCount())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(platformFamily(), other.platformFamily())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && hasTaskSets() == other.hasTaskSets() && Objects.equals(taskSets(), other.taskSets())
                && hasDeployments() == other.hasDeployments() && Objects.equals(deployments(), other.deployments())
                && Objects.equals(roleArn(), other.roleArn()) && hasEvents() == other.hasEvents()
                && Objects.equals(events(), other.events()) && Objects.equals(createdAt(), other.createdAt())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategy() == other.hasPlacementStrategy()
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(deploymentController(), other.deploymentController()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(availabilityZoneRebalancingAsString(), other.availabilityZoneRebalancingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("ServiceArn", serviceArn()).add("ServiceName", serviceName())
                .add("ClusterArn", clusterArn()).add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null)
                .add("ServiceRegistries", hasServiceRegistries() ? serviceRegistries() : null).add("Status", status())
                .add("DesiredCount", desiredCount()).add("RunningCount", runningCount()).add("PendingCount", pendingCount())
                .add("LaunchType", launchTypeAsString())
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("PlatformVersion", platformVersion()).add("PlatformFamily", platformFamily())
                .add("TaskDefinition", taskDefinition()).add("DeploymentConfiguration", deploymentConfiguration())
                .add("TaskSets", hasTaskSets() ? taskSets() : null).add("Deployments", hasDeployments() ? deployments() : null)
                .add("RoleArn", roleArn()).add("Events", hasEvents() ? events() : null).add("CreatedAt", createdAt())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategy", hasPlacementStrategy() ? placementStrategy() : null)
                .add("NetworkConfiguration", networkConfiguration())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("SchedulingStrategy", schedulingStrategyAsString()).add("DeploymentController", deploymentController())
                .add("Tags", hasTags() ? tags() : null).add("CreatedBy", createdBy())
                .add("EnableECSManagedTags", enableECSManagedTags()).add("PropagateTags", propagateTagsAsString())
                .add("EnableExecuteCommand", enableExecuteCommand())
                .add("AvailabilityZoneRebalancing", availabilityZoneRebalancingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "runningCount":
            return Optional.ofNullable(clazz.cast(runningCount()));
        case "pendingCount":
            return Optional.ofNullable(clazz.cast(pendingCount()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "capacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "platformFamily":
            return Optional.ofNullable(clazz.cast(platformFamily()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "taskSets":
            return Optional.ofNullable(clazz.cast(taskSets()));
        case "deployments":
            return Optional.ofNullable(clazz.cast(deployments()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "deploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        case "enableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "availabilityZoneRebalancing":
            return Optional.ofNullable(clazz.cast(availabilityZoneRebalancingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("loadBalancers", LOAD_BALANCERS_FIELD);
        map.put("serviceRegistries", SERVICE_REGISTRIES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("desiredCount", DESIRED_COUNT_FIELD);
        map.put("runningCount", RUNNING_COUNT_FIELD);
        map.put("pendingCount", PENDING_COUNT_FIELD);
        map.put("launchType", LAUNCH_TYPE_FIELD);
        map.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
        map.put("platformVersion", PLATFORM_VERSION_FIELD);
        map.put("platformFamily", PLATFORM_FAMILY_FIELD);
        map.put("taskDefinition", TASK_DEFINITION_FIELD);
        map.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("taskSets", TASK_SETS_FIELD);
        map.put("deployments", DEPLOYMENTS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("events", EVENTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
        map.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("healthCheckGracePeriodSeconds", HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD);
        map.put("schedulingStrategy", SCHEDULING_STRATEGY_FIELD);
        map.put("deploymentController", DEPLOYMENT_CONTROLLER_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
        map.put("propagateTags", PROPAGATE_TAGS_FIELD);
        map.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
        map.put("availabilityZoneRebalancing", AVAILABILITY_ZONE_REBALANCING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The ARN that identifies the service. For more information about the ARN format, see <a href=
         * "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids"
         * >Amazon Resource Name (ARN)</a> in the <i>Amazon ECS Developer Guide</i>.
         * </p>
         * 
         * @param serviceArn
         *        The ARN that identifies the service. For more information about the ARN format, see <a href=
         *        "https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids"
         *        >Amazon Resource Name (ARN)</a> in the <i>Amazon ECS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are
         * allowed. Service names must be unique within a cluster. However, you can have similarly named services in
         * multiple clusters within a Region or across multiple Regions.
         * </p>
         * 
         * @param serviceName
         *        The name of your service. Up to 255 letters (uppercase and lowercase), numbers, underscores, and
         *        hyphens are allowed. Service names must be unique within a cluster. However, you can have similarly
         *        named services in multiple clusters within a Region or across multiple Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster that hosts the service.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster that hosts the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the
         *        container name, and the container port to access from the load balancer. The container name is as it
         *        appears in a container definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container
         * name, and the container port to access from the load balancer. The container name is as it appears in a
         * container definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.LoadBalancer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.LoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details for the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details for the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceRegistry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(java.util.Collection<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
         * <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
         *        <code>INACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The desired number of instantiations of the task definition to keep running on the service. This value is
         * specified when the service is created with <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> ,
         * and it can be modified with <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
         * </p>
         * 
         * @param desiredCount
         *        The desired number of instantiations of the task definition to keep running on the service. This value
         *        is specified when the service is created with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a> , and it can be modified with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html"
         *        >UpdateService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * </p>
         * 
         * @param runningCount
         *        The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningCount(Integer runningCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * </p>
         * 
         * @param pendingCount
         *        The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCount(Integer pendingCount);

        /**
         * <p>
         * The launch type the service is using. When using the DescribeServices API, this field is omitted if the
         * service was created using a capacity provider strategy.
         * </p>
         * 
         * @param launchType
         *        The launch type the service is using. When using the DescribeServices API, this field is omitted if
         *        the service was created using a capacity provider strategy.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type the service is using. When using the DescribeServices API, this field is omitted if the
         * service was created using a capacity provider strategy.
         * </p>
         * 
         * @param launchType
         *        The launch type the service is using. When using the DescribeServices API, this field is omitted if
         *        the service was created using a capacity provider strategy.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted
         * if the service was created using a launch type.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy the service uses. When using the DescribeServices API, this field is
         *        omitted if the service was created using a launch type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted
         * if the service was created using a launch type.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy the service uses. When using the DescribeServices API, this field is
         *        omitted if the service was created using a launch type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy the service uses. When using the DescribeServices API, this field is omitted
         * if the service was created using a launch type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityProviderStrategy(List<CapacityProviderStrategyItem>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(java.util.Collection<CapacityProviderStrategyItem>)
         */
        Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * The platform version to run your service on. A platform version is only specified for tasks that are hosted
         * on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more information,
         * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         * Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version to run your service on. A platform version is only specified for tasks that are
         *        hosted on Fargate. If one isn't specified, the <code>LATEST</code> platform version is used. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The operating system that your tasks in the service run on. A platform family is specified only for tasks
         * using the Fargate launch type.
         * </p>
         * <p>
         * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
         * (for example, <code>LINUX</code>).
         * </p>
         * 
         * @param platformFamily
         *        The operating system that your tasks in the service run on. A platform family is specified only for
         *        tasks using the Fargate launch type. </p>
         *        <p>
         *        All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
         *        service (for example, <code>LINUX</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFamily(String platformFamily);

        /**
         * <p>
         * The task definition to use for tasks in the service. This value is specified when the service is created with
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a>,
         * and it can be modified with <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html">UpdateService</a>.
         * </p>
         * 
         * @param taskDefinition
         *        The task definition to use for tasks in the service. This value is specified when the service is
         *        created with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html"
         *        >CreateService</a>, and it can be modified with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_UpdateService.html"
         *        >UpdateService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment.
         * An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and
         * whether the task set serves production traffic.
         * </p>
         * 
         * @param taskSets
         *        Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
         *        deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many
         *        tasks are running, and whether the task set serves production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(Collection<TaskSet> taskSets);

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment.
         * An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and
         * whether the task set serves production traffic.
         * </p>
         * 
         * @param taskSets
         *        Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
         *        deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many
         *        tasks are running, and whether the task set serves production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(TaskSet... taskSets);

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment.
         * An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and
         * whether the task set serves production traffic.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.TaskSet.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.TaskSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.TaskSet.Builder#build()} is called immediately and its
         * result is passed to {@link #taskSets(List<TaskSet>)}.
         * 
         * @param taskSets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.TaskSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSets(java.util.Collection<TaskSet>)
         */
        Builder taskSets(Consumer<TaskSet.Builder>... taskSets);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * 
         * @param deployments
         *        The current state of deployments for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<Deployment> deployments);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * 
         * @param deployments
         *        The current state of deployments for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Deployment... deployments);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Deployment.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.ecs.model.Deployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.Deployment.Builder#build()} is called immediately and its
         * result is passed to {@link #deployments(List<Deployment>)}.
         * 
         * @param deployments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.Deployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployments(java.util.Collection<Deployment>)
         */
        Builder deployments(Consumer<Deployment.Builder>... deployments);

        /**
         * <p>
         * The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent to
         * register container instances with an Elastic Load Balancing load balancer.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that's associated with the service. It allows the Amazon ECS container agent
         *        to register container instances with an Elastic Load Balancing load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * 
         * @param events
         *        The event stream for your service. A maximum of 100 of the latest events are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<ServiceEvent> events);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * 
         * @param events
         *        The event stream for your service. A maximum of 100 of the latest events are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(ServiceEvent... events);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ServiceEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ServiceEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ServiceEvent.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<ServiceEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ServiceEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(java.util.Collection<ServiceEvent>)
         */
        Builder events(Consumer<ServiceEvent.Builder>... events);

        /**
         * <p>
         * The Unix timestamp for the time when the service was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for the time when the service was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementConstraint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy that determines how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy that determines how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder#build()} is called immediately and
         * its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.PlacementStrategy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(java.util.Collection<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
         * using the <code>awsvpc</code> networking mode.
         * </p>
         * 
         * @param networkConfiguration
         *        The VPC subnet and security group configuration for tasks that receive their own elastic network
         *        interface by using the <code>awsvpc</code> networking mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
         * using the <code>awsvpc</code> networking mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         * Balancing target health checks after a task has first started.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         *        Balancing target health checks after a task has first started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         * instance. This task meets all of the task placement constraints that you specify in your cluster. The service
         * scheduler also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the
         * placement constraints.
         * </p>
         * <note>
         * <p>
         * Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance. This task meets all of the task placement constraints that you specify in your cluster. The
         *        service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that
         *        don't meet the placement constraints.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         * instance. This task meets all of the task placement constraints that you specify in your cluster. The service
         * scheduler also evaluates the task placement constraints for running tasks. It stop tasks that don't meet the
         * placement constraints.
         * </p>
         * <note>
         * <p>
         * Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each active container
         *        instance. This task meets all of the task placement constraints that you specify in your cluster. The
         *        service scheduler also evaluates the task placement constraints for running tasks. It stop tasks that
         *        don't meet the placement constraints.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate tasks don't support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The deployment controller type the service is using.
         * </p>
         * 
         * @param deploymentController
         *        The deployment controller type the service is using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(DeploymentController deploymentController);

        /**
         * <p>
         * The deployment controller type the service is using.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentController.Builder} avoiding
         * the need to create one manually via {@link DeploymentController#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentController.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentController(DeploymentController)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link DeploymentController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(DeploymentController)
         */
        default Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return deploymentController(DeploymentController.builder().applyMutation(deploymentController).build());
        }

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define bot the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value. You define bot the key and value.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define bot the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value. You define bot the key and value.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or
         *        delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per
         *        resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value. You define bot the key and value.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys
         * or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The principal that created the service.
         * </p>
         * 
         * @param createdBy
         *        The principal that created the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon
         * ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Determines whether to use Amazon ECS managed tags for the tasks in the service. For more information,
         *        see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging
         *        Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags aren't propagated.
         * </p>
         * 
         * @param propagateTags
         *        Determines whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags aren't propagated.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);

        /**
         * <p>
         * Determines whether the execute command functionality is turned on for the service. If <code>true</code>, the
         * execute command functionality is turned on for all containers in tasks as part of the service.
         * </p>
         * 
         * @param enableExecuteCommand
         *        Determines whether the execute command functionality is turned on for the service. If
         *        <code>true</code>, the execute command functionality is turned on for all containers in tasks as part
         *        of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(String availabilityZoneRebalancing);

        /**
         * <p>
         * Indicates whether to use Availability Zone rebalancing for the service.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing an
         * Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service Developer
         * Guide</i>.
         * </p>
         * 
         * @param availabilityZoneRebalancing
         *        Indicates whether to use Availability Zone rebalancing for the service.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">Balancing
         *        an Amazon ECS service across Availability Zones</a> in the <i>Amazon Elastic Container Service
         *        Developer Guide</i>.
         * @see AvailabilityZoneRebalancing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneRebalancing
         */
        Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing);
    }

    static final class BuilderImpl implements Builder {
        private String serviceArn;

        private String serviceName;

        private String clusterArn;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Integer desiredCount;

        private Integer runningCount;

        private Integer pendingCount;

        private String launchType;

        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private String platformFamily;

        private String taskDefinition;

        private DeploymentConfiguration deploymentConfiguration;

        private List<TaskSet> taskSets = DefaultSdkAutoConstructList.getInstance();

        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private List<ServiceEvent> events = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private NetworkConfiguration networkConfiguration;

        private Integer healthCheckGracePeriodSeconds;

        private String schedulingStrategy;

        private DeploymentController deploymentController;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String createdBy;

        private Boolean enableECSManagedTags;

        private String propagateTags;

        private Boolean enableExecuteCommand;

        private String availabilityZoneRebalancing;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            serviceArn(model.serviceArn);
            serviceName(model.serviceName);
            clusterArn(model.clusterArn);
            loadBalancers(model.loadBalancers);
            serviceRegistries(model.serviceRegistries);
            status(model.status);
            desiredCount(model.desiredCount);
            runningCount(model.runningCount);
            pendingCount(model.pendingCount);
            launchType(model.launchType);
            capacityProviderStrategy(model.capacityProviderStrategy);
            platformVersion(model.platformVersion);
            platformFamily(model.platformFamily);
            taskDefinition(model.taskDefinition);
            deploymentConfiguration(model.deploymentConfiguration);
            taskSets(model.taskSets);
            deployments(model.deployments);
            roleArn(model.roleArn);
            events(model.events);
            createdAt(model.createdAt);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            networkConfiguration(model.networkConfiguration);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            schedulingStrategy(model.schedulingStrategy);
            deploymentController(model.deploymentController);
            tags(model.tags);
            createdBy(model.createdBy);
            enableECSManagedTags(model.enableECSManagedTags);
            propagateTags(model.propagateTags);
            enableExecuteCommand(model.enableExecuteCommand);
            availabilityZoneRebalancing(model.availabilityZoneRebalancing);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<LoadBalancer.Builder> getLoadBalancers() {
            List<LoadBalancer.Builder> result = LoadBalancersCopier.copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceRegistry.Builder> getServiceRegistries() {
            List<ServiceRegistry.Builder> result = ServiceRegistriesCopier.copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final Integer getRunningCount() {
            return runningCount;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final Integer getPendingCount() {
            return pendingCount;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier
                    .copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(
                Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> CapacityProviderStrategyItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPlatformFamily() {
            return platformFamily;
        }

        public final void setPlatformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
        }

        @Override
        public final Builder platformFamily(String platformFamily) {
            this.platformFamily = platformFamily;
            return this;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final List<TaskSet.Builder> getTaskSets() {
            List<TaskSet.Builder> result = TaskSetsCopier.copyToBuilder(this.taskSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskSets(Collection<TaskSet.BuilderImpl> taskSets) {
            this.taskSets = TaskSetsCopier.copyFromBuilder(taskSets);
        }

        @Override
        public final Builder taskSets(Collection<TaskSet> taskSets) {
            this.taskSets = TaskSetsCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(TaskSet... taskSets) {
            taskSets(Arrays.asList(taskSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(Consumer<TaskSet.Builder>... taskSets) {
            taskSets(Stream.of(taskSets).map(c -> TaskSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Deployment.Builder> getDeployments() {
            List<Deployment.Builder> result = DeploymentsCopier.copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment... deployments) {
            deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder>... deployments) {
            deployments(Stream.of(deployments).map(c -> Deployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<ServiceEvent.Builder> getEvents() {
            List<ServiceEvent.Builder> result = ServiceEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<ServiceEvent.BuilderImpl> events) {
            this.events = ServiceEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<ServiceEvent> events) {
            this.events = ServiceEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ServiceEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ServiceEvent.Builder>... events) {
            events(Stream.of(events).map(c -> ServiceEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final String getAvailabilityZoneRebalancing() {
            return availabilityZoneRebalancing;
        }

        public final void setAvailabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
        }

        @Override
        public final Builder availabilityZoneRebalancing(String availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing = availabilityZoneRebalancing;
            return this;
        }

        @Override
        public final Builder availabilityZoneRebalancing(AvailabilityZoneRebalancing availabilityZoneRebalancing) {
            this.availabilityZoneRebalancing(availabilityZoneRebalancing == null ? null : availabilityZoneRebalancing.toString());
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
