/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A regional grouping of one or more container instances on which you can run task requests. Each account receives a
 * default cluster the first time you use the Amazon ECS service, but you may also create other clusters. Clusters may
 * contain more than one instance type simultaneously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Cluster implements SdkPojo, Serializable, ToCopyableBuilder<Cluster.Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Cluster::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::registeredContainerInstancesCount))
            .setter(setter(Builder::registeredContainerInstancesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount")
                    .build()).build();

    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::runningTasksCount)).setter(setter(Builder::runningTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()).build();

    private static final SdkField<Integer> PENDING_TASKS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::pendingTasksCount)).setter(setter(Builder::pendingTasksCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTasksCount").build()).build();

    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Cluster::activeServicesCount)).setter(setter(Builder::activeServicesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build())
            .build();

    private static final SdkField<List<KeyValuePair>> STATISTICS_FIELD = SdkField
            .<List<KeyValuePair>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::statistics))
            .setter(setter(Builder::statistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Cluster::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_NAME_FIELD, STATUS_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD,
            PENDING_TASKS_COUNT_FIELD, ACTIVE_SERVICES_COUNT_FIELD, STATISTICS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final String clusterName;

    private final String status;

    private final Integer registeredContainerInstancesCount;

    private final Integer runningTasksCount;

    private final Integer pendingTasksCount;

    private final Integer activeServicesCount;

    private final List<KeyValuePair> statistics;

    private final List<Tag> tags;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.status = builder.status;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.pendingTasksCount = builder.pendingTasksCount;
        this.activeServicesCount = builder.activeServicesCount;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code>
     * namespace, followed by the Region of the cluster, the AWS account ID of the cluster owner, the
     * <code>cluster</code> namespace, and then the cluster name. For example,
     * <code>arn:aws:ecs:<i>region</i>:<i>012345678910</i>:cluster/<i>test</i> </code>..
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code>
     *         namespace, followed by the Region of the cluster, the AWS account ID of the cluster owner, the
     *         <code>cluster</code> namespace, and then the cluster name. For example,
     *         <code>arn:aws:ecs:<i>region</i>:<i>012345678910</i>:cluster/<i>test</i> </code>..
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * A user-generated string that you use to identify your cluster.
     * </p>
     * 
     * @return A user-generated string that you use to identify your cluster.
     */
    public String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The status of the cluster. The valid values are <code>ACTIVE</code> or <code>INACTIVE</code>. <code>ACTIVE</code>
     * indicates that you can register container instances with the cluster and the associated instances can accept
     * tasks.
     * </p>
     * 
     * @return The status of the cluster. The valid values are <code>ACTIVE</code> or <code>INACTIVE</code>.
     *         <code>ACTIVE</code> indicates that you can register container instances with the cluster and the
     *         associated instances can accept tasks.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The number of container instances registered into the cluster. This includes container instances in both
     * <code>ACTIVE</code> and <code>DRAINING</code> status.
     * </p>
     * 
     * @return The number of container instances registered into the cluster. This includes container instances in both
     *         <code>ACTIVE</code> and <code>DRAINING</code> status.
     */
    public Integer registeredContainerInstancesCount() {
        return registeredContainerInstancesCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     */
    public Integer runningTasksCount() {
        return runningTasksCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>PENDING</code> state.
     */
    public Integer pendingTasksCount() {
        return pendingTasksCount;
    }

    /**
     * <p>
     * The number of services that are running on the cluster in an <code>ACTIVE</code> state. You can view these
     * services with <a>ListServices</a>.
     * </p>
     * 
     * @return The number of services that are running on the cluster in an <code>ACTIVE</code> state. You can view
     *         these services with <a>ListServices</a>.
     */
    public Integer activeServicesCount() {
        return activeServicesCount;
    }

    /**
     * <p>
     * Additional information about your clusters that are separated by launch type, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * runningEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * RunningFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingEC2TasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * pendingFargateTasksCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * activeFargateServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingEC2ServiceCount
     * </p>
     * </li>
     * <li>
     * <p>
     * drainingFargateServiceCount
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional information about your clusters that are separated by launch type, including:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         runningEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RunningFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingEC2TasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         pendingFargateTasksCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         activeFargateServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingEC2ServiceCount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         drainingFargateServiceCount
     *         </p>
     *         </li>
     */
    public List<KeyValuePair> statistics() {
        return statistics;
    }

    /**
     * <p>
     * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key
     * and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters,
     * and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of
     *         a key and an optional value, both of which you define. Tag keys can have a maximum character length of
     *         128 characters, and tag values can have a maximum length of 256 characters.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(status(), other.status())
                && Objects.equals(registeredContainerInstancesCount(), other.registeredContainerInstancesCount())
                && Objects.equals(runningTasksCount(), other.runningTasksCount())
                && Objects.equals(pendingTasksCount(), other.pendingTasksCount())
                && Objects.equals(activeServicesCount(), other.activeServicesCount())
                && Objects.equals(statistics(), other.statistics()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("Cluster").add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("Status", status()).add("RegisteredContainerInstancesCount", registeredContainerInstancesCount())
                .add("RunningTasksCount", runningTasksCount()).add("PendingTasksCount", pendingTasksCount())
                .add("ActiveServicesCount", activeServicesCount()).add("Statistics", statistics()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "registeredContainerInstancesCount":
            return Optional.ofNullable(clazz.cast(registeredContainerInstancesCount()));
        case "runningTasksCount":
            return Optional.ofNullable(clazz.cast(runningTasksCount()));
        case "pendingTasksCount":
            return Optional.ofNullable(clazz.cast(pendingTasksCount()));
        case "activeServicesCount":
            return Optional.ofNullable(clazz.cast(activeServicesCount()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Cluster> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the <code>arn:aws:ecs</code>
         * namespace, followed by the Region of the cluster, the AWS account ID of the cluster owner, the
         * <code>cluster</code> namespace, and then the cluster name. For example,
         * <code>arn:aws:ecs:<i>region</i>:<i>012345678910</i>:cluster/<i>test</i> </code>..
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) that identifies the cluster. The ARN contains the
         *        <code>arn:aws:ecs</code> namespace, followed by the Region of the cluster, the AWS account ID of the
         *        cluster owner, the <code>cluster</code> namespace, and then the cluster name. For example,
         *        <code>arn:aws:ecs:<i>region</i>:<i>012345678910</i>:cluster/<i>test</i> </code>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * A user-generated string that you use to identify your cluster.
         * </p>
         * 
         * @param clusterName
         *        A user-generated string that you use to identify your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The status of the cluster. The valid values are <code>ACTIVE</code> or <code>INACTIVE</code>.
         * <code>ACTIVE</code> indicates that you can register container instances with the cluster and the associated
         * instances can accept tasks.
         * </p>
         * 
         * @param status
         *        The status of the cluster. The valid values are <code>ACTIVE</code> or <code>INACTIVE</code>.
         *        <code>ACTIVE</code> indicates that you can register container instances with the cluster and the
         *        associated instances can accept tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of container instances registered into the cluster. This includes container instances in both
         * <code>ACTIVE</code> and <code>DRAINING</code> status.
         * </p>
         * 
         * @param registeredContainerInstancesCount
         *        The number of container instances registered into the cluster. This includes container instances in
         *        both <code>ACTIVE</code> and <code>DRAINING</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * </p>
         * 
         * @param runningTasksCount
         *        The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningTasksCount(Integer runningTasksCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * </p>
         * 
         * @param pendingTasksCount
         *        The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingTasksCount(Integer pendingTasksCount);

        /**
         * <p>
         * The number of services that are running on the cluster in an <code>ACTIVE</code> state. You can view these
         * services with <a>ListServices</a>.
         * </p>
         * 
         * @param activeServicesCount
         *        The number of services that are running on the cluster in an <code>ACTIVE</code> state. You can view
         *        these services with <a>ListServices</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeServicesCount(Integer activeServicesCount);

        /**
         * <p>
         * Additional information about your clusters that are separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * RunningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        Additional information about your clusters that are separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RunningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<KeyValuePair> statistics);

        /**
         * <p>
         * Additional information about your clusters that are separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * RunningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * 
         * @param statistics
         *        Additional information about your clusters that are separated by launch type, including:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        runningEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RunningFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingEC2TasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        pendingFargateTasksCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        activeFargateServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingEC2ServiceCount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        drainingFargateServiceCount
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(KeyValuePair... statistics);

        /**
         * <p>
         * Additional information about your clusters that are separated by launch type, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * runningEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * RunningFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingEC2TasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * pendingFargateTasksCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * activeFargateServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingEC2ServiceCount
         * </p>
         * </li>
         * <li>
         * <p>
         * drainingFargateServiceCount
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<KeyValuePair>.Builder} avoiding the need to
         * create one manually via {@link List<KeyValuePair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyValuePair>.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(List<KeyValuePair>)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link List<KeyValuePair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(List<KeyValuePair>)
         */
        Builder statistics(Consumer<KeyValuePair.Builder>... statistics);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. Tag keys can have a maximum character length
         *        of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define. Tag keys can have a maximum character length
         *        of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterName;

        private String status;

        private Integer registeredContainerInstancesCount;

        private Integer runningTasksCount;

        private Integer pendingTasksCount;

        private Integer activeServicesCount;

        private List<KeyValuePair> statistics = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            status(model.status);
            registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            runningTasksCount(model.runningTasksCount);
            pendingTasksCount(model.pendingTasksCount);
            activeServicesCount(model.activeServicesCount);
            statistics(model.statistics);
            tags(model.tags);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        public final Integer getRunningTasksCount() {
            return runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        public final Integer getPendingTasksCount() {
            return pendingTasksCount;
        }

        @Override
        public final Builder pendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
            return this;
        }

        public final void setPendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
        }

        public final Integer getActiveServicesCount() {
            return activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        public final Collection<KeyValuePair.Builder> getStatistics() {
            return statistics != null ? statistics.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statistics(Collection<KeyValuePair> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(KeyValuePair... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<KeyValuePair.Builder>... statistics) {
            statistics(Stream.of(statistics).map(c -> KeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStatistics(Collection<KeyValuePair.BuilderImpl> statistics) {
            this.statistics = StatisticsCopier.copyFromBuilder(statistics);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Cluster build() {
            return new Cluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
